rem 
rem $Header: prvtpgb.sql 7020200.1 95/02/15 18:17:53 cli Generic<base> $ 
rem 
Rem  Copyright (c) 1993 by Oracle Corporation
Rem    NAME
Rem      pvrtpgb.sql - PL/SQL Package of utility routines for Procedural
Rem                   Gateway (package body) UTL_PG.
Rem
Rem    DESCRIPTION
Rem      Procedural Gateway specific routines to manipulate raws.
Rem
Rem    RETURNS
Rem
Rem    NOTES
Rem      The procedural option is needed to use this facility.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     rhari      10/27/94 -  merge changes from branch 1.1.710.2
Rem     rhari      09/28/94 -  Creation
Rem     cddavis    06/27/94 -  split from utlraw.sql package
Rem     cddavis    01/06/94 -  combined spec & body into single package
Rem     cddavis    09/21/93 -  added nlslang to formatted r/n functions
Rem     cddavis    09/09/93 -  fixed pragmas for kkxgr2nf, kkxgn2rf
Rem     cddavis    08/26/93 -  raw conversion formats
Rem     mmoore     08/12/93 -  Branch_for_the_patch
Rem   rkooi/mmoore 07/25/93 -  Creation
 
REM ********************************************************************
REM THE FUNCTIONS SUPPLIED BY THIS PACKAGE AND ITS EXTERNAL INTERFACE
REM ARE RESERVED BY ORACLE AND ARE SUBJECT TO CHANGE IN FUTURE RELEASES.
REM ********************************************************************
 
REM ********************************************************************
REM THIS PACKAGE MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO
REM COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE
REM RDBMS.  SPECIFICALLY, THE PSD* ROUTINES MUST NOT BE CALLED
REM DIRECTLY BY ANY CLIENT AND MUST REMAIN PRIVATE TO THE PACKAGE BODY.
REM ********************************************************************
 
set echo on

create or replace package body utl_pg is
 
/*------------------------------------------------------------------*/
/*  Private function interfaces to kernel                           */
/*------------------------------------------------------------------*/
 
  /*----------------------------------------------------------------*/
  /* Make_raw_to_number_format                                      */
  /*----------------------------------------------------------------*/
  function pirgmrf(mask     in varchar2,
                   maskopts in varchar2,
                   envrnmnt in varchar2,
                   compname in varchar2,
                   compopts in varchar2,
                   nlslang  in varchar2,
                   wind     in boolean,
                   wmsgbsiz in binary_integer,
                   wmsgblk  out raw) return raw;      -- max 2k bytes
    pragma interface (C, pirgmrf);
 
  /*----------------------------------------------------------------*/
  /* Make number to raw format                                      */
  /*----------------------------------------------------------------*/
  function pirgmnf(mask     in varchar2,
                   maskopts in varchar2,
                   envrnmnt in varchar2,
                   compname in varchar2,
                   compopts in varchar2,
                   nlslang  in varchar2,
                   wind     in boolean,
                   wmsgbsiz in binary_integer,
                   wmsgblk  out raw) return raw;      -- max 2k bytes
    pragma interface (C, pirgmnf);
 
  /*----------------------------------------------------------------*/
  /* Raw to number                                                  */
  /*----------------------------------------------------------------*/
  function pirgr2n(r        in raw,
                   mask     in varchar2,
                   maskopts in varchar2,
                   envrnmnt in varchar2,
                   compname in varchar2,
                   compopts in varchar2,
                   nlslang  in varchar2,
                   wind     in boolean,
                   wmsgbsiz in binary_integer,
                   wmsgblk  out raw) return number;
    -- pirgr2n assumes 3+ args => un-formatted type call
    pragma interface (C, pirgr2n);
 
  /*----------------------------------------------------------------*/
  /* Number to raw                                                  */
  /*----------------------------------------------------------------*/
  function pirgn2r(n        in number,
                   mask     in varchar2,
                   maskopts in varchar2,
                   envrnmnt in varchar2,
                   compname in varchar2,
                   compopts in varchar2,
                   nlslang  in varchar2,
                   wind     in boolean,
                   wmsgbsiz in binary_integer,
                   wmsgblk  out raw) return raw;
    -- pirgn2r assumes 3+ args => un-formatted type call
    pragma interface (C, pirgn2r);
 
  /*----------------------------------------------------------------*/
  /* Raw to number formatted                                        */
  /*----------------------------------------------------------------*/
  function pirgr2f(rawval in raw,
                    r2nfmt in raw) return number;
    -- ICD vector transfers to pirgr2n
    -- pirgr2n assumes 2 args => formatted type call
    pragma interface (C, pirgr2f);
 
  /*----------------------------------------------------------------*/
  /* Number to raw formatted                                        */
  /*----------------------------------------------------------------*/
  function pirgn2f(numval in number,
                    n2rfmt in raw) return raw;
    -- ICD vector transfers to pirgn2r
    -- pirgn2r assumes 2 args => formatted type call
    pragma interface (C, pirgn2f);
 
  /*----------------------------------------------------------------*/
  /*  WMSGCNT
  /*----------------------------------------------------------------*/
  function pirgwcnt(wmsgblk in raw) return binary_integer;
    -- ICD vector transfers to pirgwcnt
    -- pirgwcnt assumes 1 args => formatted type call
    pragma interface (C, pirgwcnt);
 
  /*----------------------------------------------------------------*/
  /*  WMSG
  /*----------------------------------------------------------------*/
  function pirgwmsg(wmsgblk  in  raw,
                    wmsgitem in  binary_integer,
                    wmsgno   out binary_integer,
                    wmsgtext out varchar2,
                    wmsgfill out varchar2) return binary_integer;
    -- ICD vector transfers to pirgwmsg
    -- pirgwmsg assumes 1 args => formatted type call
    pragma interface (C, pirgwmsg);
 
/*------------------------------------------------------------------*/
/*  Public functions specified in utl_pg                            */
/*------------------------------------------------------------------*/
 
  /*----------------------------------------------------------------*/
  /* RAW_TO_NUMBER                                                  */
  /*----------------------------------------------------------------*/
  function raw_to_number(r        in raw,
                         mask     in varchar2,
                         maskopts in varchar2,
                         envrnmnt in varchar2,
                         compname in varchar2,
                         compopts in varchar2,
                         nlslang  in varchar2,
                         wind     in boolean,
                         wmsgbsiz in binary_integer,
                         wmsgblk  out raw) return number is
  begin
    return pirgr2n(r,
                   mask,
                   maskopts,
                   envrnmnt,
                   compname,
                   compopts,
                   nlslang,
                   wind,
                   wmsgbsiz,
                   wmsgblk);
  end;
 
  /*----------------------------------------------------------------*/
  /* NUMBER_TO_RAW                                                  */
  /*----------------------------------------------------------------*/
  function number_to_raw(n        in number,
                         mask     in varchar2,
                         maskopts in varchar2,
                         envrnmnt in varchar2,
                         compname in varchar2,
                         compopts in varchar2,
                         nlslang  in varchar2,
                         wind     in boolean,
                         wmsgbsiz in binary_integer,
                         wmsgblk  out raw) return raw is
  begin
    return pirgn2r(n,
                   mask,
                   maskopts,
                   envrnmnt,
                   compname,
                   compopts,
                   nlslang,
                   wind,
                   wmsgbsiz,
                   wmsgblk);
  end;
 
  /*----------------------------------------------------------------*/
  /* MAKE_RAW_TO_NUMBER_FORMAT                                      */
  /*----------------------------------------------------------------*/
  function make_raw_to_number_format(mask in varchar2,
                   maskopts in varchar2,
                   envrnmnt in varchar2,
                   compname in varchar2,
                   compopts in varchar2,
                   nlslang  in varchar2,
                   wind     in boolean,
                   wmsgbsiz in binary_integer,
                   wmsgblk  out raw) return raw is
  begin
    return pirgmrf(mask,
                   maskopts,
                   envrnmnt,
                   compname,
                   compopts,
                   nlslang,
                   wind,
                   wmsgbsiz,
                   wmsgblk);
  end;
 
  /*----------------------------------------------------------------*/
  /* MAKE_NUMBER_TO_RAW_FORMAT                                      */
  /*----------------------------------------------------------------*/
  function make_number_to_raw_format(mask in varchar2,
                   maskopts in varchar2,
                   envrnmnt in varchar2,
                   compname in varchar2,
                   compopts in varchar2,
                   nlslang  in varchar2,
                   wind     in boolean,
                   wmsgbsiz in binary_integer,
                   wmsgblk  out raw) return raw is
  begin
    return pirgmnf(mask,
                   maskopts,
                   envrnmnt,
                   compname,
                   compopts,
                   nlslang,
                   wind,
                   wmsgbsiz,
                   wmsgblk);
  end;
 
  /*----------------------------------------------------------------*/
  /* RAW_TO_NUMBER_FORMAT                                           */
  /*----------------------------------------------------------------*/
  function raw_to_number_format(rawval in raw,
                                r2nfmt in raw) return number is
  begin
    return pirgr2f(rawval,
                    r2nfmt);
  end;
 
  /*----------------------------------------------------------------*/
  /* NUMBER_TO_RAW_FORMAT                                           */
  /*----------------------------------------------------------------*/
  function number_to_raw_format(numval in number,
                                n2rfmt in raw) return raw is
  begin
    return pirgn2f(numval,
                    n2rfmt);
  end;
 
  /*----------------------------------------------------------------*/
  /* WMSGCNT                                                        */
  /*----------------------------------------------------------------*/
  function wmsgcnt(wmsgblk in raw) return binary_integer is
  begin
    return pirgwcnt(wmsgblk);
  end;
 
  /*----------------------------------------------------------------*/
  /* WMSG                                                           */
  /*----------------------------------------------------------------*/
  function wmsg(wmsgblk  in  raw,
                wmsgitem in  binary_integer,
                wmsgno   out binary_integer,
                wmsgtext out varchar2,
                wmsgfill out varchar2) return binary_integer is
  begin
    return pirgwmsg(wmsgblk,
                    wmsgitem,
                    wmsgno,
                    wmsgtext,
                    wmsgfill);
  end;
 
end utl_pg;
/
show errors
drop public synonym utl_pg
/
create public synonym utl_pg for sys.utl_pg
/
grant execute on sys.utl_pg to public
/
