window.addEventListener( "load", function() {

  var timeoutPwdCC = null;
  var strPswdPrev = null;
  var fPwdMatch = true;
  var fPwdCCPass = true;

  function comparePasswords()
  {
    const elRes = document.getElementById( "pwdcomp-result" );
    const strPswd = document.getElementById( "password" ).value;
    const strPswd2 = document.getElementById( "password2" ).value;

    fPwdMatch = strPswd == document.getElementById( "password2" ).value;
    utilVldrtCheck();

    if ( strPswd && strPswd2 && !fPwdMatch )
      elRes.classList.add( "peRowCtl__ctlPwdCCRes-visible" );
    else
      elRes.classList.remove( "peRowCtl__ctlPwdCCRes-visible" );
  }  // comparePasswords()

  function pwdCC(strPswd)
  {
    if ( strPswd == strPswdPrev )
      return;

    utilAJAX( "ajax_pwdcc?p=" + encodeURIComponent( strPswd ),
      function(xmlRoot) {
        const strResult = utilGetNodeText( xmlRoot.firstChild );
        const aelRes = document.querySelectorAll( "div#pwdcc-result > div" );

        for(var i=0;i<aelRes.length;i++)
          if ( aelRes[i].dataset.result != strResult )
            aelRes[i].classList.remove( "peRowCtl__ctlPwdCCRes-visible" );
          else
            aelRes[i].classList.add( "peRowCtl__ctlPwdCCRes-visible" );

        strPswdPrev = strPswd;
        fPwdCCPass = "WEAK GOOD STRONG".indexOf( strResult ) != -1;
        utilVldrtCheck();
      }  // function(xmlRoot)
    );  // utilAJAX()

  } // pwdCC()

  utilInputOnChange( document.getElementById( "password" ),
    function(e) {
      const strPswd = this.value;

      if ( timeoutPwdCC != null )
        clearTimeout( timeoutPwdCC );
      if ( !strPswd )
      {
        const aelRes = document.querySelectorAll( "div#pwdcc-result > div" );
        for(var i=0;i<aelRes.length;i++)
          aelRes[i].classList.remove( "peRowCtl__ctlPwdCCRes-visible" );
        fPwdCCPass = true;
      }
      else
        timeoutPwdCC = setTimeout( pwdCC, 400, strPswd );

      comparePasswords();
    }
  );

  utilInputOnChange( document.getElementById( "password2" ), comparePasswords );

  utilVldrtSet( function() { return fPwdMatch && fPwdCCPass } );
  utilVldrtCheck();
} );
