/****************************************************************/
/*                                                              */
/*  Example of how to add an account to the FtpServer database  */
/*                                                              */
/*      Note that this is a SAMPLE script with many of the      */
/*      options hard-coded.  You will need to modify it to      */
/*                   suit your own needs.                       */
/*                                                              */
/*      Author:       Peter Moylan (peter@pmoylan.org)          */
/*      Started:      8 June 2004                               */
/*      Last revised: 17 November 2020                          */
/*                                                              */
/*  Usage:                                                      */
/*         adduser username password                            */
/*                                                              */
/*  Installation:                                               */
/*     Put this file anywhere you like, but run it from the     */
/*          directory containing FTPD.INI or FTPD.TNI           */
/*                                                              */
/*         Remark: if the PathString is really complicated,     */
/*         you might want to develop a solution that uses       */
/*         LoadPRM rather than this script.                     */
/*                                                              */
/****************************************************************/

/****************************************************************/
/*                      EXAMPLE PATHSTRING                      */
/*  You will probably have to modify this for your own needs.   */
/****************************************************************/

PathString = '"/"="C:\Download"'

/****************************************************************/

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs
CALL CheckPrerequisites SelectTNI INI_get INI_put

PARSE ARG username password
IF username = '' THEN
    DO
        SAY "Usage: adduser username password"
        EXIT 1
    END

ini = INIFileFor(username)

/* Check for duplicated username. */

IF INI_get(ini, username, 'Category') \= '' THEN
    DO
        SAY "Username "username" already exists"
        SAY "Try a different name"
        EXIT 1
    END

SAY "Updating "ini

/* Create the INI file entries for this new user. */

CALL INI_put ini, username, 'Category', '03'X
CALL INI_put ini, username, 'Notes', 'Test account'
CALL INI_put ini, username, 'Password', password
CALL INI_put ini, username, 'RealName', ''
CALL INI_put ini, username, 'LoginLimit', '00000000'X
CALL INI_put ini, username, 'SpeedLimit', 'FFFFFFFF'X
CALL INI_put ini, username, 'UserLimit', '01000000'X
CALL INI_put ini, username, 'Volume', PathString

EXIT 0

/****************************************************************/
/*  Procedure to find the INI or TNI file that contains the     */
/*  data for one user.  In many installations this will turn    */
/*  out to be FTPD.INI or FTPD.TNI, but if the option to use    */
/*  multiple INI files is activated then the file name is based */
/*  on a hash coding of the username.  The file is created if   */
/*  it doesn't already exist.                                   */
/****************************************************************/

IniFileFor:  PROCEDURE

    PARSE UPPER ARG username
    IF SelectTNI("FTPD") THEN extension = "TNI"
    ELSE extension = "INI"
    HashMax = INI_get('FTPD.'extension, '$SYS', 'HashMax')
    IF HashMax = '' THEN HashMax = 0
    ELSE HashMax = C2D(REVERSE(HashMax))
    IF HashMax = 0 THEN code = ''
    ELSE DO
        code = 0
        DO WHILE username <> ''
            ch = LEFT(username,1)
            username = RIGHT(username, LENGTH(username)-1)
            code = (16*code + C2D(ch)) // HashMax
        END
        code = TRANSLATE(FORMAT(code,4), '0', ' ')
    END
    file = 'FTPD'code'.'extension

    /* Create the file if it doesn't already exist. */

    IF STREAM(file, 'C', 'QUERY EXISTS') = '' THEN DO
        CALL STREAM file, 'C', 'OPEN WRITE'
        CALL STREAM file, 'C', 'CLOSE'
    END

    RETURN file

/****************************************************************/
/*                      CHECKING PREREQUISITES                  */
/****************************************************************/

CheckPrerequisites: PROCEDURE

    /* The argument is a space-separated list of prerequisite   */
    /* functions, for example                                   */
    /*      CALL CheckPrerequisites rxu SelectTNI INI_get       */
    /* where (at least in this version) each list item is       */
    /* either 'rxu' or a function from my TNItools package.     */
    /* If any is missing then we exit with an error message.    */

    PARSE UPPER ARG funclist
    funclist = STRIP(funclist)
    needrxu = 0
    needtools = 0
    DO WHILE funclist \= ''
        PARSE VAR funclist func funclist
        funclist = STRIP(funclist)
        IF func = 'RXU' THEN DO

            /* Initialise RXU if not already available, fail if */
            /* the RxFuncAdd operation fails.  We must          */
            /* RxFuncQuery RxuTerm because RxuTerm does not     */
            /* deregister RxuInit.  The RxFuncDrop is needed    */
            /* because RxFuncAdd seems to report failure if the */
            /* function is already registered.                  */

            IF RxFuncQuery('RxuTerm') THEN DO
                CALL RxFuncDrop('RxuInit')
                CALL RxFuncAdd 'RxuInit','RXU','RxuInit'
                IF result THEN DO
                    SAY 'Cannot load RXU'
                    needrxu = 1
                END
                ELSE CALL RxuInit
            END
        END
        ELSE DO
            func = func||'.CMD'
            IF SysSearchPath('PATH', func) = '' THEN DO
                SAY 'ERROR: 'func' must be in your PATH'
                needtools = 1
            END
        END
    END
    IF needrxu THEN SAY 'You can find RXU1a.zip at Hobbes'
    IF needtools THEN SAY 'Please install the GenINI package'
    IF needrxu | needtools THEN EXIT 1
    RETURN

/****************************************************************/

