/*----------------------------------------------------------

   Extracting IP addresses from the listing in Monitor.

           Author:       Peter Moylan (peter@pmoylan.org)
           Started:      13 September 2017
           Last revised: 16 September 2017

   Usage:
           Use DragText to drop lines from the Monitor program
	   to a folder or the desktop.  Then drag that file and
           drop it onto this script.
           A file IPAddrs.txt will be produced.

------------------------------------------------------------*/

/****************************************************************/
/*                       MAIN PROGRAM                           */
/****************************************************************/

Outfile = "IPAddrs.txt"

PARSE ARG Infile

IF LINES(Infile) = 0 THEN DO
   SAY "Operation failed.  See README_GetClientAddrs for the probable reason."
   PARSE PULL
   EXIT 1
END

DO WHILE LINES(Infile) > 0
   thisline = LINEIN(Infile)
   PARSE VAR thisline part1'('IPaddr')'part2
   CALL LINEOUT Outfile, IPaddr
END
EXIT

/****************************************************************/

