
function setVal(formEl) {
  // TODO: handle div-encapsulated inputs
  if (formEl.nodeName == 'DIV') {
    if (formEl.childNodes) {
      var i;
      for (i = 0;;i++) {
        var child = formEl.childNodes[i];
        if (!child) break;
        if (child.nodeName == "INPUT") {
          if (child.getAttribute("type") == "radio") {
            if (child.selected) {
              setValFromInput(formEl.id, child);
              return;
            }
          } else {
            setValFromInput(formEl.id, child);
            return;
          }
        } //TODO: handle selects and textareas
      }
    }
  } else if (formEl.nodeName == "INPUT") {
    setValFromInput(formEl.id, formEl);
  }
}

function setValFromInput(id, input) {
  var validationType = input.getAttribute("validationType");
  //alert(id+"= '"+input.value+"';");
  //alert("Validation type "+validationType);
  eval(id+"= '"+input.value+"';");
}

function addArrayItem(arrayEl) {
      var template;
      var maxId = -1;
      var arrayId = arrayEl.getAttribute("id");
      var i;
      for (i = 0; ; i++) {
        var node = arrayEl.childNodes[i];
        if (!node) {
          break;
        }
        if (node.nodeType == 1 && node.nodeName == 'DIV' &&
            node.getAttribute("id").substring(0, arrayId.length) == arrayId) {          
          template = node;
          maxId++;
        }
      }
      if (template) {
        var newItem = template.cloneNode(true);
        // ajust ids, clear values
        adjustIds(newItem, arrayId, maxId+1, true);
        arrayEl.appendChild(newItem);        
      }
}

function adjustIds (el, arrayId, idx, clearValues) {
  //alert(el.nodeName);
  var id = el.getAttribute("id");
  if (id && id.substring(0, arrayId.length) == arrayId &&
    id.charAt(arrayId.length) == '[') {
    var pos = id.indexOf(']', arrayId.length+1);
    var newId = arrayId+'['+idx+id.substring(pos);
    el.setAttribute("id", newId);
  }
  if (clearValues && el.nodeName == 'INPUT') {
    el.value = el.defaultValue;
  }
  if (el.childNodes) {
    var i;
    for (i = 0; ; i++) {
      var node = el.childNodes[i];
      if (!node)
        return;
      if (node.nodeType == 1)
        adjustIds(node, arrayId, idx, clearValues);
    }
  }
}

// Ensures the object has the property specified by the expression
function ensurePropertyExists(propertyExpr) {
  //alert("ensurePropertyExists called for '"+propertyExpr+"'");
}

// Ensures the form has the input that corresponds to the expression
function ensureInputExists(propertyExpr) {
  //alert("ensureInputExists called for '"+propertyExpr+"'");  
}

function setInputValue(path, value) {
    ensureInputExists(path);
    var el = document.getElementById(path);
    if (el.nodeName == 'INPUT') {
      // it's a simple input
      el.value = value;
    } else if (el.nodeName == 'DIV') {
      // it's a div-encapsulated input (probably checkbox or multiple select)
      if (el.childNodes) {
        var i;
        for (i = 0; ;i++) {
          var child = el.childNodes[i];
          if (!child) break;
          if (child.nodeName == "INPUT") {
            if (child.getAttribute("type") == "radio") {
              if (child.value = value) {
                child.checked = true;
              }
            } else {
              child.value = value;
            }
          }
            // TODO: handle selects and textareas
        }
      }
    }
}

function copyObjectToForm() {
        var s = {
            array: function (path, x) {
                var f, i, l = x.length, v;
                for (i = 0; i < l; i += 1) {
                    v = x[i];
                    f = s[typeof v];
                    if (f) {
                        v = f(path+'['+i+']', v);
                    }
                }
            },
            'boolean': function (path, x) {
                ensureInputExists(path);
                var input = document.getElementById(path);
                if (input.nodeName == 'INPUT' &&
                  input.getAttribute('type') == 'checkbox') {
                  input.checked = true;
                }
            },
            'null': function (path, x) {
                ensureInputExists(path);
                var input = document.getElementById(path);
                if (input.nodeName == 'INPUT') {
                  input.value = null;
                }                
            },
            number: function (path, x) {
              setInputValue(path, x);
            },
            object: function (path, x) {
                if (x) {
                    if (x instanceof Array) {
                        s.array(path, x);
                        return;
                    }
                    var f, i, v;
                    for (i in x) {
                        if (!x.hasOwnProperty || x.hasOwnProperty(i)) {
                            v = x[i];
                            f = s[typeof v];
                            if (f) {
                                f(path+'.'+i, v);
                            }
                        }
                    }
                }
            },
            string: function (path, x) {
              setInputValue(path, x);
            }
        };
  var f = s['object'];
  f('obj', obj);
}

function copyNodeToObject(node) {
  var id = node.getAttribute("id");
  if ((node.nodeName == 'INPUT' || node.nodeName == 'SELECT' || node.nodeName == 'DIV')
      && id && id.substring(0, 3) == 'obj') {
    ensurePropertyExists(id);
    setVal(node);    
  }
  if (node.childNodes) {
    var i;
    for (i = 0; ; i++) {
      var child = node.childNodes[i];
      if (!child)
        return;
      if (child.nodeType == 1) 
        copyNodeToObject(child);
    }  
  }
}

function copyFormToObject() {
  var formNode = document.getElementById("form");
  copyNodeToObject(formNode);  
}
