#define	INCL_BASE
#define	INCL_DOSDEVICES
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>

#pragma info(nocnd)

typedef	unsigned char	UBYTE;

#define	DEF_PORT	50000

static	opendev (UBYTE *device);
static	closedev (int fd);
static	APIRET ioctldev (int fd, ULONG cat, ULONG func,
	PVOID parbuf, ULONG parmax, ULONG *parlen, PVOID databuf,
	ULONG datamax, ULONG *datalen);

static	HMODULE hmoddev = NULLHANDLE;
static	int (*devopen) (UBYTE *, USHORT, UBYTE *) = NULL;
static	int (*devclose) (int) = NULL;
static	APIRET (*devioctl) (int, ULONG, ULONG, PVOID, ULONG, ULONG *,
	PVOID, ULONG, ULONG *) = NULL;
static	UBYTE *remotehost = NULL;
static	USHORT remoteport = DEF_PORT;


main (int argc, UBYTE **argv)
{
    int		fd;
    UBYTE	*ptr;
    USHORT	reboot = FALSE;
    ULONG	parlen, datlen;

    for (argc--, argv++; argc; argc--)
    {
	ptr = strupr(*argv++);
	if (*ptr != '/')
	{
	    printf ("Invalid command line arguments\n");
	    return(1);
	}

	for (ptr = strtok (ptr, "/"); ptr; ptr = strtok (NULL, "/"))
	    switch (*ptr)
	    {
		case 'Y':
		    reboot = TRUE;
		    break;

		case 'R':
		    remotehost = ptr + 1;
		    break;

		default:
		    printf ("\nUsage: REBOOT [/Y] [/R<host>[:<port>]]\n");
		    return(1);
	    }
    }

    if (remotehost)
    {
	remotehost = strtok (remotehost, ":");
	if (ptr = strtok (NULL, ""))
	    remoteport = atoi(ptr);
    }

    if ((fd = opendev("DOS$")) == -1)
    {
	printf ("Error opening DOS$ device\n");
	return(1);
    }

    if (reboot)
    {
	parlen = datlen = 0;
	ioctldev (fd, 0xD5, 0xAB, NULL, 0, &parlen, NULL, 0, &datlen);
    }
    else
	printf ("Use /Y switch to confirm reboot.\n");

    closedev(fd);
    return(0);
}


static	opendev (UBYTE *device)
{
    ULONG	htype, hattr;
    int		fd;

    if (remotehost)
    {
	if (DosLoadModule (NULL, 0, "DEVCLI", &hmoddev))
	    return(-1);

	if (DosQueryProcAddr (hmoddev, 0, "devopen", (PFN *) &devopen) ||
	    DosQueryProcAddr (hmoddev, 0, "devclose", (PFN *) &devclose) ||
	    DosQueryProcAddr (hmoddev, 0, "devioctl", (PFN *) &devioctl))
	{
	    DosFreeModule(hmoddev);
	    return(-1);
	}

	fd = (*devopen) (remotehost, remoteport, device);
    }
    else
	if ((fd = open (device, O_RDONLY | O_BINARY)) != -1)
	    if (DosQueryHType (fd, &htype, &hattr) != 0 || htype != 1)
	    {
		close(fd);
		fd = -1;
	    }

    return(fd);
}


static	closedev (int fd)
{
    int		rc;

    if (remotehost)
    {
	rc = (*devclose)(fd);
	DosFreeModule(hmoddev);
	return(rc);
    }

    return(close(fd));
}


static	APIRET ioctldev (int fd, ULONG cat, ULONG func,
	PVOID parbuf, ULONG parmax, ULONG *parlen, PVOID databuf,
	ULONG datamax, ULONG *datalen)
{
    if (remotehost)
	return ((*devioctl) (fd, cat, func, parbuf, parmax, parlen, databuf,
	    datamax, datalen));

    return (DosDevIOCtl (fd, cat, func, parbuf, parmax, parlen, databuf,
	datamax, datalen));
}
