void
reinit_phase2_iv(struct state *st) {
  memcpy (st->st_iv, st->st_was_new_iv, MAX_DIGEST_LEN); 
}

/* Compute Phase 2 IV.
 * Uses Phase 1 IV from st_iv; puts result in st_new_iv.
 */

void
init_phase2_iv(struct state *st, const msgid_t *msgid)
{
    const struct hash_desc *h = st->st_oakley.hasher;
    union hash_ctx ctx;

#if 0 /* TRH_XXX */
    st->st_new_iv_len = h->hash_digest_len;
#else
    st->st_new_iv_len = st->st_oakley.encrypter->blocksize;
#endif
    passert(st->st_new_iv_len <= sizeof(st->st_new_iv));

    memcpy (st->st_was_new_iv, st->st_iv, MAX_DIGEST_LEN); //here idiot
    h->hash_init(&ctx);
    DBG_cond_dump(DBG_CRYPT, "Phase 2 IV--phase 1 IV in:",
      st->st_iv, st->st_iv_len);
    h->hash_update(&ctx, st->st_iv, st->st_iv_len);
    passert(*msgid != 0);
    DBG_cond_dump(DBG_CRYPT, "Phase 2 IV--message id in:",
      (const u_char *)msgid, sizeof(*msgid));
    h->hash_update(&ctx, (const u_char *)msgid, sizeof(*msgid));
    h->hash_final(st->st_new_iv, &ctx);

    DBG_cond_dump(DBG_CRYPT, "computed Phase 2 IV:"
    , st->st_new_iv, st->st_new_iv_len);
//    memcpy (st->st_was_new_iv, st->st_new_iv, MAX_DIGEST_LEN);

}
