/* STATE_AGGR_R0: HDR, SA, KE, Ni, IDii -->
 * HDR, SA, KE, Nr, IDir, HASH_R
 */
stf_status
aggr_inI1_outR1(struct msg_digest *md)
{
    /* With Aggressive Mode, we get an ID payload in this, the first
     * message, so we can use it to index the preshared-secrets
     * when the IP address would not be meaningful (i.e. Road
     * Warrior).  So our first task is to unravel the ID payload.
     */
    struct state *st;
    struct payload_digest *const sa_pd = md->chain[ISAKMP_NEXT_SA];
    pb_stream *keyex_pbs = &md->chain[ISAKMP_NEXT_KE]->pbs;
    struct payload_digest *const id_pd = md->chain[ISAKMP_NEXT_ID];
    int peer_idtype = id_pd->payload.id.isaid_idtype;
    struct connection *c;
    pb_stream r_sa_pbs;



    md->st = st = new_state();
    /* put a very short fuse on this state object
     * in case things don't work out.
     */
/* dev@fx.dk */
//    event_schedule(EVENT_SA_EXPIRE, 0, st);

    st->st_policy |= POLICY_AGGRESSIVE;

    switch (peer_idtype)
    {
    case ID_IPV4_ADDR:
    case ID_FQDN:
    case ID_USER_FQDN:
    case ID_KEY_ID:
      if (!decode_peer_id(md, st))
        return STF_FAIL + INVALID_ID_INFORMATION;
      /* look up connection using this IP address, not
      * the one that was the source of the packet!
      */
//    c = find_fake_connection();
      c = find_host_connection(md->iface->addr, md->sin.sin_addr, &st->st_peeridentity, peer_idtype);
      if (c == NULL)
      {
#if 0 /* TRH was here */
      /* see if a wildcarded connection can be found */
        c = find_host_connection(md->iface->addr, mask0.sin_addr, &st->st_peeridentity, peer_idtype);
        if (c != NULL)
        {
          /* create a temporary connection that is a copy of this one */
          c = rw_connection(c, md->sin.sin_addr);
        }
        else
#endif /* ROAD_WARRIOR_FUDGE */
        {
          log(("initial Aggressive Mode packet claiming to be from %s"
              " but no connection has been authorized"),
          show_identity(st->st_peeridentity, st->st_peeridentity_type));
          log_event(md, NULL, PE_UNKNOWN_PHASE1_PEER, PR_UNKNOWN_CONNECTION);
          /* XXX notification is in order! */
          return STF_IGNORE;
        }
      }
      break;
    default:
      log("Unacceptable identity type (%s) in ID payload from %s"
          , enum_show(&ident_names, peer_idtype)
          , inet_ntoa(md->sin.sin_addr));
      /* XXX notification is in order! */
      return STF_IGNORE;
    }

    /* Set up state */
    cur_state = md->st; /* (caller will reset cur_state) */
    st->st_connection = c;
    st->st_klives = 1;  /* Not our job to try again from start */

    memcpy(st->st_icookie, md->hdr.isa_icookie, COOKIE_SIZE);
    get_cookie(ISAKMP_RESPONDER, st->st_rcookie, COOKIE_SIZE, md->sin.sin_addr);

    insert_state(st); /* needs cookies, connection, and msgid (0) */
    glean_myidentity(st);

    st->st_doi = ISAKMP_DOI_IPSEC;
    st->st_situation = SIT_IDENTITY_ONLY; /* We only support this */
    st->st_state = STATE_AGGR_R1;


    log("responding to Aggressive Mode, state #%lu, connection \"%s\""
        , st->st_serialno, st->st_connection->name);

    /* save initiator SA for HASH */
    clonereplacechunk(st->st_p1isa, sa_pd->pbs.start, pbs_room(&sa_pd->pbs),
                      "sa in aggr_inI1_outR1()");

    /* parse_isakmp_sa also spits out a winning SA into our reply,
     * so we have to build our md->reply and emit HDR before calling it.
     */

    /* HDR out */
    {
      struct isakmp_hdr r_hdr = md->hdr;

      memcpy(r_hdr.isa_rcookie, st->st_rcookie, COOKIE_SIZE);
      r_hdr.isa_np = ISAKMP_NEXT_SA;
      if (!out_struct(&r_hdr, &isakmp_hdr_desc, &md->reply, &md->rbody))
        return STF_INTERNAL_ERROR;
    }

    {
      struct isakmp_sa r_sa;
      notification_t r;

      /* start of SA out */
      r_sa = sa_pd->payload.sa;
      r_sa.isasa_np = ISAKMP_NEXT_KE;
      if (!out_struct(&r_sa, &isakmp_sa_desc, &md->rbody, &r_sa_pbs))
        return STF_INTERNAL_ERROR;

      /* SA body in and out */
      r = parse_isakmp_sa_body(&sa_pd->pbs, &sa_pd->payload.sa, &r_sa_pbs, FALSE, st);
      if (r != NOTHING_WRONG)
        return STF_FAIL + r;
    }

    st->st_oakley.group = lookup_group(OAKLEY_GROUP_MODP768);

    /* KE in */
    ACCEPT_KE(st->st_gi, "Gi", st->st_oakley.group, *keyex_pbs);

    /* Ni in */
    ACCEPT_NONCE(st->st_ni, "Ni");

    /************** build rest of output: KE, Nr, IDir, HASH_R **************/

    /* KE */
    if (!build_and_ship_KE(st, &st->st_gr, st->st_oakley.group,
         &md->rbody, ISAKMP_NEXT_NONCE))
      return STF_INTERNAL_ERROR;

    /* Nr */
    if (!build_and_ship_nonce(&st->st_nr, &md->rbody, ISAKMP_NEXT_ID, "Nr"))
      return STF_INTERNAL_ERROR;

    /* IDir out */
    {
      struct isakmp_ipsec_id r_id;
      pb_stream r_id_pbs;

      r_id.isaiid_np = ISAKMP_NEXT_HASH;
      r_id.isaiid_idtype = st->st_myidentity_type;
      r_id.isaiid_protoid = 0;  /* ??? is this right? */
      r_id.isaiid_port = 0; /* ??? is this right? */
      if (!out_struct(&r_id, &isakmp_ipsec_identification_desc, &md->rbody, &r_id_pbs)
          || !out_chunk(st->st_myidentity, &r_id_pbs, "my identity"))
      {
        return STF_INTERNAL_ERROR;
      }
      close_output_pbs(&r_id_pbs);
    }

#if 1 /* TRH_XXX */
    compute_dh_shared(st, st->st_gi, st->st_oakley.group);
    if (!generate_skeyids_iv(st))
      return STF_FAIL + AUTHENTICATION_FAILED;
    update_iv(st);
#endif

    /* HASH_R out */
    {
      u_char hash_val[MAX_DIGEST_LEN];
      int hash_len;

      main_mode_hash(st, hash_val, &hash_len, FALSE, TRUE);
      DBG_cond_dump(DBG_CRYPT, "HASH_R sent:", hash_val, hash_len);

      if (!out_generic_raw(ISAKMP_NEXT_NONE, &isakmp_hash_desc, &md->rbody, hash_val, hash_len, "HASH_R"))
        return STF_INTERNAL_ERROR;
    }

    /* finish message */
    close_message(&md->rbody);

    /* Advance state */
    st->st_state = STATE_AGGR_R1;

    return STF_REPLY;
}

/* STATE_AGGR_I1: HDR, SA, KE, Nr, IDir, HASH_R -->
 * HDR, HASH_I
 */
stf_status
aggr_inR1_outI2(struct msg_digest *md)
{
    /* With Aggressive Mode, we get an ID payload in this, the first
     * message, so we can use it to index the preshared-secrets
     * when the IP address would not be meaningful (i.e. Road
     * Warrior).  So our first task is to unravel the ID payload.
     */
    struct state *st = md->st;
    pb_stream *keyex_pbs = &md->chain[ISAKMP_NEXT_KE]->pbs;
    struct payload_digest *const id_pd = md->chain[ISAKMP_NEXT_ID];
    int peer_idtype = id_pd->payload.id.isaid_idtype;
    struct connection *c = st->st_connection;

    /* Reinsert the state, using the responder cookie we just received */
    unhash_state(st);
    memcpy(st->st_rcookie, md->hdr.isa_rcookie, COOKIE_SIZE);
    insert_state(st); /* needs cookies, connection, and msgid (0) */

    switch (peer_idtype)
    {
      case ID_IPV4_ADDR:
      case ID_FQDN:
      case ID_USER_FQDN:
      case ID_KEY_ID:
        if (!decode_peer_id(md, st))
          return STF_FAIL + INVALID_ID_INFORMATION;
        /* Check that the id received from our peer matches what's in our
         connection description.  */
        if (c->that.id_type > 0
            && (c->that.id_type != st->st_peeridentity_type
            || !chunksequal(c->that.id, st->st_peeridentity)))
        {
          log(("Responders Aggressive Mode packet claiming to be from %s,"
               " but that doesn't match our connection description"),
          show_identity(st->st_peeridentity,
          st->st_peeridentity_type));
          log_event(md, st, PE_UNKNOWN_PHASE1_PEER, PR_UNKNOWN_CONNECTION);
          /* XXX notification is in order! */
         return STF_IGNORE;
        }
        break;
      default:
        log("Unacceptable identity type (%s) in ID payload from %s"
            , enum_show(&ident_names, id_pd->payload.ipsec_id.isaiid_idtype)
            , inet_ntoa(md->sin.sin_addr));
        /* XXX notification is in order! */
        return STF_IGNORE;
    }

    /* verify echoed SA */
    {
      struct payload_digest *const sapd = md->chain[ISAKMP_NEXT_SA];
      notification_t r =   parse_isakmp_sa_body(&sapd->pbs, &sapd->payload.sa, NULL, TRUE, st);

      if (r != NOTHING_WRONG)
        return STF_FAIL + r;
    }

    st->st_oakley.group = lookup_group(OAKLEY_GROUP_MODP768);

    /* KE in */
    ACCEPT_KE(st->st_gr, "Gr", st->st_oakley.group, *keyex_pbs);

    /* Nr in */
    ACCEPT_NONCE(st->st_nr, "Nr");

#if 1 /* TRH_XXX */
    /* Generate SKEYID, SKEYID_A, SKEYID_D, SKEYID_E */
    compute_dh_shared(st, st->st_gr, st->st_oakley.group);
    if (!generate_skeyids_iv(st))
      return STF_FAIL + AUTHENTICATION_FAILED;
# if 1
    update_iv(st);
# endif
#endif

    /* HASH_R in */
    CHECK_HASH(main_mode_hash(st, hash_val, &hash_len, FALSE, FALSE),
               "HASH_R", "Aggr R1");

#if 0 /* TRH_XXX */
    /* Generate SKEYID, SKEYID_A, SKEYID_D, SKEYID_E */
    compute_dh_shared(st, st->st_gr, st->st_oakley.group);
    if (!generate_skeyids_iv(st))
      return STF_FAIL + AUTHENTICATION_FAILED;
    update_iv(st);
#endif

    /**************** build output packet: HDR, HASH_I ****************/

    /* HDR* */
#if 0
    {
      struct isakmp_hdr r_hdr = md->hdr;  /* mostly same as incoming header */

      r_hdr.isa_np = ISAKMP_NEXT_HASH;
      if (!out_struct(&r_hdr, &isakmp_hdr_desc, &md->reply, &md->rbody))
        return STF_INTERNAL_ERROR;
    }
#endif

    /* HASH_I out */
    {
      u_char hash_val[MAX_DIGEST_LEN];
      int hash_len;

      main_mode_hash(st, hash_val, &hash_len, TRUE, TRUE);
      DBG_cond_dump(DBG_CRYPT, "HASH_I sent:", hash_val, hash_len);

#ifdef TOKENCARD /* dev@fx.dk support for tokencard */
      if (!out_generic_raw(ISAKMP_NEXT_NONCE, &isakmp_hash_desc, &md->rbody,
#else
  if (!out_generic_raw(ISAKMP_NEXT_NONE, &isakmp_hash_desc, &md->rbody,
#endif
      hash_val, hash_len, "HASH_I"))
      return STF_INTERNAL_ERROR;
    }

/* dev@fx.dk support for tokencard */

// we need to place Np, a Nonce payload containing additional token card specific
// data which is required to complete the authentication process.

  if (st->st_peeridentity_type == ID_KEY_ID) {
    char np_value[256];
    int np_len;

    FILE *fp;
    char buffer[1024];
    char *p;
    char token_card_user_ID[256];
    char time_variant_password[256];


    log ("TOKEN CARD\n");
    fp = fopen ("itoken.cfg", "r");
    if (fp == NULL) {
      printf ("error!\n");
      return STF_INTERNAL_ERROR;
    }
    if (fgets(buffer, sizeof(buffer)-1, fp) == (char *) NULL) {
      log ("error!\n");
      return STF_INTERNAL_ERROR;
    }
    for (p = buffer+strlen(buffer); p>buffer && isspace(p[-1]); p--)
      ;
    *p = '\0';
    strcpy (token_card_user_ID, buffer);

    if (fgets(buffer, sizeof(buffer)-1, fp) == (char *) NULL) {
      log ("error!\n");
      return STF_INTERNAL_ERROR;
    }
    fclose (fp);	
    for (p = buffer+strlen(buffer); p>buffer && isspace(p[-1]); p--)
      ;
    *p = '\0';
    strcpy (time_variant_password, buffer);

    strcpy (np_value, token_card_user_ID);
    strcpy (np_value+strlen (token_card_user_ID)+1, time_variant_password);
    np_len = strlen (token_card_user_ID) + strlen (time_variant_password) + 1;
    if (!out_generic_raw(ISAKMP_NEXT_NONE, &isakmp_nonce_desc, &md->rbody,
      np_value, np_len, "Np"))
      return STF_INTERNAL_ERROR;


    if (!encrypt_message(&md->rbody, st))
      return STF_INTERNAL_ERROR;      /* ??? we may be partly committed */

  } else
     close_message(&md->rbody);


  st->st_state = STATE_AGGR_I2;
  c->newest_isakmp_sa = st->st_serialno;

  return STF_REPLY_AND_UNPEND_QUICK;
}

/* STATE_AGGR_R1: HDR, HASH_I --> done
 */
stf_status
aggr_inI2(struct msg_digest *md)
{
    struct state *const st = md->st;
    struct connection *c = st->st_connection;

#if 0 /* TRH_XXX */
    compute_dh_shared(st, st->st_gi, st->st_oakley.group);
    if (!generate_skeyids_iv(st))
  return STF_FAIL + AUTHENTICATION_FAILED;
#endif

    /* HASH_I */
    CHECK_HASH(main_mode_hash(st, hash_val, &hash_len, TRUE, FALSE),
         "HASH_I", "Aggr I2");


    /**************** done input ****************/

    /* Advance state */
    st->st_state = STATE_AGGR_R2;
    c->newest_isakmp_sa = st->st_serialno;

#if 1 /* TRH_XXX */
    update_iv(st);  /* Finalize our Phase 1 IV */
#endif

    return STF_NO_REPLY;
}

