/*
 * Oops uses signed operations and checks on time_t :-(
 * Watcom declares time_t as unsigned type.
 * Instead of fixing lot of bad code in Oops, we just redefine time_t as signed
 */

#define _TIME_T_DEFINED
#define _TIME_T_DEFINED_
typedef signed long time_t; /* time value */

/*
 * This entry required for rwlock.c to compile
 */

#define _REENTRANT

typedef unsigned short u_short;
typedef unsigned char  u_char;

typedef int            ssize_t;

typedef	unsigned long  sigset_t;

extern	int	sigaddset(sigset_t *, int);
extern	int	sigemptyset(sigset_t *);

extern char *os2_oops_libdir(void);

extern char *strtok_r( char *__s1, const char *__s2, char **__ptr );

/* time.h */
#ifndef _TIMESPEC_DEFINED
#define _TIMESPEC_DEFINED       1
struct timespec {
    int tv_sec;
    int tv_nsec;
};
#endif

/* fcntl.h */
#define	F_GETFL		4
#define	F_SETFL		5

int fcntl(int socket, int action, ...);

/* glob.h */
typedef struct {
        int gl_pathc;           /* Count of total paths so far.			*/
        char **gl_pathv;        /* List of paths matching pattern.		*/
	struct glob_list *entries;
} glob_t;

extern	int	glob(const char *, int, int (*)(const char *, int), glob_t *);
extern	void	globfree(glob_t *);

/* dlfcn.h */
#define	RTLD_NOW	2

extern	void	*dlopen(const char *, int);
extern	void	*dlsym(void *, const char *);
extern	int	dlclose(void *);
extern	char	*dlerror(void);

/* crypt.h */
extern	char	*crypt(const char *__key, const char *__salt);


/* Socket errno hacks */

#define accept		os2_accept
#define bind		os2_bind
#define bsdselect	os2_bsdselect
#define connect		os2_connect
#define getsockname	os2_getsockname
#define ioctl		os2_ioctl
#define listen		os2_listen
#define recv		os2_recv
#define recvfrom	os2_recvfrom
#define send		os2_send
#define sendto		os2_sendto
#define setsockopt	os2_setsockopt
#define socket		os2_socket
#define soclose		os2_soclose

/* 
 * Important! Must replace gettimeofday() [included, by default, from TCP/IP].
 * Otherwise will have funny results with timezones/summer time and seconds
 * rounding up.
 */

#define gettimeofday	os2_gettimeofday

/*
 * Also, we must override struct timeval because Ooops uses signed ariphmetic :-(
 * Creating fake sys/time.h from TCP/IP includes...
 */

#define _TIMEVAL

struct timeval {
        long  tv_sec;
        long  tv_usec;
};

struct timezone {
  unsigned short tmz;
};

struct itimerval {
        struct timeval it_interval;
        struct timeval it_value;
};

int _System gettimeofday(struct timeval *, struct timezone *);
int _System settimeofday(struct timeval *, struct timezone *);

/*
 * We must override time() function because "global_sec_timer" updated
 * irregularly (with 1 sec. pauses). We always ending up in situation
 * when time(NULL) is "123" but "global_sec_timer" is still "122".
 *
 * This will not fix situation completely (possible race condition in update
 * of "global_sec_timer" variable) but will help a lot.
 */

#define time 		os2_incremental_time

/*
 * Replace strerror to support socket errors
 */

#define strerror	os2_strerror

/* foo */

#define chown(a, b, c)

#define rand_r(foo)  rand()   /* It really what we wanted? */

/* Not defined in TCP/IP headers? */

#define INET_ADDRSTRLEN  16
