/*
      rp_AddUserQuiet - adds new user records if not exist, or replace
 previous saved (without any responce).
      Request looks like "USERNAME=username itself,group1...,groupN,ip address
 Group name differs from ip address because, group name begins with an alpha, 
 but ip address begins with a digit.
*/
#include "rproxy.h"


void rp_AddUserQuiet ( unsigned char *handle, CommandMessage *M,
                   unsigned char Value[], long *rcode )
{
        uIP *uip;
        register unsigned char *p, *pname;
        unsigned long ip;
        register int  i, n;
        unsigned char *pgroups [_MAX_GROUPS];

*rcode = HTTP_OK;
n = 0;
for ( p = Value; *p &&  *p != ','; p++ );
if ( *p )
    {
    pname = Value;
    *p = (unsigned char)'\0';
    for ( n = 0, ++p; !isdigit(*p) && *p && n < _MAX_GROUPS; )
        {
        for ( pgroups [n++] = p; *p && *p != ','; p++ );        
        *p = (unsigned char)'\0';
        ++p;
        }
    if ( *p )
        ip = inet_addr(p);
    if ( (uip=bsearch(pname,userList,userListSize,sizeof(uIP),(VoidStub)strcmp)) != NULL )
        {                       // if we find user, replace his ip address.
        DosEnterCritSec();      // userList is common array, because we have to
        uip->ip = ip;           // lock it updating
        for ( i = 0; i < n; i++ )
            {
            strncpy ( uip->groups [i], pgroups [i], _MAX_GROUPNAME_LENGTH-1 );
            uip->groups [i] [_MAX_GROUPNAME_LENGTH-1] = (unsigned char)'\0';
            }
        uip->totalgroups = n;
        time ( &uip->timestamp );
        DosExitCritSec();       // may be not beautiful, but relyable.
        }
    else
        {
        if ( (userListSize+1) < maxUserListSize )
            {
            DosEnterCritSec();  // userList is common array, because we have to
            strncpy ( userList [userListSize].name, pname, _MAX_USERNAME_LENGTH-1 );
            userList [userListSize].name [_MAX_USERNAME_LENGTH-1] = (unsigned char)'\0';
            userList [userListSize].ip = ip;
            uip = &userList [userListSize];
            for ( i = 0; i < n; i++ )
                {
                strncpy ( uip->groups [i], pgroups [i], _MAX_GROUPNAME_LENGTH-1 );
                uip->groups [i] [_MAX_GROUPNAME_LENGTH-1] = (unsigned char)'\0';
                }
            uip->totalgroups = n;
            time ( &uip->timestamp );
            ++userListSize;
            qsort ( userList, userListSize, sizeof(uIP), (VoidStub)strcmp );
            DosExitCritSec();   // may be not beautiful, but relyable.
{
unsigned char buf [80];
sprintf ( buf, "User %s succesfully added.", pname );
rp_TraceLog ( handle, buf );
}
            }
        else
            {
            rp_SayError ( handle, Errs [0] );
//            *rcode = HTTP_SERVER_ERROR;
            }
        }
    }
}