/*
    rp_Authorization - performs step "Authorization" of the proxy server.
*/
#include "rproxy.h"




void HTTPD_LINKAGE rp_Authorization ( unsigned char *handle, long *rcode )
{
        unsigned char *remoteADDR;
        unsigned char *pathTRANSLATED;
        register unsigned char *p;
        short control;

*rcode = HTTP_NOACTION;
if ( (remoteADDR=rp_GetCGIvar(handle,CGI_RemoteAddr)) != NULL )
    {
    if ( (pathTRANSLATED=rp_GetCGIvar(handle,CGI_PathTranslated)) != NULL )
        {
        control = 0;            // didn't meet control entry yet
        if ( (p=strchr(pathTRANSLATED,'?')) != NULL )
            {                   // the sign of the control entry
            for ( ; p != pathTRANSLATED && *p != '/'; p-- );
            if ( *p == '/' )
                {               // extract the name
                ++p;            // check it
                if ( !rp_strncmp(p,RPROXY_Control_Entry,20) )
                    {           // if this is control entry - authorize it
                    HTTPD_authenticate ( handle, rcode );
                    if ( *rcode == HTTPD_SUCCESS )
                        rp_AddTrustedHost ( handle, NULL, remoteADDR, rcode );
                    else
                        {
                        rp_DeleteTrustedHost ( handle, NULL, remoteADDR, rcode );
                        *rcode = HTTP_UNAUTHORIZED;
                        }      // we met the control entry
                    control = 1;
                    }
                }
            }
        if ( !control )        // we didn't meet control entry
            {                  // make authorization for all other hosts
            if ( rp_CheckURL(handle,remoteADDR,pathTRANSLATED) == _ACL_RULE_DENY )
                *rcode = HTTP_FORBIDDEN;
            }
        free ( pathTRANSLATED );
        }
    else
        {
        rp_SayError ( handle, Errs [1] );
        }
    free ( remoteADDR );
    }
else
    {
    rp_SayError ( handle, Errs [2] );
    }
#ifdef DEBUG
if ( *rcode == HTTP_NOACTION )
    rp_TraceLog ( handle, "Permited" );
else
    rp_TraceLog ( handle, "Denied" );
#endif
}
