/*
      rp_Init - initialise all data.
*/
#include "rproxy.h"


#define serverADDR Buf

static void rp_BuildSourceList ( void );
static long rp_GetTables ( unsigned char *handle, unsigned char RootPath[] );
static short rp_LoadTable ( unsigned char TableName[], unsigned char Table[] );


void HTTPD_LINKAGE rp_Init (unsigned char *handle,
    unsigned long *major_version,
    unsigned long *minor_version,
    long *rcode )
{
        register unsigned char *p;
        unsigned char *serverROOT;
        FILE *Fp;
        unsigned char Buf [_MAX_PATH];
        unsigned long length;
        register unsigned char *SourceCODEPAGE;
        register short i;
        static char PathFormat [] = "%s/%s";
        struct hostent *hostProxy;

userListSize = 0;
ACListSize = 0;
qsort ( CommandsDictionary, CdictSize, sizeof(CommandMessage), (VoidStub)strcmp );
qsort ( UsersDictionary, UdictSize, sizeof(CommandMessage), (VoidStub)strcmp );
if ( (userList=malloc(sizeof(uIP)*maxUserListSize)) == NULL )
    {                           // allocate buffer for user's entries
    rp_SayError ( handle, Errs [3] );
    }
if ( (ACList=malloc(sizeof(ACL)*maxACLListSize)) == NULL )
    {                           // acclocate buffer for ACL
    rp_SayError ( handle, Errs [3] );
    }
if ( tidThread == 0 )          // start garbage collection thread
    {
    DosCreateThread(&tidThread,rp_GarbageCollection,garbageCollectionTimeout,0,4096);
    DosSetPriority(PRTYS_THREAD,PRTYC_IDLETIME,-31,tidThread);
    }
/*
    㥬 ⠡ ⨯ ⥪⮢ ꥪ⮢  ⠡
  ꥪ⮢
*/
qsort ( ListTextTypes,TotalTextTypes,sizeof(ListTextTypes[0]),(VoidStub)rp_strcmp);

/*
     室 । ⠫,   饭 ணࠬ
*/
if ( (serverROOT=rp_GetCGIvar(handle,CGI_ServerRoot)) != NULL )
    {
    strcpy ( Buf, serverROOT );
    for ( p = strchr(Buf,'\0'); p > Buf; p-- )
        {
        if ( *p == '/' || *p == '\\' )
            break;
        }
    *p = '\0';
    free ( serverROOT );
    serverROOT = Buf;
    strcat ( serverROOT, "/RHTTP" );
    *rcode = rp_GetTables ( handle, serverROOT );
/*
*/
    strcpy ( forbiddenFilename, serverROOT );
    for ( p = strchr(forbiddenFilename,'\0'); p > forbiddenFilename; p-- )
        {
        if ( *p == '/' || *p == '\\' )
            break;
        }
    *p = '\0';
    free ( serverROOT );
    strcat ( forbiddenFilename, "/RHTTP/forbidden.html" );
    rp_LoadForbidden ( forbiddenFilename );
    }                           // 㧨 ⠡ ४஢
if ( (SourceCODEPAGE=getenv(ENV_SourceCodepage)) != NULL )
    {                           //  ENV 稬 ஢ ᠩ 
    SourceCodepage = rp_GetCodepage(SourceCODEPAGE);// 㬮砭
    }
else                            // ᫨   ,  ।
    {                           // -㬮砭
    SourceCodepage = _SOURCE_CODEPAGE;
    }
sprintf(Buf,"Rproxy. Source codepage - %s\n", CodepageTable[SourceCodepage]);
length = strlen(Buf);           // 뢥  log-  室
rp_TraceLog ( handle, Buf );
                                //  ࠭
if ( (p=getenv(ENV_SourceURL)) != NULL )
    {                           // 稬  ᠩ,  
    strncpy ( SourceURL, p, sizeof(SourceURL)-1 );
                                // ४஢
    SourceURL [sizeof(SourceURL)-1] = '\0';
    }
else
    SourceURL [0] = '\0';

sprintf(Buf,"Rproxy. URL list to translate - %s\n", SourceURL );
length = strlen(Buf);           //  뢥  log-
rp_TraceLog ( handle, Buf );
rp_BuildSourceList();

for ( i = 0; i < TotalSources; i++ )
    {
    length = strlen(SourceTable[i]);
    rp_TraceLog ( handle, SourceTable[i] );
    }

if ( (p=getenv(ENV_DisableMeta)) != NULL )
    DisableMeta = 1;
else
    DisableMeta = 0;

TotalUsers = 0l;                // 㫨 ⠡ 짮⥫
if ( UserTable != NULL )
    {
    free ( (void *)UserTable );
    UserTable = NULL;
    }

gethostname ( serverADDR, sizeof(serverADDR)-1 );
hostProxy = gethostbyname(serverADDR);
rp_TraceLog ( handle, serverADDR );
sprintf ( serverADDR, "%d.%d.%d.%d", hostProxy->h_addr[0],
               hostProxy->h_addr[1], hostProxy->h_addr[2], 
               hostProxy->h_addr[3] );
rp_TraceLog ( handle, serverADDR );
rp_AddTrustedHost ( handle, NULL, serverADDR, rcode );

rp_TraceLog ( handle, "Rproxy translation and authorization module started." );
*rcode = HTTP_OK;
}


static void rp_BuildSourceList ( void )
{
   register unsigned char *s;
   FILE  *Fp;
   char Buf [sizeof(SourceTable[0])];

TotalSources = 0;
if ( (Fp=fopen(SourceURL,"r")) != NULL )
    {
    while ( fgets(Buf,sizeof(Buf)-2,Fp) )
        {
        if ( (s=strchr(Buf,'\n')) != NULL )
            *s = '\0';
        strupr ( Buf );
        if ( TotalSources < _MAX_ENABLED_STABLE && Buf[0] )
            {
            Buf [_MAX_PATH-1] = '\0';
            strcpy ( SourceTable [TotalSources++], Buf );
            }
        }
    fclose ( Fp );
    }
}

static long rp_GetTables ( unsigned char *handle, unsigned char RootPath[] )
{
   unsigned char TableFile [_MAX_PATH+_MAX_FNAME+_MAX_EXT];
   register short i;
   unsigned long length;
   long rcode;

if ( RootPath == NULL )
   return ( HTTPD_PARAMETER_ERROR );

for ( i = 0; i < TotalCodepages; i++ )
   {
   sprintf ( TableFile, "%s/%s.cdp", RootPath, CodepageTable [i] );
   if ( rp_LoadTable(TableFile,To866_Codepages [i]) )
       sprintf(TableFile,"Error loading codepage %s\n", CodepageTable [i]);
   rp_InvertTable ( To866_Codepages [i], From866_Codepages [i] );
   length = strlen(TableFile);
   rp_TraceLog ( handle, TableFile );
   }
return ( errno ? HTTPD_PARAMETER_ERROR : HTTPD_SUCCESS );
}


#include <io.h>

static short rp_LoadTable ( unsigned char TableName[], unsigned char Table[] )
{
    FILE    *Fp;
    register int size;

for ( size = 0; size < _TABLE_SIZE; size++ )
   Table [size] = (unsigned char)size;

errno = 0;
if ( (Fp=fopen(TableName,"rb")) != NULL )
    {
    size = (int)filelength(fileno(Fp));
    if ( size < 0 || size > _TABLE_SIZE )
        size = _TABLE_SIZE;
    fread ( &Table[_TABLE_SIZE-size], sizeof(unsigned char), size, Fp );
    fclose ( Fp );
    }
return ( errno );
}
