#define BSD_SELECT
#define VERSION_STRING  "V1.0 beta"

#define TCPV40HDRS
#define INCL_DOSPROCESS
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <netdb.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <sys/select.h>


#define printSockError(s)      fprintf(stderr,"Sock error %d : %s\n",sock_errno(),s)

unsigned short  serverPort;
unsigned long   serverIPaddress;
unsigned char   *serverAddress;
unsigned char   RPROXY_Control_Entry [] = "rproxy_control_entry";
int             mainSocket;
struct sockaddr_in serverSocket;


void   main ( int argc, char *argv[] )
{
        struct hostent *host;
        int             res;
        int             on = 1;
        FILE            *fp;
        char            buf [8192]; 
        char            str [1024];
        int             size;

if ( argc < 4 )
    {
    printf ( "RpControl version %s. Rproxy control utility,\n", VERSION_STRING );
    printf ( "Copyright (C) 2000 Andy A. Porro <porro@cbs-edu.chel.su>\n\n" );
    printf ( "Usage : RpControl rproxy_server_address remote_port filename\n" );
    exit ( 0 );
    }
serverAddress = argv[1];          // remote server address
serverPort = (unsigned short)atoi(argv[2]);// remote server port number

sock_init();                    // init sockets

if ( !strcmpi(serverAddress, "localhost") )
    serverIPaddress = (1 * 256 * 256 * 256) + 127;
else
    {
    if ( (serverAddress[0] >= '0') && (serverAddress[0] <= '9') )
        serverIPaddress = inet_addr(serverAddress);
    else
        {
        host = gethostbyname(serverAddress);
        if ( host == NULL )
            {
            fprintf(stderr, "Rproxy address %s is unknown\n", serverAddress);
            exit ( -1 );
            }
        else
            serverIPaddress = *((ULONG *)host->h_addr);
        }
    }

if ( (fp=fopen(argv[3],"r")) != NULL )
    {
    while ( fgets(str,sizeof(str)-2,fp) )
        {
            register char *p;

        if ( (p=strchr(str,'\n')) != NULL )
            *p = '\0';
        if ( !str[0] )
            continue;

        if ( (mainSocket=socket(AF_INET,SOCK_STREAM,0)) < 0 )
            {
            printSockError ( "Socket()" );
            break;
            }
        memset ( (void *)&serverSocket, 0, sizeof(serverSocket) );
        serverSocket.sin_family = AF_INET;
        serverSocket.sin_port = htons(serverPort);
        serverSocket.sin_addr.s_addr = serverIPaddress;

        if ( connect (mainSocket,(struct sockaddr *)&serverSocket,sizeof(serverSocket)) < 0 )
            {
            printSockError ( "Connect()" );
            break;
            }

        sprintf ( buf, "GET /%s?%s\r\nAuthorization: Basic cG9ycm86Y25maHNxZ2Zoamtt\r\n\r\n", RPROXY_Control_Entry, str );
        size = strlen(buf);
        res = send ( mainSocket, buf, size, 0 );
        if ( res < 0 )
            {
            if ( sock_errno() != SOCEINTR ) // or even error
                {
                printSockError ( "send()" );
                break;
                }
            }
        size = sizeof(buf);
        while ( (res=recv(mainSocket,buf,size,0)) != 0 )
            {
            if ( sock_errno() )
                {
                printSockError ( "recv()" );
                break;
                }
            buf [res] = '\0';
            printf ( "%s", buf );
            fflush ( stdout );
            }
        printf ( "\n" );
        DosSleep ( 500 );
        soclose ( mainSocket );
        DosSleep ( 250 );
        }
    fclose ( fp );
    }
exit ( 0 );
}

