/*
*/
#include "..\Traffic\traffic.h"
#include "rproxy.h"
#include <ctype.h>

#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>

static char _etc [] = "ETC";


static char *_getFileName ( time_t t, unsigned char _fileName[] )
{
       struct tm *cm;
       register char *path;
       register char *fname = NULL;
       unsigned char *_etcPath;

if ( (_etcPath=malloc(_MAX_PATH+1)) != NULL )
    {
    if ( t != 0l && (path=getenv(_etc)) != NULL )
        {
        strcpy ( _etcPath, path );
        cm = localtime(&t);
        sprintf ( _fileName, "%s\\LOG\\%c%04d%02d%02d.log", path, _KEY_LETTER,
                  cm->tm_year+1900, cm->tm_mon+1, cm->tm_mday );
        fname = _fileName;
        }
    free ( _etcPath );
    }
return ( fname );
}


static int getDayTraffic ( DayTraffic *pdt )
{
       char *fname;
       FILE *fp;
       register int found = 0;
       unsigned char iname [sizeof(pdt->iname)];
       unsigned char *_fileName;

if ( (_fileName=malloc(_MAX_PATH+1)) != NULL )
    {
    if ( (fname=_getFileName(pdt->t,_fileName)) != NULL )
        {
        if ( (fp=fopen(fname,"rb")) != NULL )
            {
            strcpy ( iname, pdt->iname );
            while ( fread (pdt,1,sizeof(DayTraffic),fp) )
                {
                if ( !strcmp(iname,pdt->iname) )
                    {
                    found = 1;
                    break;
                    }
                }
            fclose ( fp );
            }
        }
    free ( _fileName );
    }
if ( !found )
    {
    pdt->out = pdt->inp = pdt->last_inp = pdt->last_out = 0l;
    pdt->t = 0l;
    }
return ( found );
}


static int  getLastDayTraffic ( DayTraffic *pdt )
{
        register int  found = 0;
        HDIR          findHandle = HDIR_CREATE;
        FILEFINDBUF3  findBuffer;
        ULONG         findCount = 1;
        register APIRET rc;
        unsigned char *maxFileName;
        struct tm ct;
        unsigned char buf [8];
        time_t        t;
        unsigned char *_fileName;
        register char *path;
        unsigned char *_etcPath;

if ( (maxFileName=malloc(_MAX_FNAME+_MAX_EXT+1)) != NULL )
    {
    if ( (_fileName=malloc(_MAX_PATH+1)) != NULL )
        {
        if ( (_etcPath=malloc(_MAX_PATH+1)) != NULL )
            {  
            t = pdt->t;         // save date
            if ( t != 0l && (path=getenv(_etc)) != NULL )
                strcpy ( _etcPath, path );
            else
                strcpy ( _etcPath, "C:\\MPTN\\ETC" );
                                // try to get for current day
            if ( !(found=getDayTraffic(pdt)) ) 
                {               // if not, find more files     
                sprintf ( _fileName, "%s\\LOG\\*.log", _etcPath );
                rc = DosFindFirst(_fileName,
                                  &findHandle,
                                  (ULONG)0,
                                  &findBuffer,
                                  (ULONG)sizeof(findBuffer),
                                  (PULONG)&findCount,
                                  (ULONG)0x0001);
                maxFileName [0] = '\0';
                while (!rc)
                    {
                    strlwr ( findBuffer.achName );
                    if ( findBuffer.achName[0] == _KEY_LETTER && 
                                isdigit(findBuffer.achName[1]) )
                        {
                        if ( strcmp(findBuffer.achName,maxFileName) > 0 )
                            strcpy ( maxFileName, findBuffer.achName );
                        }
                    rc = DosFindNext(findHandle,
                                     &findBuffer,
                                     sizeof(findBuffer),
                                     (PULONG)&findCount);
                    }
                DosFindClose(findHandle);
                if ( maxFileName [0] )
                    {     
                    strncpy ( buf, &maxFileName[1], 4 ); buf [4] = '\0';
                    ct.tm_year = atoi(buf)-1900;
                    strncpy ( buf, &maxFileName[1+4], 2 ); buf [2] = '\0';
                    ct.tm_mon = atoi(buf)-1;
                    strncpy ( buf, &maxFileName[1+4+2], 2 ); buf [2] = '\0';
                    ct.tm_mday = atoi(buf);
                    ct.tm_hour = ct.tm_min = ct.tm_sec = 0;
                    pdt->t = mktime(&ct); 
                    found = getDayTraffic(pdt);
                    ct = *localtime(&t);
                    }
                }
            free ( _etcPath );
            }
        free ( _fileName );
        }
    free ( maxFileName );
    }
return ( found );
}


#define _WORK_BUF_SIZE  2048

void rp_getAndViewTraffic ( unsigned char *handle, CommandMessage *M,
                  unsigned char Value[], long *rcode )
{
       struct tm *pt;
       DayTraffic TrafFromFile;
       unsigned char *buf;

if ( Value[0] == '\0' )
    strcpy ( TrafFromFile.iname, "sl0" );
else
    {
    strncpy ( TrafFromFile.iname, Value, sizeof(TrafFromFile.iname)-1 );
    TrafFromFile.iname [sizeof(TrafFromFile.iname)-1] = '\0';
    strlwr ( TrafFromFile.iname );
    }
time ( &TrafFromFile.t );          // get current date/time
if ( !getLastDayTraffic(&TrafFromFile) )
    {                              // get last traffic from file
    TrafFromFile.last_inp = TrafFromFile.last_out = 
    TrafFromFile.inp = TrafFromFile.out = 0l;
    strcpy ( TrafFromFile.iname, "No one" );
    }                     
if ( (buf=malloc(_WORK_BUF_SIZE)) != NULL )
    {
    sprintf ( buf, 
                 "Traffic controller IBM ICS-plugin 1.0\n"
                 "Copyright (C) 2000 Andy A. Porro <porro@cbs-edu.chel.su>\n"
                 "Algorithm by Alexandr V. Shukovilov <blithe@cbs-edu.chel.su>\n"
                 "--------------------------------------------------------------\n"
                 " Date %s\n"
                 " Interface %s\n"
                 " Input  traffic : %9lu bytes, %9lu kb, %9lu mb\n"
                 " Output traffic : %9lu bytes, %9lu kb, %9lu mb\n"
                 "--------------------------------------------------------------\n",
                 TrafFromFile.t != 0l ? ctime(&TrafFromFile.t) : "(unknown)", 
                 TrafFromFile.iname, 
                 TrafFromFile.inp, TrafFromFile.inp/1000l, TrafFromFile.inp/1000000l,
                 TrafFromFile.out, TrafFromFile.out/1000l, TrafFromFile.out/1000000l );
    rp_PutHeader ( handle, rcode, _MIME_TEXT );
    rp_write ( handle, buf, rcode );
    free ( buf );
    }
*rcode = HTTP_OK;
}
