/*
      rp_ViewACL - sends current ACL.

 previous saved.
*/
#include "rproxy.h"

static unsigned char title1 [] = 
    "------------------------- Rproxy. Current ACL ------------------------\n";
static unsigned char title2 [] = 
    "---------------------- Rproxy. Current public ACL --------------------\n";


static void rp_ViewACLrules ( unsigned char *handle, long *rcode,
                              unsigned char title[], ACL *List, int Lsize );


void rp_ViewACL ( unsigned char *handle, CommandMessage *M,
                   unsigned char Value[], long *rcode )
{
rp_ViewACLrules ( handle, rcode, title1, ACList, ACListSize );
}

void rp_ViewPublicACL ( unsigned char *handle, CommandMessage *M,
                        unsigned char Value[], long *rcode )
{
rp_ViewACLrules ( handle, rcode, title2, publicACList, publicACListSize );
}



static void rp_ViewACLrules ( unsigned char *handle, long *rcode,
                              unsigned char title[], ACL *List, int Lsize )
{
        register int i;
        unsigned char *buf;

rp_PutHeader ( handle, rcode, _MIME_TEXT );
rp_write ( handle, title, rcode );
if ( (buf=malloc(256)) != NULL )
    {
    for ( i = 0; i < Lsize; i++ )
        {
        sprintf ( buf, "%-4d  %-32s  %-60s %s\n", 
                       i+1,  List [i].name, List [i].url, 
                       List [i].state ? "permit" : "deny" );
        rp_write ( handle, buf, rcode );
        }
    free ( buf );
    }
else
    {
    rp_write ( handle, Errs [3], rcode );
    }
*rcode = HTTP_OK;
}
