/*
      rp_ViewTrustedHosts - sends current trusted hosts table.

 previous saved.
*/
#include "rproxy.h"

static unsigned char title [] = 
    "-------- Rproxy. Current trusted hosts table -------\n";
static unsigned char *states [3] = {
    "_ACL_RULE_DENY",
    "_ACL_RULE_PERMIT",
    "_ACL_RULE_ADMIN"
    };


void rp_ViewTrustedHosts ( unsigned char *handle, CommandMessage *M,
                   unsigned char Value[], long *rcode )
{
        register int i;
        unsigned char *buf;

rp_PutHeader ( handle, rcode, _MIME_TEXT );
rp_write ( handle, title, rcode );

if ( (buf=malloc(256)) != NULL )
    {
    for ( i = 0; i < totalTrustedHosts; i++ )
        {
        sprintf ( buf, "%-4d  %-32s %s\n", i+1, 
                       TrustedHosts [i].hostmask, 
                       states[TrustedHosts [i].state] );
        rp_write ( handle, buf, rcode );
        }
    free ( buf );
    }
else
    {
    rp_write ( handle, Errs [3], rcode );
    }
*rcode = HTTP_OK;
}
