/*
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <time.h>
#include <ctype.h>
#include <htapi.h>

#define TCPV40HDRS
#define INCL_DOSPROCESS
#include <os2.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <netdb.h>

#define VoidStub int(* _Optlink)(const void*,const void*)

#define _DEFAULT_CODEPAGE 2              /* 짮⥫᪠ ⠡ 
                                            㬮砭                  */
#define	_CP_KOI8    (0)                  // "koi8"
#define	_CP_866     (1)                  // "cp866"
#define _CP_WIN1251 (2)                  // "win1251"
#define _CP_UNIX    (3)                  // "iso-8859-5"
#define _CP_MACOS   (4)                  // "mac-os"
#define _CP_USASCII (5)                  // "us-ascii"

#define _SOURCE_CODEPAGE  1              /* 室  ⠡ 
                                            㬮砭                  */

#define _MAX_USERNAME_LENGTH    28
#define _MAX_GROUPNAME_LENGTH   16
#define _MAX_GROUPS             16
#define _MAX_URL_LENGTH         256
#define _MAX_COMMAND_LENGTH     32
#define _MAX_COMMAND_ARGUMENT   256
#define _MAX_IP_IN_STRING       16
#define _MAX_TRUSTED_HOSTS      64
#define _MAX_PUBLIC_ACL         64
#define _DEF_MAX_USERS          256
#define _DEF_MAX_ACL_RULES      512
#define _ACL_RULE_DENY          (0)
#define _ACL_RULE_PERMIT        (1)
#define _ACL_RULE_ADMIN         (2)
#define _DEF_GARBAGECOLLECTION_TIMEOUT  (10L*60L*1000L)
#define _MIME_TEXT              (0)
#define _MIME_HTML              (1)

#define _MAX_FILE_EXT     15
#define _MAX_ADDRESS      4
#define _MAX_BROWSER      64
#define _MAX_STRING       128
#define _MAX_BUF          2
#define _MAX_CPAGENAME    16
#define _MAX_CODEPAGES    6
#define _TABLE_SIZE       256
#define _TOTAL_TEXT_TYPES 28
#define _TOTAL_BIN_TYPES  16
#define	_HEADER_SIZE	  256
#define	_MAX_ENABLED_ATABLE 128
#define	_MAX_ENABLED_STABLE 256
#define	_MAX_FTP_PREFIX   4          // FTP://

#define	_CONTENT_TEXT	0x01
#define	_CONTENT_BINARY 0x02

#define TranslateChar(Ti,To,c)  (To[Ti[c]])
#define VoidStub int(* _Optlink)(const void*,const void*)

#define rp_write(h,m,r)    { unsigned long $s;\
        $s = strlen(m);\
        HTTPD_write(h,m,&$s,r);}

/*
 *      饭   । ਭ   ॣ
 */
#define IsLower(c)      ((c)<0177?islower(c):(char)(((c)>=''&&(c)<='')||\
			((c)>=''&&(c)<='')?1:0))
#define IsUpper(c)      ((c)<0177?isupper(c):(char)((c)>=''&&(c)<=''?1:0))

/*
 *      饭   ॢ   ॣ  㣮.
 */
#define ToLower(c)      ((c)<0177?tolower(c):(char)(!IsUpper(c)?(c):\
			(c)<=''?((c)+''-''):((c)+''-'')))
#define ToUpper(c)      ((c)<0177?toupper(c):(char)(!IsLower(c)?(c):\
			(c)<=''?((c)-''+''):((c)-''+'')))


/*
    Define a record of table for ip and corresponding user name
*/
typedef struct uIP {
    unsigned char name [_MAX_USERNAME_LENGTH];// user name certainly
    unsigned char groups [_MAX_GROUPS] [_MAX_GROUPNAME_LENGTH];// user's groups
    short         totalgroups;
    unsigned long ip;                         // ip address
    time_t   timestamp;         // name timestamp (age)
    } uIP;

/*
    Define a record of table for user name and corresponding accessed URL
*/
typedef struct ACL {
    unsigned char name [_MAX_USERNAME_LENGTH];
    unsigned char url  [_MAX_URL_LENGTH];
    short    state;             // permit or deny (1 or 0)
    } ACL;

typedef struct CommandMessage {
        unsigned char Keyword [_MAX_COMMAND_LENGTH];
        void (*Handler)( unsigned char *handle,
                         struct CommandMessage *M,
                         unsigned char Value[],
                         long *rcode );
        }     CommandMessage;

typedef struct trustedHost {
        unsigned char hostmask [_MAX_IP_IN_STRING];
        short state;
        }   trustedHost;

typedef struct RHTTP_User {
       unsigned long volatile remoteADDR;
       unsigned long volatile userAGENT;
       short volatile Codepage;
       short volatile SourceCP;
       }  RHTTP_User;

extern uIP *userList;         // user table
extern int userListSize;      // user table size
extern int maxUserListSize;   // max size of the user's table
extern ACL *ACList;           // access control list
extern int ACListSize;        // access control list size
extern int maxACLListSize;    // max size of the ACL
extern unsigned char *ForbiddenHTML;// access forbidden message text
extern unsigned char forbiddenFilename [_MAX_PATH];

void HTTPD_LINKAGE rp_Init (unsigned char *handle, unsigned long *major_version, unsigned long *minor_version, long *rcode );
void HTTPD_LINKAGE rp_PreExit ( unsigned char *handle, long *rcode );
void HTTPD_LINKAGE rp_Authorization ( unsigned char *handle, long *rcode );
void HTTPD_LINKAGE rp_Stop ( unsigned char *handle, long *rcode );
void HTTPD_LINKAGE rp_Open ( unsigned char *handle, long *rcode );
void HTTPD_LINKAGE rp_Close ( unsigned char *handle, long *rcode );
void HTTPD_LINKAGE rp_Write ( unsigned char *handle, unsigned char *data, unsigned long *datalength, long *rcode );

int rp_atox ( unsigned char *v, int maxlen );
int rp_strncmp ( unsigned char F[], unsigned char S[], int N );
int rp_strcmp ( char F[], char S[] );
unsigned char *rp_strnstr ( unsigned char F[], unsigned char S[], int N );
unsigned char *rp_strstr ( char F[], char S[] );

unsigned char *rp_GetCGIvar ( unsigned char *handle, unsigned char *name );
void rp_SayError ( unsigned char *handle, unsigned char *name );
void rp_PutHeader ( unsigned char *handle, long *rcode, short type );
int  rp_Match ( unsigned char inputLine[], unsigned char searchPattern[] );
int  rp_CheckURL ( unsigned char *handle, unsigned char uip[], unsigned char url[] );
void _System rp_GarbageCollection ( ULONG ul );
void rp_TraceLog ( unsigned char *handle, unsigned char *text );
void rp_ProcessRequest ( unsigned char *handle, CommandMessage Dictionary[], 
                         int dictSize, unsigned char Request[], long *rcode );
void rp_LoadForbidden ( unsigned char Path[] );
void rp_NormaliseUserAgent ( unsigned char buf[] );
RHTTP_User volatile *rp_FindRHTTPUser ( unsigned char Adr[], unsigned char Agent[] );
RHTTP_User volatile *rp_AddRHTTPUser ( unsigned char Adr[], unsigned char Agent[] );
short rp_GetCodepage ( unsigned char CODEPAGE[] );
short rp_GetDataType ( unsigned char pathTRANSLATED[] );
short rp_CheckSite ( unsigned char pathTRANSLATED[] );
short rp_IsHeader ( unsigned char *data, unsigned long length );
void  rp_RewriteHeader ( unsigned char *handle, unsigned char *data, unsigned long length );
short rp_ChangeCharset ( unsigned char *handle, unsigned char Buf[], unsigned long *Length, RHTTP_User volatile *Uptr, long *rcode );
void  rp_Translate ( unsigned char data [], unsigned long length, unsigned char It[], unsigned char Ot[] );
int   rp_LastSpace ( unsigned char buf[] );
unsigned long rp_StringID ( unsigned char *S );
short rp_GetDefaultCodepage ( char *Browser );
void  rp_GetFileExt ( unsigned char *pathTRANSLATED, unsigned char Type[], unsigned long typeSize );
unsigned char *rp_InvertTable ( unsigned char SrcTable[], unsigned char DstTable[] );

void rp_AddUserQuiet ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ViewUsers ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_Version ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_DeleteUser ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_AddUser ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_AddTrustedHost ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_AddACLrule ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ClearACL ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ClearTrustedHosts ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ViewACL ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ViewTrustedHosts ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_DeleteTrustedHost ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_getAndViewTraffic ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ViewYourIP ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ChangeCodepage ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ViewPublicACL ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_AddPublicACLrule ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ClearPublicACL ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ViewPublicACL ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );


extern CommandMessage CommandsDictionary [];
extern int CdictSize;
extern CommandMessage UsersDictionary [];
extern int UdictSize;
extern unsigned char RPROXY_Control_Entry [];
extern unsigned char RPROXY_User_Entry [];
extern unsigned char ENV_SourceCodepage [];
extern unsigned char ENV_SourceURL [];
extern unsigned char ENV_DisableMeta [];
extern unsigned char CGI_PathTranslated [];
extern unsigned char CGI_RemoteAddr [];
extern unsigned char CGI_QueryString [];
extern unsigned char CGI_ServerRoot [];
extern unsigned char CGI_UserAgent [];
extern unsigned char CGI_DocumentURL [];
extern unsigned char CGI_ServerAddr [];
extern trustedHost TrustedHosts [_MAX_TRUSTED_HOSTS];
extern int      totalTrustedHosts;
extern TID      tidThread;
extern long     garbageCollectionTimeout;

extern unsigned char *Msgs [];
extern unsigned char *Errs [];
                                // default access control list
extern ACL   publicACList [_MAX_PUBLIC_ACL];
extern int   publicACListSize;

extern short SourceCodepage;    // default codepage for documents on server
extern unsigned char To866_Codepages [_MAX_CODEPAGES] [_TABLE_SIZE];
extern unsigned char From866_Codepages [_MAX_CODEPAGES] [_TABLE_SIZE];
extern RHTTP_User volatile *UserTable;
extern unsigned long volatile TotalUsers;
extern short DisableMeta;
extern unsigned char *Charsets [_MAX_CODEPAGES];
extern unsigned char SourceTable [_MAX_ENABLED_STABLE] [_MAX_PATH];
extern int  TotalSources;
extern unsigned char CodepageTable [_MAX_CODEPAGES] [_MAX_CPAGENAME];
extern short TotalCodepages;
extern unsigned char ListTextTypes [_TOTAL_TEXT_TYPES] [6];
extern int  TotalTextTypes;
extern unsigned char SourceURL [_MAX_PATH];
extern unsigned long AddrTable [_MAX_ENABLED_ATABLE];
extern int  TotalAddresses;
