/*
*/
#include "rproxy.h"

uIP  *userList;         // user table
int  userListSize;      // current size of the user's table
int  maxUserListSize = _DEF_MAX_USERS;  // max size of the user's table
ACL  *ACList;           // access control list
int  ACListSize;        // access control list size
int  maxACLListSize = _DEF_MAX_ACL_RULES;
unsigned char *ForbiddenHTML;// access forbidden message text
unsigned char forbiddenFilename [_MAX_PATH];
short SourceCodepage = _SOURCE_CODEPAGE;
unsigned char To866_Codepages [_MAX_CODEPAGES] [_TABLE_SIZE];
unsigned char From866_Codepages [_MAX_CODEPAGES] [_TABLE_SIZE];
RHTTP_User volatile *UserTable = NULL;
unsigned long volatile TotalUsers = 0l;
short DisableMeta = 0;
unsigned char SourceURL [_MAX_PATH];

unsigned char *Charsets [_MAX_CODEPAGES] = {
   "KOI8-R",
   "CP-866",
   "WINDOWS-1251",
   "ISO-8859-5",
   "MAC-OS",
   "US-ASCII",
   };
unsigned char SourceTable [_MAX_ENABLED_STABLE] [_MAX_PATH];
int  TotalSources;

unsigned char CodepageTable [_MAX_CODEPAGES] [_MAX_CPAGENAME] = {
        "koi8",                /* 0 */
        "cp866",               /* 1 */
        "win1251",             /* 2 */
        "iso-8859-5",          /* 3 */
        "mac-os",              /* 4 */
        "win1251",             /* 2 */
        };
short TotalCodepages = _MAX_CODEPAGES;

unsigned char ListTextTypes [_TOTAL_TEXT_TYPES] [6] = {
             "HTM",
             "HTML",
             "HTMLS",
             "SHTML",
             "C",
             "H",
             "CC",
             "HH",
             "JAVA",
             "M",
             "F90",
             "TXT",
             "RTX",
             "TSV",
             "ETX",
             "CXX",
             "FOR",
             "MAR",
             "LOG",
             "COM",
             "SDML",
             "LIST",
             "LST",
             "DEF",
             "CNF",
             "CONF",
             "NSF",
             "NTF",
             };

int TotalTextTypes = _TOTAL_TEXT_TYPES;
                                // default access control list
ACL  publicACList [_MAX_PUBLIC_ACL] = {
    "*", "http://www.cbs-edu.chel.su*",            _ACL_RULE_PERMIT,
    "*", "http://aurora.cbs-edu.chel.su*",         _ACL_RULE_PERMIT,
    "*", "http://NotesServerCBS.cbs-edu.chel.su*", _ACL_RULE_PERMIT,
    "*", "http://www.cbr.ru*",                     _ACL_RULE_PERMIT,
    "*", "http://www.sla.urc.ac.ru*",              _ACL_RULE_PERMIT,
    };
int   publicACListSize = 5;

unsigned char RPROXY_Control_Entry [] = "RPROXY_CONTROL_ENTRY";
unsigned char RPROXY_User_Entry []    = "RPROXY_USER_ENTRY";
unsigned char ENV_SourceCodepage []   = "RPROXY_SOURCE_CODEPAGE";
unsigned char ENV_SourceURL []        = "RPROXY_SOURCE_URL";
unsigned char ENV_DisableMeta []      = "RPROXY_DISABLE_META";
unsigned char CGI_PathTranslated []   = "URL";
unsigned char CGI_RemoteAddr []       = "REMOTE_ADDR";
unsigned char CGI_ServerRoot []       = "SERVER_ROOT";
unsigned char CGI_QueryString []      = "QUERY_STRING";
unsigned char CGI_UserAgent []        = "HTTP_USER_AGENT";
unsigned char CGI_DocumentURL []      = "REFERER_URL";
unsigned char CGI_ServerAddr []       = "SERVER_ADDR";

trustedHost TrustedHosts [_MAX_TRUSTED_HOSTS] = {
    "192.168.1.*", _ACL_RULE_PERMIT,
    "192.168.3.*", _ACL_RULE_PERMIT,
    };
int      totalTrustedHosts = 2;

TID      tidThread = 0;
#ifndef DEBUG
long     garbageCollectionTimeout = _DEF_GARBAGECOLLECTION_TIMEOUT;
#else
long     garbageCollectionTimeout = 1000L*30L;
#endif

CommandMessage CommandsDictionary [] = {
    "ADDUSER",           rp_AddUser,
    "ADDUSERQUIET",      rp_AddUserQuiet,
    "DELETEUSER",        rp_DeleteUser,
    "VIEWUSERS",         rp_ViewUsers,
    "DELETETRUSTEDHOST", rp_DeleteTrustedHost,
    "VIEWTRUSTEDHOSTS",  rp_ViewTrustedHosts,
    "VIEWACL",           rp_ViewACL,
    "VIEWPUBLICACL",     rp_ViewPublicACL,
    "ADDTRUSTEDHOST",    rp_AddTrustedHost,
    "VERSION",           rp_Version,
    "ADDACLRULE",        rp_AddACLrule,
    "ADDPUBLICACLRULE",  rp_AddPublicACLrule,
    "CLEARACL",          rp_ClearACL,
    "CLEARPUBLICACL",    rp_ClearPublicACL,
    "CLEARTRUSTEDHOSTS", rp_ClearTrustedHosts,
    "CHANGECODEPAGE",    rp_ChangeCodepage,
    "VIEWMYIP",          rp_ViewYourIP,
    "SHOWTRAFFIC",       rp_getAndViewTraffic,
    };
int CdictSize = 18;

CommandMessage UsersDictionary [] = {
    "ADDUSERQUIET",      rp_AddUserQuiet,
    "SHOWTRAFFIC",       rp_getAndViewTraffic,
    "VIEWMYIP",          rp_ViewYourIP,
    "VERSION",           rp_Version,
    "CHANGECODEPAGE",    rp_ChangeCodepage,
    };
int UdictSize = 5;


unsigned char *Msgs [] = {
    "ACL rule succesfully added.\n",
    "ACL overflow.\n",
    "Trusted host succesfully added.\n",
    "Too many trusted hosts, table overflow.\n",
    "User succesfully added.\n",
    "Unable to add user to list.\n",
    "ACL table succesfully cleared.\n",
    "Trusted host table succesfully cleared.\n",
    "User succesfully deleted.\n",
    "Unable to find user in list.\n",
    "Rproxy version 0.1",
    "Trusted host succesfully deleted.\n",
    "Trusted host not found.\n",
    };

unsigned char *Errs [] = {
    "Too many users. Increase the size of the user's table.",
    "Can't find user request",
    "Can't find user address",
    "Unable to allocate enough memory",
    };

