/*
    rp_Authorization - preforms step "Authorization" of the proxy server.
*/
#include "rproxy.h"


static int rp_strncmp ( unsigned char F[], unsigned char S[], int N )
{
	register int f, s;

for ( f = s = 0; F [f] && S [s] && s < N; f++, s++ )
    {
    if ( toupper(F[f]) != toupper(S[s]) )
       return ( (int)(F[f]-S[s]) );
    }
return ( f == s && s == N ? 0 : (int)(F[f]-S[s]) );
}



void HTTPD_LINKAGE rp_Authorization ( unsigned char *handle, long *rcode )
{
        unsigned char *remoteADDR;
        unsigned char *pathTRANSLATED;
        register unsigned char *p;

*rcode = HTTP_NOACTION;
if ( (remoteADDR=rp_GetCGIvar(handle,CGI_RemoreAddr)) != NULL )
    {
    if ( (pathTRANSLATED=rp_GetCGIvar(handle,CGI_PathTranslated)) != NULL )
        {
        if ( (p=strrchr(pathTRANSLATED,'/')) != NULL && !*(p+1) )
            *p = (unsigned char)'\0';
        if ( rp_strncmp(pathTRANSLATED+1,RPROXY_Control_Entry,20) )
            {                   // make authorization for all hosts exept
                                // Rproxy control entry
            if ( rp_CheckURL(handle,remoteADDR,pathTRANSLATED) == _ACL_RULE_DENY )
                *rcode = HTTP_FORBIDDEN;
            }
        else
            {
	    HTTPD_authenticate ( handle, rcode );
            if ( *rcode == HTTPD_SUCCESS )
                {
                rp_AddTrustedHost ( handle, NULL, remoteADDR, rcode );
                }
            else
                {
                *rcode = HTTP_UNAUTHORIZED;
                }
            }
        free ( pathTRANSLATED );
        }
    else
        {
        rp_SayError ( handle, Errs [1] );
        }
    free ( remoteADDR );
    }
else
    {
    rp_SayError ( handle, Errs [2] );
    }
#ifdef DEBUG
if ( *rcode == HTTP_NOACTION )
    rp_TraceLog ( handle, "Permited" );
else
    rp_TraceLog ( handle, "Denied" );
#endif
}
