/*
    rp_CheckURL - checks client requested URL through ACL. 
 Input - user's host ip address and requested URL. 
 In the output 1 - permit, 0 - deny. 
*/
#include "rproxy.h"


static uIP *rp_FindUserRecord ( unsigned char uip[], uIP *buf )
{
        register int i;
        unsigned long ip;

ip = inet_addr(uip);
for ( i = 0; i < userListSize; i++ )
    {
    if ( userList [i].ip == ip )
        {                       // make it more safe for multithreads
        *buf = userList [i];
        return ( buf );   
        }
    }
return ( NULL );
}



int  rp_CheckURL ( unsigned char *handle, unsigned char uip[], unsigned char url[] )
{
        register int i, j;
        uIP      user, *puser;

/*
    First of all, check user's ip address through the trusted table.
*/
for ( i = 0; i < totalTrustedHosts; i++ )
    {
    if ( rp_Match(uip,TrustedHosts[i]) )
        return ( _ACL_RULE_PERMIT );
    }
/*
    Then, if not found, find user's record in the users table.
*/
if ( (puser=rp_FindUserRecord(uip,&user)) == NULL )
     return ( _ACL_RULE_DENY );// if user not found in the table
                               // disable access for him
/*
    Then, walk through ACL table
*/
for ( i = 0; i < ACListSize; i++ )
    {                           // if ACL match to requested url,
    if ( rp_Match(url,ACList[i].url) )
        {                       // check the name, if name matchs too
        if ( !strcmp(user.name,ACList[i].name) )
            return ( ACList [i].state );// return ACL rule
        for ( j = 0; j < user.totalgroups; j++ )
            {                   // if name didn't match, searching the groups list
            if ( !strcmp(user.groups[j],ACList[i].name) )
                return ( ACList [i].state );
            }
        }
    }
return ( _ACL_RULE_DENY );
}
