/*
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <time.h>
#include <ctype.h>
#include <htapi.h>

#define TCPV40HDRS
#define INCL_DOSPROCESS
#include <os2.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <netdb.h>

#define VoidStub int(* _Optlink)(const void*,const void*)

#define _MAX_USERNAME_LENGTH    28
#define _MAX_GROUPNAME_LENGTH   16
#define _MAX_GROUPS             16
#define _MAX_URL_LENGTH         256
#define _MAX_COMMAND_LENGTH     32
#define _MAX_COMMAND_ARGUMENT   256
#define _MAX_IP_IN_STRING       16
#define _MAX_TRUSTED_HOSTS      32
#define _DEF_MAX_USERS          256
#define _DEF_MAX_ACL_RULES      512
#define _ACL_RULE_PERMIT        (1)
#define _ACL_RULE_DENY          (0)
#define _DEF_GARBAGECOLLECTION_TIMEOUT  (10L*60L*1000L)

#define rp_write(h,m,r)    { unsigned long $s;\
        $s = strlen(m);\
        HTTPD_write(h,m,&$s,r);}



/*
    Define a record of table for ip and corresponding user name
*/
typedef struct uIP {
    unsigned char name [_MAX_USERNAME_LENGTH];// user name certainly
    unsigned char groups [_MAX_GROUPS] [_MAX_GROUPNAME_LENGTH];// user's groups
    short         totalgroups;
    unsigned long ip;                         // ip address
    time_t   timestamp;         // name timestamp (age)
    } uIP;

/*
    Define a record of table for user name and corresponding accessed URL
*/
typedef struct ACL {
    unsigned char name [_MAX_USERNAME_LENGTH];
    unsigned char url  [_MAX_URL_LENGTH];
    short    state;             // permit or deny (1 or 0)
    } ACL;

typedef struct CommandMessage {
        unsigned char Keyword [_MAX_COMMAND_LENGTH];
        void (*Handler)( unsigned char *handle,
                         struct CommandMessage *M,
                         unsigned char Value[],
                         long *rcode );
        }     CommandMessage;

extern uIP *userList;         // user table
extern int userListSize;      // user table size
extern int maxUserListSize;   // max size of the user's table
extern ACL *ACList;           // access control list
extern int ACListSize;        // access control list size
extern int maxACLListSize;    // max size of the ACL

void HTTPD_LINKAGE rp_Init (unsigned char *handle, unsigned long *major_version, unsigned long *minor_version, long *rcode );
void HTTPD_LINKAGE rp_PreExit ( unsigned char *handle, long *rcode );
void HTTPD_LINKAGE rp_Stop ( unsigned char *handle, long *rcode );

int rp_atox ( unsigned char *v, int maxlen );
unsigned char *rp_GetCGIvar ( unsigned char *handle, unsigned char *name );
void rp_SayError ( unsigned char *handle, unsigned char *name );
void rp_PutHeader ( unsigned char *handle, long *rcode );
int  rp_Match ( unsigned char inputLine[], unsigned char searchPattern[] );
int  rp_CheckURL ( unsigned char *handle, unsigned char uip[], unsigned char url[] );
void _System rp_GarbageCollection ( ULONG ul );
void rp_TraceLog ( unsigned char *handle, unsigned char *text );
void rp_ProcessRequest ( unsigned char *handle, CommandMessage Dictionary[], 
                         int dictSize, unsigned char Request[], long *rcode );

void rp_AddUserQuiet ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ViewUsers ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_Version ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_DeleteUser ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_AddUser ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_AddTrustedHost ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_AddACLrule ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ClearACL ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ClearTrustedHosts ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ViewACL ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_ViewTrustedHosts ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );
void rp_DeleteTrustedHost ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode );


extern CommandMessage CommandsDictionary [];
extern int CdictSize;
extern CommandMessage UsersDictionary [];
extern int UdictSize;
extern unsigned char RPROXY_Control_Entry [];
extern unsigned char RPROXY_User_Entry [];
extern unsigned char CGI_PathTranslated [];
extern unsigned char CGI_RemoreAddr [];
extern unsigned char CGI_QueryString [];
extern unsigned char TrustedHosts [_MAX_TRUSTED_HOSTS] [_MAX_IP_IN_STRING];
extern int      totalTrustedHosts;
extern TID      tidThread;
extern long     garbageCollectionTimeout;

extern unsigned char *Msgs [];
extern unsigned char *Errs [];
