{ ==========================================================================
                             U  U N   N III TTTTT
                             U  U NN  N  I    T
                             U  U N N N  I    T
                             U  U N  NN  I    T
                              UU  N   N III   T
  __________________________________________________________________________
  UNIT ipsHookInterface

  COPYRIGHT ________________________________________________________________
  All code contained within this file is the exclusive property of the
  author Terje Flaarnning. It may not be copied, changed or used without
  written permission.

  Information about contacting the owner/author may be found at ...

    http://www.flaaronning.net/

  DESCRIPTION ______________________________________________________________
  This unit defines standard type and function definitions used by the IPS
  plug-in interface.

  TO-DO LIST _______________________________________________________________

  HISTORY __________________________________________________________________
  2001.04.01 - Initial history entry.
  2002.01.15 - Added new formatting template.
  2002.04.02 - Corrent minor typing mistakes, unknown from when.
             - Renamed from ipsPluginType to ipsHookInterface.
             - Added more information about the usage.
  2002.04.03 - Rewritten to use name Hook instead of Plugin and cleaned up
               a bit.
  2002.04.04 - Changed Get/SetValue constants values.
  2003.10.07 - Added constants for Log callback aCode field as this is now
               implemented into IPS.
  2003.11.02 - Incremented version to $00000001, changed name of
               ipsCHookVersion to ipsCHookVersionID and changed ipsTHookInfo
               2nd and 3rd fields name and/or content.
  __________________________________________________________________________ }
unit ipsHookInterface;
{ ==========================================================================
  DESCRIPTION ______________________________________________________________
  The current code sets the default calling conventions used by IPS on the
  OS/2 or Windows platform. This only affects order of arguments on stack
  and who should clean up.

  * OS/2 uses "cdecl" where parameters are pushed "last to first" and the
    caller are responsible for cleaning up.

  * Windows uses "stdcall" where parameters are pushed "last to first" and
    the called routine are responsible for cleanin up.

  A lot of development documentation also mixes in linking conventions into
  the calling convention definition, this is in my eyes incorrect but widely
  "standardized" :(

  That said, IPS first attempts to import hook methods by their clean method
  name, if that fails it will attempt the style "_<method>@<stackbytes>" as
  well.
  __________________________________________________________________________ }
{$IFDEF OS2}
  {$Cdecl+}
{$ELSE OS2}
  {$StdCall+}
{$ENDIF OS2}

{ ==========================================================================
  DESCRIPTION ______________________________________________________________
  Automatically includes a VirtualPascal unit which redefines normal integer
  types to be 32-bit.

  The following basic types are used for hooks ...
    Integer        signed 32-bit integer
    LongBool       32-bit boolean (True/False)
    PChar          pointer to 0-terminated string
    Pointer        normal pointer
  __________________________________________________________________________ }
{$Use32+}

{ ==========================================================================
               III N   N TTTTT EEEE RRR  FFFFF  AA   CC  EEEEE
                I  NN  N   T   E    R  R F     A  A C  C E
                I  N N N   T   EEE  RRR  FFF   AAAA C    EEE
                I  N  NN   T   E    R  R F     A  A C  C E
               III N   N   T   EEEE R  R F     A  A  CC  EEEEE
  __________________________________________________________________________
  HISTORY __________________________________________________________________
  2002.01.15 - Initial history entry
  __________________________________________________________________________ }
interface

{ ==========================================================================
  DESCRIPTION ______________________________________________________________
  __________________________________________________________________________ }
const
  ipsCHookVersionID        = $00000001;

{ ==========================================================================
  DESCRIPTION ______________________________________________________________
  Type declarations for the list of callback method addresses available to
  the plug-in.
  __________________________________________________________________________ }
type
  ipsPHookProc             = ^ipsTHookProc;
  ipsTHookProc             = packed record
    GetValue:                Pointer;                      //  1- 4 Address of callback function to get server values
    SetValue:                Pointer;                      //  5- 8 Address of callback function to set server values
    Send:                    Pointer;                      //  9-12 Address of callback function to send data to the client
    Recv:                    Pointer;                      // 13-16 Address of callback function to recv data from the client
    Log:                     Pointer;                      // 17-20 Address of callback function to write to the log file
  end; // ipsTHookProc

{ ==========================================================================
  DESCRIPTION ______________________________________________________________
  Type declarations for data passed directly to the plug-in routine.
  __________________________________________________________________________ }
type
  ipsPHookData             = ^ipsTHookData;
  ipsTHookData             = packed record
    Arguments:               PChar;                        //  1- 4 Address of 0-terminated textural string arguments
    Result:                  PChar;                        //  5- 8 Address of 0-terminated textural string result
  end; // ipsTHookData

{ ==========================================================================
  DESCRIPTION ______________________________________________________________
  Type declarations for the standard record passed as the only argument to
  most plug-in routines. A Pointer to this record is passed.
  __________________________________________________________________________ }
type
  ipsPHookInfo             = ^ipsTHookInfo;
  ipsTHookInfo             = packed record
    Version:                 PChar;                        //  1- 4 ipsCProductVersion, full version string of running IPS
    VersionID:               Integer;                      //  5- 8 ipsCVersionID, version ID of running IPS
    HookVersionID:           Integer;                      //  9-12 ipsCHookVersion, version ID of plug-in interface
    Session:                 Integer;                      // 13-16 Handle of current session which is to be used for callbacks
    Proc:                    ipsPHookProc;                 // 17-20 Pointer to ipsTHookProc record
    Data:                    ipsPHookData;                 // 21-24 Pointer to ipsTHookData record
  end; // ipsTHookInfo

{ ==========================================================================
  DESCRIPTION ______________________________________________________________
  __________________________________________________________________________ }
const
  // Constants for aType in Get- or SetValue callbacks
  ivtResultValue           = $00000000;                    // Used to set a simple Result value, no Ident required
  ivtVariableValue         = $00000001;                    // Any internal variable, note that most are read only
  ivtConfigValue           = $00000002;                    // Not implemented
  ivtResourceValue         = $00000003;                    // Not implemented

  // Constants for aCode in Log callback
  ilcDefault               = $f0000000;                    // Log to default log for the current session (Requires an active session)
  ilcSystemLog             = $f1000000;                    // Log to main log file (Also works from ipsInitialize and ipsFinalize without a session)
  ilcSystemConsole         = $f2000000;                    // Log to system console (Also works from ipsInitialize and ipsFinalize without a session)
  ilcSystemLogConsole      = ilcSystemLog                  // Log to main log file and system console (Also works from ipsInitialize and ipsFinalize without a session)
                             or ilcSystemConsole;

{ ==========================================================================
  DESCRIPTION ______________________________________________________________
  Type declarations for the available callback methods provided by IPS.
  This is methods your plug-in routine may use during execution to interface
  with the IPS server. All callback methods share a common first argument
  which is the same HookInfo pointer passed to your hook routine.

  The available callback methods include ...
  __________________________________________________________________________
  GetValue                   Query various IPS data values
  - aHookInfo                (Pointer to standard HookInfo structure)
  - aType                    Type of value requested (see constants above)
  - aIdent                   Value identification (or name)
  - aValue                   Pointer to a preallocated buffer for the value
  - aSize                    Size (in Bytes) of the Value buffer
  __________________________________________________________________________
  SetValue                   Set/modify user defined IPS data values
  - aHookInfo                (Pointer to standard HookInfo structure)
  - aType                    Type of value requested (see constants above)
  - aIdent                   Value identification (or name)
  - aValue                   Pointer to a 0-terminated textural string value
  __________________________________________________________________________
  Send                       Send a buffer of data to the client
  - aHookInfo                (Pointer to standard HookInfo structure)
  - aData                    Pointer to a buffer containing data to send
  - aSize                    Size of data contained in the Data buffer to
                             send
  __________________________________________________________________________
  Recv                       (Not implemented)
  __________________________________________________________________________
  Log                        Write data to the IPS log service
  - aHookInfo                (Pointer to standard HookInfo structure)
  - aCode                    Code of log message sent (see constants above)
  - aLevel                   Level of log message sent Used by LogLevel to
                             allow filtering of log entries
  - aData                    0-terminated textural string data
  __________________________________________________________________________ }
type
  ipsFGetValue             = function (aHookInfo: ipsPHookInfo; aType: Integer; aIdent, aValue: PChar; aSize: Integer): LongBool;
  ipsFSetValue             = function (aHookInfo: ipsPHookInfo; aType: Integer; aIdent, aValue: PChar): LongBool;
  ipsFSend                 = function (aHookInfo: ipsPHookInfo; aData: Pointer; aSize: Integer): LongBool;
  ipsFRecv                 = function (aHookInfo: ipsPHookInfo; aData: Pointer; aSize: Integer): LongBool; // Not implemented
  ipsFLog                  = function (aHookInfo: ipsPHookInfo; aCode, aLevel: Integer; aData: PChar): LongBool;

{ ==========================================================================
  III M   M PPP  L    EEEE M   M EEEE N   N TTTTT  AA  TTTTT III  OO  N   N
   I  MM MM P  P L    E    MM MM E    NN  N   T   A  A   T    I  O  O NN  N
   I  M M M PPP  L    EEE  M M M EEE  N N N   T   AAAA   T    I  O  O N N N
   I  M   M P    L    E    M   M E    N  NN   T   A  A   T    I  O  O N  NN
  III M   M P    LLLL EEEE M   M EEEE N   N   T   A  A   T   III  OO  N   N
  __________________________________________________________________________
  HISTORY __________________________________________________________________
  2002.01.15 - Initial history entry
  __________________________________________________________________________ }
implementation

{ ==========================================================================
    III N   N III TTTTT III  AA  L    III ZZZZZ  AA  TTTTT III  OO  N   N
     I  NN  N  I    T    I  A  A L     I     Z  A  A   T    I  O  O NN  N
     I  N N N  I    T    I  AAAA L     I    Z   AAAA   T    I  O  O N N N
     I  N  NN  I    T    I  A  A L     I   Z    A  A   T    I  O  O N  NN
    III N   N III   T   III A  A LLLL III ZZZZZ A  A   T   III  OO  N   N
  __________________________________________________________________________
  HISTORY __________________________________________________________________
  2002.01.15 - Initial history entry
  __________________________________________________________________________ }
initialization

{ ==========================================================================
         FFFF III N   N  AA  L    III ZZZZZ  AA  TTTTT III  OO  N   N
         F     I  NN  N A  A L     I     Z  A  A   T    I  O  O NN  N
         FFF   I  N N N AAAA L     I    Z   AAAA   T    I  O  O N N N
         F     I  N  NN A  A L     I   Z    A  A   T    I  O  O N  NN
         F    III N   N A  A LLLL III ZZZZZ A  A   T   III  OO  N   N
  __________________________________________________________________________
  HISTORY __________________________________________________________________
  2002.01.15 - Initial history entry
  __________________________________________________________________________ }
finalization

end. // unit ipsHookInterface

{ ==========================================================================
                               EEEE N   N DDD
                               E    NN  N D  D
                               EEE  N N N D  D
                               E    N  NN D  D
                               EEEE N   N DDD
  __________________________________________________________________________
  0        1         2         3         4         5         6         7
  12345678901234567890123456789012345678901234567890123456789012345678901234
  __________________________________________________________________________
      7         6         5         4         3         2         1
  43210987654321098765432109876543210987654321098765432109876543210987654321
  __________________________________________________________________________ }
