/* DOTEST == send a "TEST request to sre2003 server 

*/

/* ------------------------------------------------------------------- */

/* Display extra status messages if verbose=1 */
verbose=0 

/*    -------- End of User changeable parameters   ---------- */

/*ENDUSER*/

call load /* load functions if necessary */
signal on error name err1 ; signal on syntax name err1 
signal on halt name abend

httpport=80
sendclose=1
gosock=0
username='' ;password='' ; upwd=''

parse arg server request mode viewit rsyncarg .

parse source somewhere          /* where called from? */
parse var somewhere . . somewhere . ; somewhere=strip(somewhere)



say "       Send a TEST request to an SRE2003 Server  "

mehost=get_hostname()
crlf    ='0d0a'x                        /* constants */
opts="" 

if server="" then do 
    mehost=get_hostname()
    say " Please enter server address (ENTER= " mehost":"httpport')'
    call charout,"    :"

    parse pull server
    if server="" then server=mehost
end  /* Do */
parse var server server ':' bport
if bport<>'' then httpport=bport

if request="" then  do
  cmd_mode=0
  say " Enter TEST command (ADDRESS NAME PORT TIME CLIENT PING): "
  call charout,"    :"
  parse pull request
end

family  ='AF_INET'

rc=1
if verify(server,'1234567890.')>0 then 
   rc=sockgethostbyname(server, "serv.0")  /* get dotaddress of server */
else
  serv.0addr=strip(server)
if rc=0 then do; say ' ERROR: Unable to resolve "'server'"'; exit; end
dotserver=serv.0addr                    /* .. */
say 
say "Request sent to: "||dotserver ;say " "

gosaddr.0family=family                  /* set up address */
gosaddr.0port  =httpport
gosaddr.0addr  =dotserver

tim1=time('r')
setup1:

gosock = SockSocket(family, "SOCK_STREAM", "IPPROTO_TCP")


httpis='HTTP/1.1'

message='TEST 'request' 'httpis||crlf
message=message||crlf
say "Request message: " message

rc = SockConnect(gosock,"gosaddr.0")
if rc<0 then do; say ' ERROR: Unable to connect to "'server'"'; exit; end
rc = SockSend(gosock, message)
say ' ...  request length = '||rc " bytes "
/* Now wait for the response */
tim2=time('e')
rs=0
gots.=''
gots.0=0
runlen=0
do forever
  response=''
  rc = SockRecv(gosock, "response", 1000)
  if response<>'' then do
     rs=rs+1
     gots.rs=response   
     gots.0=rs
     runlen=runlen+length(response)
  end 
  if verbose=1 then say " ... :" runlen
  if rs=1 & rc<>0 then say " ... got first "rc " bytes of the response "
  if rc<=0 then leave
end 

rc = SockClose(gosock)

tim3=time('e')
say  ' ... response complete: 'runlen 'bytes.'

got=''
do mm=1 to rs
   got=got||gots.mm
end 
say
say " ==  " got

exit

err1:
say "Rexx error "rc " at line "sigl
exit

abend:
tim3=time('e')
if gosock<>0 then do
  say "Closing socket "gosock
  rc=sockshutdown(gosock,2)
  rc = SockClose(gosock)
  dumpit=yesno('Write 'runlen' recieved bytes?')
  if dumpit=1 then do
     t2=''
     do mm=1 to rs
        t2=t2||gots.mm
     end 
     drop gots.
     signal outit
  end
  exit
end

/* --- Load the function library, if necessary --- */
load:

if RxFuncQuery("SockLoadFuncs")=1 then do      /* already there */
  call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
  call SockLoadFuncs
end

/* Load up advanced REXX functions */
foo=rxfuncquery('sysloadfuncs')
if foo=1 then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
end

signal on error name err2 ; signal on syntax name err2
enable_rsync2=1
if rxfuncquery('rx_md4')=1  then do
    aa=RXFuncAdd( 'RXRsyncLoad', 'RXRSYNC', 'RxRsyncLoad')
    if aa=0 then call RxRsyncLoad
    if rxfuncquery('rx_md4')=1  then  enable_rsync2=0
end
signal on syntax name err1 ; signal on error name err1 
return
err2:
enable_rsync2=0
return 

/* get the hostname (aa.bb.cc) for this machine
   Developed by Timur Kazimirov  */

get_hostname:procedure
if \RxFuncQuery("SockLoadFuncs")
  then
    nop
  else
    do
      call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
      call SockLoadFuncs
    end
dot_addr = SockGetHostId()
rc = SockGetHostByAddr(dot_addr, "host.")
return host.name


