/* Script to edit one of the sre2003 configuration files */

/******* User changeable parameters  *****/
/* name of program to use as editor (either relative to path
   or fully qualified */
use_editor='EPM'

/******* End of user changeable parameters  *****/

parse upper arg whichone
whichone=strip(whichone)


/* enable ansi screen controls */
aesc='1B'x
cy_ye=aesc||'[37;46;m'
cyanon=cy_ye
normal=aesc||'[0;m'
bold=aesc||'[1;m'
re_wh=aesc||'[31;47;m'
reverse=aesc||'[7;m'

select
  when whichone='C' then goo='C'
  when whichone='H' then goo='H'
  when whichone='B' then goo='B'
  otherwise do
    say
    say cy_ye "Which SRE2003 configuration file would you like to edit... "normal
    say "   "bold"C"normal": The configuration parameters (CFG\SRE2003.CFG) "
    say "   "bold"H"normal": The host definitions         (CFG\HOSTINFO.CFG) "
    say "   "bold"B"normal": The unallowed IP addresses   (CFG\BADIPS.IN) "
    say "   "bold"X"normal": Exit (leave without editing) "
    call charout,'Which one [C , H, B, or X (Enter=C)]'bold" ? "normal
   pull goo
   goo=strip(goo)
  end
end
select 
   when goo='X' then return 0
   when goo='C' | goo=' ' then do
      say "Editing SRE2003.CFG -- the sre2003 configuration parameters file "
      use_editor' CFG\SRE2003.CFG '
   end
   when GOO='H' then do
      say "Editing HOSTINFO.CFG -- the host definition file "
     use_editor' CFG\HOSTINFO.CFG '
   end
   when GOO='B' then do
      say "Editing BADIPS.IN -- the unallowed IP addresses file "
     use_editor' CFG\BADIPS.IN'
   end
   otherwise return 1
end

return 1

    say "  Note: sreLite2 users might prefer using the on-line configurator at"
    say '        /sre2k/srelite2/config.htm '

