/* Initialize the CHECK_404 SREhttp/2 plugin.

   See CHK_INIT.TXT for the details

Installaton: 
  
  You can use CONFIGS.HTM, which contains a link to a
  the "enable/disable check-404" addon.

  Or, the following describes how to do it by hand.

  Modify the SRE2003 configuration parameter INIT_PROCS.
   
   For example, the default SRE2003.CFG used by SREhttp/2 has:
        init_proc=srehttp2\SREH2INI.RXX
   You should change that to:
        init_proc=srehttp2\SREH2INI.RXX, chk_init.rex

   Note that CHK_INIT.REX should be in the SRE2003\BIN directory.

  The full syntax is:

     CUSTOM_INITS='CHK_INIT.REX  max404 duration '

   Where:
        max404 == threshold number of 404 responses (default=8)
      duration == duration (in minutes) this threshold is computed over
                  (default=5)

   Example:
      init_procs=chk_init.rex 5 10 , srehttp2\sreh2ini.rxx
    
*/

parse arg  stuff
parse arg port,servername, filter_dir,arg_list

parse var arg_list max404 duration keepout verbose
if max404='' then max404=8
if duration='' then duration=10

if datatype(max404)<>'NUM' | datatype(duration)<>'NUM' THEN DO
   call pmprintf(' CHK_INIT error -- bad parameter= 'max404 ': 'duration)
   return 0
end 

/* set up the CHK_404 cache */
ownid=sre_dmn_own(,,'CACHEIT')
astat=sre_cache('CHK_404','CREATE',,,,ownid)
if astat<>1 then do
   call sre_pmprintf(' CHK_INIT error -- unable to create CHK_404 cache: 'astat)
   return 0
end
foo=sre_dmn_command(ownid,'DISCONNECT')

/* save some SYS variables */
oo=sre_value('CHK_404_MAX404',max404,'sre')
adur=format((duration*60)/86400,6,5)    /* convert to fractons of day, in seconds */
oo=sre_value('CHK_404_DURATION',adur,'sre')

return 1
