/* Post-response component of the the CHECK_404 SREhttp/2 plugin.
   See CHK_404.TXT for the details
*/

chk_post:

/******** User changeable parameters  ******/
/* space delimited list of host-nicknames that will NOT be checked */
NO_CHECK_HOSTS=''

/******** End of user changeable parameters  ******/

parse arg request,source,seloriginal,seluse2,reqnum,user , ,
           myfile,rcode,host_nickname,id_info


parse var rcode rcode bytes 
if strip(rcode)<>404 then return 0      /* not 404, so do nothing */

parse var source myaddr port transaction who whoport . /* Often useful */
susers=sreh2_value('SUPERUSERS',,host_nickname)
if wordpos(strip(who),susers)>0 then return  0  /* don't bother superusers */

if no_check_hosts<>'' then do
   if wordpos(translate(host_nickname),translate(no_check_hosts))>0 then return 0
end

/* otherwise, record this entry */
nowtime=sreh2_current_second()

foo=sre_cache('CHK_404','PREPEND',who,nowtime||' ',,0)

return 0

