/*Example of a rexx procedure called as an EXEC procedure 
  EXEC procedures are specified as "selector specific advanced
  options" in ATTRIBS.CFG, they are called "mid-filter".
  See ADV_OPTS.HTM for the details (OUTLINE.HTM is also
  helpful) */

/* SREhttp/2 passes the following arguments */
parse arg anarg,source,request,seluse2,servername,host_nickname,datadir

call sre_pmprintF('--- sample EXEC (mid-filter) procedure ---')
call sre_pmprintF("  The following arguments were recieved: ")
call sre_pmprintF("    Args from the EXEC line in the ATTRIBS.CFG record: " anarg)
call sre_pmprintF("    Source: " source)
call sre_pmprintF("    Request: " request)
call sre_pmprintF("    (possibly modified) selector: " seluse2)
call sre_pmprintF("    Servername: " servername)
call sre_pmprintF("    Host Nickname: " host_nickname)
call sre_pmprintF("    DataDirectory: " datadir)
call sre_pmprintF('---        End       ---')

return ''

/* note EXEC procedures should ALWAYS return ''.  The only exception is 
when a EXEC procedure issues a response to the client (using SRE_COMMAND).
Then, you should return what SRE_COMMAND returns (the response code and
the bytes sent)
*/
