/* this is the ThumbIndex addon for  SRE-http installation program */

/* Load up advanced REXX functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 call rxfuncadd 'rexxlibregister','rexxlib', 'rexxlibregister'
 call rexxlibregister
end
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
    say " Could not find REXXLIB "
    exit
end /* do */


crlf='0d0a'x
copyall=0


ansion=checkansi()
if ansion=1 then do
  aesc='1B'x
  cy_ye=aesc||'[37;46;m'
  normal=aesc||'[0;m'
  bold=aesc||'[1;m'
  re_wh=aesc||'[31;47;m'
  reverse=aesc||'[7;m'
end
else do
  say " Warning: Could not detect ANSI....  Install will look ugly ! "
  parse pull .
  cy_ye="" ; normal="" ; bold="" ;re_wh="" ;
  reverse=""
end  /* Do */

cls
say  " " ; say

call lineout, bold cy_ye
call lineout, "This is the ThumbIndex ver 1.3 installation program (5/02).  "
call lineout, normal
say "" 
say " This program will ask for the names of a few directories,"
say " and will copy a number of files to these directories."
say "  "

if yesno(" Are you ready to continue ")=1 then
 nop
else do
 say " See you later?.. "
 exit
end


nowdir=directory()

godir=filespec('d',nowdir)||'\GOSERVE'
webdir=filespec('d',godir)||'\WWW'


gunky2:
say " "
call charout,  bold " Enter the GoServe working directory (that contains SREFILTR.80)" normal crlf
call charout,"  ENTER= " godir  " ? "
parse pull work_dir
if work_dir="" then work_Dir=godir
work_dir=strip(work_dir,'t','\')
foo=is_dir(work_dir)
if foo=0 then do
    say " Could not find directory: " work_dir
    signal gunky2
end
foo=work_dir||'\SREFILTR.80'
if stream(foo,'c','query exists')=' ' then do
   say
   if yesno(" Could not find SREFILTR.80.  Are you sure? ")=0 then signal gunky2
end  /* Do */


addondir=work_dir||'\ADDON'
gunky2a:
say " "
say  bold " Enter the SRE-http " normal reverse " addon " normal bold " directory " normal 
call charout,"  ENTER= " addondir  " ? "
parse pull addon_dir
if addon_dir="" then addon_Dir=addondir
addon_dir=strip(addon_dir,'t','\')
foo=is_dir(addon_dir)
if foo=0 then do
    say " Could not find directory: " addon_dir
    signal gunky2a
end

gunky3a:
say " "
say  bold " Enter the GoServe data directory (the root of your web tree)" normal
call charout,"  ENTER= " webdir  " ? "
parse pull web_dir ; web_dir=strip(web_dir)
if web_dir="" then web_Dir=webdir
web_dir=strip(web_dir,'t','\')
foo=is_dir(web_dir)
if foo=0 then do
    say " Could not find directory: " web_dir
    signal gunky3a
end

thumbsel='THUMCASH'
gunky4t:
say " "
    say bold "      ... the ThumbIndex database subdirectory of " web_dir ||normal
call charout,"      ENTER= " thumbsel  " ? "
parse pull thumb_sel ; thumb_sel=strip(thumb_sel)
if thumb_sel="" then thumb_sel=thumbsel
thumb_sel=strip(thumb_sel,,'\')
thumb_dir=web_dir'\'thumb_sel
foo=is_dir(thumb_dir)
if foo=0 then do
    say "         Creating " thumb_dir
    wow=dosmkdir(thumb_dir)
    if wow=0 then do
      say "       Could not create " thumb_dir
       signal gunky4t
    end
end
say " "

if yesno(" Are you ready to copy the files ")=0 then do
   say " Okay, you can try again later "
   exit
end  /* Do */
    
say " "

say " Copying DLLs and EXEs to " work_dir
ain=check_copy('GIFWRITE.DLL',work_dir)
ain=check_copy('RXGDUTIL.DLL',work_dir)
ain=check_copy('EA2GIF.EXE',work_dir)
AIN=CHECK_COPY('GBMHDR.EXE',WORK_DIR)
AIN=CHECK_COPY('GBMSIZE.EXE',WORK_DIR)
AIN=CHECK_COPY('GBM.DLL',WORK_DIR)
AIN=CHECK_COPY('GBMBPP.EXE',WORK_DIR)

ain=check_copy('DEFAULT.HDR',thumb_dir)
ain=check_copy('DEFAULT.FTR',thumb_dir)


say " Modifiying, and Copying ThumIndx.CMD file to " addon_dir
ain=charin('thumindx.CMD',1,chars('thumindx.CMD'))
foo=stream('thumindx.CMD','c','close')
a1="THUMBNAIL_DIR='"||thumb_dir"'"
ain=replacestrg(ain,"THUMBNAIL_DIR='thumcash'",a1)

thumb_sel=translate(thumb_sel,'/','\')
a1="THUMBNAIL_DIR_SEL='"thumb_sel"'"
ain=replacestrg(ain,"THUMBNAIL_DIR_SEL='thumcash'",a1)

a1="WWW_DIR='"WEB_DIR"'"
boo=replacestrg(ain,"WWW_DIR='WWW'",a1)



foo=sysfiledelete('thumindx.$$$')
foo=charout('thumindx.$$$',boo,1)
if foo>0 then do
    say " ERROR: could not write temporary file (thumindx.$$$)"
    exit
end
foo=stream('thumindx.$$$','c','close')
ain=check_copy('thumindx.$$$',addon_dir'\thumindx.CMD')
foo=sysfiledelete('thumindx.$$$')



say " Copying HTML documents to " web_dir
ain=check_copy('THUMINTR.HTM',web_dir)
ain=check_copy('THUMSIDE.HTM',web_dir)
ain=check_copy('THUMTOP.HTM',web_dir)
ain=check_copy('THUMINDX.HTM',web_dir)

say " "
say reverse " ------------------------------------------------- "normal
say bold " ThumbIndex has been installed. " normal
say " "
say " To use ThumbIndex, or to learn more about what it does"
say " try out ThumIndx.HTM (located in " web_dir ")"
say " "

exit

/* ------------------------------------------------------------------ */
 /* function: Check if ANSI is activated                               */
 /*                                                                    */
 /* call:     CheckAnsi                                                */
 /*                                                                    */
 /* where:    -                                                        */
 /*                                                                    */
 /* returns:  1 - ANSI support detected                                */
 /*           0 - no ANSI support available                            */
 /*          -1 - error detecting ansi                                 */
 /*                                                                    */
 /* note:     Tested with the German and the US version of OS/2 3.0    */
 /*                                                                    */
 /*                                                                    */
 CheckAnsi: PROCEDURE
   thisRC = -1
 
   trace off
                         /* install a local error handler              */
   SIGNAL ON ERROR Name InitAnsiEnd
 
   "@ANSI 2>NUL | rxqueue 2>NUL"
 
   thisRC = 0
 
   do while queued() <> 0
     queueLine = lineIN( "QUEUE:" )
     if pos( " on.", queueLine ) <> 0 | ,                       /* USA */
        pos( " (ON).", queueLine ) <> 0 then                    /* GER */
       thisRC = 1
   end /* do while queued() <> 0 */
 
 InitAnsiEnd:
 signal off error
 RETURN thisRC


/* -------------------- */
/* get a yes or no , return 1 if yes */
yesno:procedure expose normal reverse bold
parse arg fooa , allopt,altans
if altans<>" " & words(altans)>1 then do
   w1=strip(word(altans,1))
   w2=strip(word(altans,2))
   a1=left(w1,1) ; a2=left(w2,1)
   a1a=substr(w1,2) ; a2a=substr(w2,2)
end
else do
    a1='Y' ; a1a='es'
    a2='N' ; a2a='o'
end  /* Do */
ayn='  '||bold||a1||normal||a1a||'\'||bold||a2||normal||a2a
if allopt=1 then  ayn=ayn||'\'||bold||'A'||normal||'ll'

do forever
 foo1=normal||reverse||fooa||normal||ayn
 call charout,  foo1 normal ':'
 pull anans
 if abbrev(anans,a1)=1 then return 1
 if abbrev(anans,a2)=1 then return 0
 if allopt=1 & abbrev(anans,'A')=1 then return 2
end


/* ------------- */
/* ----------------------------------------------------------------------- */
/* REPLACESTRG: In string astring, find first occurence substring target and
.   replace it with substring putme
.      if no target, return unchanged astring
.      if no putme, then remove target
.      if type=backward, then find/change LAST occurence
.      if type=all, find/change all occurences
.      if exactmatch=yes, then do not capitalize during search (exact match only */
/* ----------------------------------------------------------------------- */

replacestrg: procedure

exactmatch=0
backward=0 ; doall=0

parse arg astring ,  target   , putme , type , exactmatch

type = translate(type)
if type="BACKWARD" then backward="YES"
if type="ALL" then doall="YES"

iat=1
joelen=length(target)
joelen2=length(putme)

doagain:                /* here if doall=yes */
 if exactmatch="YES" | exactmatch=1 then do
    if   backward="YES" then
        joe= lastpos(target,astring)
    else
        joe= pos(target,astring,iat)
 end
 else do
   if   backward="YES" then
        joe= lastpos(translate(target),translate(astring))
    else
        joe= pos(translate(target),translate(astring),iat)
 end


 if joe=0 then
         return astring

 astring=delstr(astring,joe,joelen)
 if putme<>' ' then
    astring=insert(putme,astring,joe-1)

 if doall="YES" then do
     iat=joe+joelen2
     signal doagain
 end
/* else, all done */
 return astring

/*******************************************/
/* check for existence of file, then ask user to copy or not */
/* note that for X.* type copies, it only checks once
   (not for each file, but just for any one of them */
/********************************************/
check_copy: procedure expose copyall reverse bold normal
parse arg file1, dest1 , asis
amess=''

if asis="" then do
  dest2=strip(dest1,'t','\')||'\'
  filename=dest2||file1
end
else do
  filename=dest1
end /* do */

if copyall=1 then signal doit3

aa=sysfiletree(filename,isit,'F')

ok=1
if aa<>0 then do
   say " Warning: error when looking for pre-existing copy of: " filename
   ok=yesno(" Do you want to copy this file (or files) anyways? ")
   if ok=1 & amess<>""  then
      ok=yesno(amess)
end

if isit.0>0 then do
  if pos('*',file1)=0 then do
      say " "
      say " A file exists with the name: " filename
      ok=yesno(" Do you want to overwrite this file? ",1)
      if ok=1 & amess<>""  then
           ok=yesno(amess)
  end
  else do
    say " "
      say " There is at least one file that matches: " filename
      say "  (this match may " bold " not " normal " be one of the files that will be copied!) "
      ok=yesno(" Do you want to copy these files? ",1)
      if ok=1 & amess<>""  then
           ok=yesno(amess)
  end  /* Do */

end

if ok=2 then do
  say " "
  say "SRE-http will overwrite all files (not just these) "
  copyall=yesno(" Are you sure you want to do this?")
  if copyall=0 then
      ok=yesno(" Do you want to overwrite the current file (or files)? ")
end

if ok=0  then return 0

doit3:          /* jump here if copyall is on, or noask=1 */
'@COPY ' file1 dest1 ' > NUL '

return 1


/* return 1 if adir is an existing (possibly empty) directory , 0 if not */
is_dir:procedure 
parse arg adir

adir=strip(adir)
adir=strip(adir,'t','\')
nowdir=directory()
nowdrive=filespec('d',nowdir'\')
nowpath=filespec('p',nowdir'\')
adr=filespec('d',adir)
if adr='' then do
   if abbrev(adir,'\')=0 then 
       adir=nowdrive||nowpath||adir
   else
       adir=nowdrive||adir
end /* do */

foo=sysfiletree(adir,goo,'D')
if  goo.0>0  then return 1
return 0



