"""
XMLKit - Tools to encode, decode, interpret and display XML files
"""
# $Id: __init__.py,v 1.1.1.1 2002/02/03 17:07:16 root Exp $
#
# $Log: __init__.py,v $
# Revision 1.1.1.1  2002/02/03 17:07:16  root
#
#
# Revision 1.8  2002/01/30 11:36:14  adrian
# Depricated XMLODBCClient. Does not work on Zope 2.3.x
# which does not support the 'visibility=' attribute to registerClass
#
# Revision 1.7  2002/01/18 13:49:44  adrian
# Moved ODBCClient to ZDataQueryKit
#
# Revision 1.6  2001/11/14 13:35:33  adrian
# Added ODBC Socket Server client object.
#
# Revision 1.5  2001/10/29 01:21:06  adrian
# Removed a some redundant code
# Tidied up registration of DTML-VAR special formats "entity_encode" and "entity_decode"
#
# Revision 1.4  2001/10/22 11:55:36  adrian
# Added XMLProxy class. XMLProxy combines the download/cache
# ability of XMLDocument with the Method interface of XMLFile, to
# provide a simple way to cache remote XML source locally within Zope.
#
# Revision 1.3  2001/10/22 11:07:31  adrian
# no message
#
# Revision 1.2  2001/10/21 15:10:16  adrian
# no message
#
#
__version__ = '$Revision: 1.1.1.1 $'[11:-2]

import XML
import DocumentTemplate.DT_Var

def encode(val, name='(Unknown Name)', md={}):
    """ """
    return XML.XMLParser.encode(val)

def decode(val, name='(Unknown Name)', md={}):
    """ """
    return XML.XMLParser.decode(val)

sf = DocumentTemplate.DT_Var.special_formats
sf['entity_encode'] = encode
sf['entity_decode'] = decode
DocumentTemplate.DT_Var.special_formats = sf

import XMLDocument
import XMLFolderIndex
import XMLFile
import XMLProxy
import XMLODBCClient

def initialize(context):
    context.registerClass(
        XMLDocument.XMLDocument,
        meta_type='XML Document',
        permission='Add XML Documents',
        icon='www/XMLDocument.gif',
        constructors=(
            XMLDocument.manage_addXMLDocumentForm,
            XMLDocument.manage_addXMLDocument,
        ),
    )
    context.registerClass(
        XMLDocument.RSSDocument,
        meta_type='RSS Document',
        permission='Add RSS Documents',
        icon='www/RSSDocument.gif',
        constructors=(
            XMLDocument.manage_addRSSDocumentForm,
            XMLDocument.manage_addRSSDocument,
        ),
    )
    context.registerClass(
        XMLFolderIndex.XMLFolderIndex,
        meta_type = 'XML Folder Index',
        permission = 'Add XML Folder Indexes',
        icon = 'www/XMLFolderIndex.gif',
        constructors=(
            XMLFolderIndex.manage_addXMLFolderIndexForm,
            XMLFolderIndex.manage_addXMLFolderIndex,
        ),
    )
    context.registerClass(
        XMLFile.XMLFile,
        meta_type = 'XML File',
        permission = 'Add XML Files',
        icon = 'www/XMLFile.gif',
        constructors=(
            XMLFile.manage_addXMLFileForm,
            XMLFile.manage_addXMLFile,
        ),
    )
    context.registerClass(
        XMLProxy.XMLProxy,
        meta_type = 'XML Proxy',
        permission = 'Add XML Proxies',
        icon = 'www/XMLProxy.gif',
        constructors=(
            XMLProxy.manage_addXMLProxyForm,
            XMLProxy.manage_addXMLProxy,
        ),
    )
    try:
        context.registerClass(
            XMLODBCClient.XMLODBCClient,
            meta_type = 'Depricated ODBC Client',
            permission = 'Add ODBC Clients',
            icon='www/XMLODBCClient.gif',
            constructors = (
                XMLODBCClient.manage_addXMLODBCClientForm,
                XMLODBCClient.manage_addXMLODBCClient,
            ),
            visibility=None
        )
    except:
        pass

    context.registerHelpTitle('XML Kit')
    context.registerHelp()

