/*
 * Filename: create_groups.cmd
 *   Author: jeffnik
 *  Created: Wed Dec  4 2002
 *  Purpose: Create the proper groups and permissions for Zope (if needed)
 *  Changes: 
 */

/* Parse the argument to nab the location of our "ETC" directory */
if (arg() > 0) THEN DO
    /*
    etcDir = arg(1);
    zopeDir = arg(2);
    */
    PARSE VAR arg() etcDir zopeDir;
END;
ELSE DO
    say "No package was given to download.";
    call beep 440,250;
    exit 1;
END

say 'Creating Zope "group" and "passwd" files...';

/* Check to see if the passwd file exists */
say "Our etcDir variable is: "||etcDir;
if (LASTPOS('\', etcDir) < LENGTH(etcDir)) THEN DO
    etcDir = etcDir||"\";
END

passwdFile = etcDir||"passwd";

If STREAM(passwdFile,'C','QUERY EXISTS') <> "" THEN DO
    say passwdFile||" already exists.  Exiting";
    call beep 440,250;
    exit;
END;

/* Write out the contents of our new passwd file */

say "Writing WIS file...";

rc = STREAM(passwdFile, "C", "open write");
if (rc <> "READY:") THEN DO
    say "passwd Stream isn't ready to be written: "||rc;
    exit;
    END

rc = LINEOUT(passwdFile, 'root;*;0;0;SuperUser;D:/root;D:/bin/sh', 1);
rc = LINEOUT(passwdFile, 'toor;*;0;0;SuperAlterEgo;D:/root;D:/bin/sh');
rc = LINEOUT(passwdFile, 'zope;*;0;0;'||zopeDir||';D:/bin/sh');
rc = STREAM(passwdFile, "C", "Close");


/* Check to see if the groups file exists */
If STREAM(etcDir||"\group",'C','QUERY EXISTS') <> "" THEN DO
    say etcDir||"group already exists.  Exiting";
    call beep 440,250;
    exit;
END

groupFile = etcDir||"group";

rc = STREAM(groupFile, "C", "open write");
if (rc <> "READY:") THEN DO
    say "group Stream isn't ready to be written: "||rc;
    call beep 440,250;
    exit;
    END

rc = LINEOUT(groupFile, 'root;;0;', 1);
rc = LINEOUT(groupFile, 'wheel;;10;');
rc = LINEOUT(groupFile, 'users;;1000;');
rc = LINEOUT(groupFile, 'staff;;1001;');
rc = LINEOUT(groupFile, 'zope;;15;');
rc = STREAM(groupFile, "C", "Close");

