/* Example DOS program to demonstrate joystick functions	*/
/* 02jul22 jDS bug-fix in JoySticksXY(). Use 2 not 1 for quickC */
/* 02jul24 jDS tidy-up code */
struct JoyStickStruc {
  short int PosX[2];	/* current joystick XY positions */
  short int PosY[2];
  short int MaxX[2];	/* max & min joystick XY settings */
  short int MinX[2];
  short int MaxY[2];
  short int MinY[2];
  char	    Button1[2]; /* pushbutton 1, 0=no, 1=yes */
  char	    Button2[2]; /* pushbutton 2, 0=no, 1=yes */
  char	    AnyButton;	/* any 4 pushbuttons pressed, 0=none */
  char	    AnyJoys;	/* any joysticks? 0=none */
} JoyStick;

void main(void);
void JoyStickBut(void);
void JoySticksXY(void);
void JoyStickDir(void);

void main(void) {
  JoyStick.AnyButton = 0;
  JoyStick.AnyJoys = -1;
  printf("\nPress a key to stop program\n\n");
  while (!kbhit()) {
    //JoyStick.AnyButton == 0 && JoyStick.AnyJoys != 0) {
    JoySticksXY(); JoyStickBut();
    printf("\nBios=%4x %4x %4x %4x",JoyStick.PosX[0],JoyStick.PosY[0],JoyStick.PosX[1],JoyStick.PosY[1]);
    printf("   %2x",(0x0F0 & (JoyStick.AnyButton ^ 0x0F0)));

    JoyStickDir();
    printf(" Direct=%4x %4x %4x %4x",JoyStick.PosX[0],JoyStick.PosY[0],JoyStick.PosX[1],JoyStick.PosY[1]);
    printf("   %2x",(0x0F0 & (JoyStick.AnyButton ^ 0x0F0)));
  }
}

void JoyStickBut(void) {
/* this routine does a BIOS call for all 4 joystick buttons.
/*/
  _asm {
	mov	ah,84h		;get all 4 pushbuttons
	mov	dx,0
	int	15h
	jnc	joys		;continue if BIOS joystick function exists
	mov	al,0F0h		;no BIOS function, return no button presses
  joys: xor	al,0F0h		;store status of all buttons, 0=nil
	and	al,0F0h
	mov	JoyStick.AnyButton,al
	xor	bx,bx		;prepare to save joystick buttons pressed
	xor	cx,cx
	shl	al,1		;check if joystick2 button2 pressed
	rcl	ch,1
	shl	al,1		;check if joystick2 button1 pressed
	rcl	bh,1
	shl	al,1		;check if joystick1 button2 pressed
	rcl	cl,1
	shl	al,1		;check if joystick1 button1 pressed
	rcl	bl,1
	mov	JoyStick.Button1[0],bx
	mov	JoyStick.Button2[0],cx
  }
}

void JoySticksXY(void) {
/* This routine does a BIOS call for all 4 joystick X+Y values.
/* jul22/02 bug-fix changed 1 to 2 so values stored in correct locations.
/*/
  _asm {
	mov	ah,84h		;get all 4 joystick positions
	mov	dx,1
	int	15h
	jnc	joys		;continue if BIOS joystick function exists
	xor	ax,ax		;if here, no BIOS function for joysticks...
	xor	bx,bx		;...return values as 0=nojoysticks
	xor	cx,cx
	xor	dx,dx
  joys: mov	JoyStick.PosX[0],ax ;hold values sent from BIOS
	mov	JoyStick.PosY[0],bx
	mov	JoyStick.PosX[2],cx ;..(bug in quickC, use 2 not 1)
	mov	JoyStick.PosY[2],dx ;..(bug in quickC, use 2 not 1)

	or	ax,cx		;set flag for joystick(s) existing
	or	al,ah
	mov	JoyStick.AnyJoys,al
  }
}

void JoyStickDir(void) { /* get joystick values thru JoyStick Port */
/* This routine does all 4 joystick X+Y values at a time.
/* This routine modified from "Gary T. Desrosiers" <desrosi@pcnet.com>
/* feb19/98 response to my question about noisy joystick numbers.
/*/
  _asm {
	xor	ax,ax		;we need a zero
	xor	bx,bx
	mov	JoyStick.PosX[0],bx ;start with zero
	mov	JoyStick.PosY[0],bx
	mov	JoyStick.PosX[2],bx
	mov	JoyStick.PosY[2],bx
	mov	cx,400h		;runaway counter
	mov	dx,201h		;game port address
	cli			;needed to ensure consistency
	out	dx,al		;trigger game port event
	in	al,dx		;read game port bits
	mov	ah,al		;save pushbuttons for later
  ;loop until all joysticks are done or loopcounter hits zero
  joyL: test	al,00fh		;done yet?
	jz	short joyB	;yes, now go do pushbuttons
	shr	al,1		;get X bit in carry flag
	adc	JoyStick.PosX[0],bx
	shr	al,1		;get X bit in carry flag
	adc	JoyStick.PosY[0],bx
	shr	al,1		;get X bit in carry flag
	adc	JoyStick.PosX[2],bx
	shr	al,1		;get X bit in carry flag
	adc	JoyStick.PosY[2],bx
	in	al,dx		;read game port bits
	loopnz	joyL
  ;now set all pushbutton values
  joyB: sti			;match the previous cli
	xor	ah,0F0h		;inverse logic on pushbuttons
	and	ah,0F0h		;put results in anybutton
	mov	JoyStick.AnyButton,ah
	xor	bx,bx		;zero all button presses
	xor	cx,cx
	shl	ax,1		;joystick2 button2
	rcl	ch,1
	shl	ax,1		;joystick2 button1
	rcl	bh,1
	shl	ax,1		;joystick1 button2
	rcl	cl,1
	shl	ax,1		;joystick1 button1
	rcl	bl,1
	mov	JoyStick.Button1[0],bx
	mov	JoyStick.Button2[0],cx
  }
}
