
#define INCL_DOSPROCESS
#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#include <os2.h>
#include <stdio.h>
#include "hrtx.h"

HFILE hf;
ULONG rc,pSize,dSize,wasted;

ULONG resolution = 1;
ULONG *pTimerCount;
ULONG WaitTime = 30000UL;
ULONG handle;
ULONG StartTime, EndTime;
VER ver;

int main(void)
{

        // Open the timer device.

        rc=DosOpen("TIMER0$  ",&hf,&wasted,0,0,OPEN_ACTION_OPEN_IF_EXISTS,
                   OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYNONE | OPEN_ACCESS_READWRITE,
                   NULL);
        if (rc) {
                printf("Unable to open HRTX");
                goto exit_err;
        }

        printf("HRTX opened\n");

        // Get and print the version of the currently running timer

        dSize=sizeof(VER);
        rc=DosDevIOCtl(hf,HRTXIOCTL_CATEGORY, HRTXIOCTL_X_QUERYVERSION,
                       NULL,0,NULL,
                       &ver, dSize, &dSize);

        if(rc) {
                printf("Unable to get versin info");
                goto exit_err;
        }

        printf( "Version : %s\n"
                "BuildID : %s\n"
                "Desc    : %s\n\n",ver.ver, ver.build, ver.desc);


        // Opening the timer automatically registers the current process as a client
        // for use with the compatibility API (and closing it deregisters the timer).
        // We could acquire the handle to this timer and use this, but to demonstrate
        // the use of the extended API in full we deregister this timer by acquiring
        // its handle and explicitly deregistering it.


        dSize=sizeof(ULONG);
        rc=DosDevIOCtl(hf,HRTXIOCTL_CATEGORY, HRTXIOCTL_X_QUERYCOMPATHANDLE,
                       NULL,0,NULL,
                       &handle,dSize, &dSize);
        if(rc) {

                printf("Unable to get handle");
                goto exit_err;
        }

        printf("Compatibility timer handle : %ld\n\n",handle);

        // and deregister it

        printf("Deregistering compatibility client\n\n");

        pSize=sizeof(ULONG);
        rc=DosDevIOCtl(hf,HRTXIOCTL_CATEGORY, HRTXIOCTL_X_DESTROYTIMER,
                       &handle,pSize,&pSize,
                       NULL,0,NULL);

        if(rc) {
                printf("Can not deregister compatibility timer ");
                goto exit_err;
        }

        // Now register for a new extended timer.

        dSize=sizeof(ULONG);
        rc=DosDevIOCtl(hf,HRTXIOCTL_CATEGORY, HRTXIOCTL_X_CREATETIMER,
                       NULL,0,NULL,
                       &handle,dSize, &dSize);
        if(rc) {

                printf("Unable to get handle ");
                goto exit_err;
        }

        printf("Extended handle is : %ld\n\n",handle);


        // Set its resolution to 1ms resampled (the default)

        pSize=sizeof(ULONG);
        dSize=sizeof(ULONG);
        rc=DosDevIOCtl(hf,HRTXIOCTL_CATEGORY,HRTXIOCTL_X_SETRESOLUTION,
                       &handle, pSize,&pSize, &resolution,dSize,&dSize);
        if (rc) {
                printf("Couldn't set resolution ");
                goto exit_err;
        }

        // get the counter address for this timer.

        pSize=sizeof(ULONG);
        dSize=sizeof(ULONG);
        rc=DosDevIOCtl(hf,HRTXIOCTL_CATEGORY,HRTXIOCTL_X_QUERYCOUNTADDR,
                       &handle,pSize,&pSize,&pTimerCount,dSize,&dSize);
        if (rc) {
                printf("Couldn't get pointer ");
                goto exit_err;
        }

        // Now block this thread for the <delay> length of timer

        printf("waiting - timer lin=%ld\n",*pTimerCount);

        // need to see the updates quickly so we can get an accurate view
        // of the count

        DosSetPriority(0,PRTYC_TIMECRITICAL,0,0);

        StartTime=*pTimerCount;

        pSize=sizeof(ULONG);
        dSize=sizeof(ULONG);
        rc=DosDevIOCtl(hf,HRTXIOCTL_CATEGORY,HRTXIOCTL_X_BLOCKTHREAD,
                       &handle,pSize,&pSize,
                       &WaitTime,dSize,&dSize);

        EndTime=*pTimerCount;

        printf("ending - rc from BLOCKTHREAD=%ld\n",rc);

        printf("Start = %ld, End =%ld, run time = %ld\n", StartTime, EndTime, EndTime - StartTime);

exit_err:

        // Must deregister the timer that we have allocated.
        // if we have one...

        if(rc)
                printf("Error code %ld\n",rc);

        pSize=sizeof(ULONG);
        rc=DosDevIOCtl(hf,HRTXIOCTL_CATEGORY, HRTXIOCTL_X_DESTROYTIMER,
                       & handle,pSize,& pSize,
                       NULL,0,NULL);

        if(rc)
                printf("Can not deregister timer ");

        // close the timer device

        rc=DosClose(hf);
        return rc;

}



