/* monydemo.c   */

// 24-Jan-96 - original (chh) */
//  6-Feb-96 - changed cursor verify logic to not end demo if another Mony task running
// 21-Mar-96 - changed logic so that more stuff is done even if only 1 page available
// 21-Mar-96 - see EMX_MONY.ZIP for alternate source and header files


/*  ------------------------------------------------- *
 *  The demo requires that evaluation complete within *
 *  25 minutes of each boot.  A license is needed to  *
 *  use the Mony MDA BIOS emulator after the first 25 *
 *  minutes.                                          *
 *  ------------------------------------------------- */


// Calls return 0xFF14 if Mony is busy.  This will only happen if another device driver
// is using Mony's IDC entry and is calling a Mony routine at interrupt time.
// Conversely, a Mony-using device driver calling Mony's IDC entry gets a 0xFE14 if
// Mony is busy (i.e., ax=0FE14h, and the CF set as well).  Mony makes no system
// calls except during init.  DevHlp is used for Beep'ing at WriteTTY and WriteString
// when chr(7) is seen, and VerifyAccess for DosDevIOCtl processing.

// This demo program uses the simplified API found in monyapi.c.  All the register
// set ups and IO Control calls are wrapped up in a pretty simple API.  Source is
// included to change as you set fit.

// Most calls are supported with error checking, but some assume all is well (esp.
// if a previous, indentical call, has been done.

#define INCL_BASE
#define INCL_DOSDEVIOCTL

#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mony_api.h"

void AskForKey(void);   // proto misc routine

// Play ball!

APIRET main(void) {

   HFILE monyID=0;      // mony DD handle
   ULONG action;        // open action
   ULONG rc;            // result code

   PVOID bufferPtr=0;

   BIOSDATA VBD;        // Mony functionality info, 64 bytes' worth

   CHAR signOnStr[] = "Mony Demo - The second monitor is alive!\n";

   UCHAR i;             // working storage
   UCHAR page;
   UCHAR row;
   UCHAR column;
   UCHAR topLine;
   UCHAR bottomLine;
   UCHAR r0,c0;
   UCHAR r1,c1;
   UCHAR rows, columns;


   setbuf(stdout,NULL);

   printf("\nMony Demo - Must be run within 25 minutes of booting with MONY.SYS. (21-Mar-96)\n\n");
   printf("Most of the Mony functions are gone through at least once in the demo\n");
   printf("following.  After each step, you're asked to press a key to move on to\n");
   printf("the next.  Information is generally shown on the main display, with the\n");
   printf("resulting action taking place over on the mony.  Right now, there should\n");
   printf("be the Mony banner displaying. If not, make sure that the line\n\n");

   printf("     DEVICE=mony.sys [-p8] (8 video pages)\n\n");

   printf("is in config.sys, and that you just recently rebooted.  If still nothing,\n");
   printf("call the BBS or visit the FTP site for a good version of the package.\n\n");

   printf("Mony runs on any dual-monitor system.  You can control it from a PM/WPS\n");
   printf("program; a console program (like this one); or even from another physical\n");
   printf("device driver via IDC (at task or interrupt time).  Tired of scrolling\n");
   printf("PMprintf?  Want to work with a real screen, with up to 8 different pages?\n");
   printf("Mony let's you.  You do need to pay for the software.  See the order form\n");
   printf("for details.\n\n");

   AskForKey();

   printf("Opening Mony via DosOpen()...");

   rc = DosOpen("MONY$",&monyID,
                &action,0,
                FILE_NORMAL,FILE_OPEN,
                OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYREADWRITE,0);
   if (rc) {
      printf("Cannot open MONY$ device driver");
      goto DieYoung;
   }

   printf("okay.  Do you see anything different?\n");
   printf("You shouldn't, not yet, but you will.\n");

   AskForKey();

   // Setting the video mode puts the Mony sub-system in a known state

   rc = MonySetVideoMode(monyID, 7);
   if (rc) {
      printf("Failed video mode set");
      goto DieYoung;
   }

   // Get and show the current state of affairs

   rc = MonyGetBiosData(monyID, &VBD);
   if (rc) {
      printf("Failed get data");
      goto DieYoung;
   }
   printf("The GetBiosData() lets you check out vital stats.  For example:\n\n");
   printf("Driver: v%i.%.3i  Mode: %i  Rows: %i  Cols: %i  Pages: %i\n\n",
          VBD.monyVersion/1000, VBD.monyVersion % 1000,
          VBD.videoMode, VBD.rows, VBD.columns, VBD.pages);
   printf("There's more from where that came from, but you get the idea.\n");

   // Put something up over there

   printf("Check your Mony monitor!  It comes alive as soon as you...\n");
   AskForKey();

   rc = MonyWriteString(monyID,
                        signOnStr,      // what to write
                        0,              // where to write (page)
                        7,              // how to write (attr)
                        0,0);           // spot to write (row,col)
   if (rc) {
      printf("Failed write string");
      goto DieYoung;
   }


   printf("Well, what did you expect?  Maybe something a bit different?\n");
   AskForKey();

   rc = MonyWriteString(monyID,
                        signOnStr,      // what to write
                        0,              // where to write (page)
                        0x70,           // how to write (attr)
                        1,0);           // spot to write (row,col)

   printf("Want more?  There are a few more tricks in that hat, but you find them.\n");
   printf("Let's check out the cursor.  First, we'll show it, then move it around.\n");
   AskForKey();

   rc = MonySetCursorSize(monyID,0,13); // shows fat cursor at 0,0 (from init above)
   printf("You should be looking over there...\n");
   DosSleep(2000);                      // wait a couple of seconds...(uh-oh, rc okay?)
   rc = MonySetCursorPos(monyID,0,12,39); // page 0, row 12, column 39 (0=first)

   printf("\nHold on a sec while I verify that the cursor is fat and that the page 0\n");
   printf("cursor is indeed at row 12, column 39 (0=first).  ");

   rc = MonyGetCursorStatus(monyID,0,&row,&column,&topLine,&bottomLine);
   if ((row==12) & (column==39) & (topLine==0) & (bottomLine==13)) {
      printf("Verified okay, as I expected.\nI'll turn that thing off in a couple.\n");
   }
   else {
      if (rc==0) printf("\nNot verified.  Another Mony task has changed the cursor while I wasn't looking!\n");
   }

   if (rc) {
      printf("\nSomething is terribly wrong!  The world is ending!\n");
      goto DieYoung;
   }

   DosSleep(2000);
   rc = MonySetCursorSize(monyID,0x20,0); // disable that thing

   // do some page flipping if more than 1 page available (/p option in DEVICE=)

   printf("\n");
   if (VBD.pages < 2) {
      printf("To see page flipping, add the /p# (#=1-8) option to the DEVICE= line.\n");
      printf("For now, we'll just have to skip that demonstration.\n");
   }
   else {
      printf("Let's check out the page memory.  The number of pages was shown up top here.\n");
      AskForKey();

      for (page=0; page < VBD.pages; page++) {

         rc = MonySetCursorPos(monyID,page,0,0);        // position to start of page
         rc = MonyWriteCharAttrAtCursor (monyID, page,  // do all pages, 1 at a time
                                         (page + '0'),  // fill screen with page number
                                         7,             // white on black
                                         2000);         // 80x25
         if (rc) break;
      }
      if (rc) {
         printf("Page write failed big-time!\n");
         goto DieYoung;
      }

      printf("That was easy.  Each page is filled with its page number.  Let's\n");
      printf("take a look at them, one after the other (1-second auto-mode).\n");
      AskForKey();

      printf("Page: ");
      for (page=0; page < VBD.pages; page++) {
         printf("%i ",page);
         rc = MonySetVideoPage(monyID,page);
         DosSleep(1000);
         if (rc) break;
      }
      if (rc) {
         printf("\nSet Video Page failed enough to bug out!\n");
         goto DieYoung;
      }

      printf("\n\nToo slow, you say?  Let's do it without waiting.\n");

      AskForKey();

      printf("Page: ");
      for (page=0; page < VBD.pages; page++) {
         printf("%i ",page);
         rc = MonySetVideoPage(monyID,page);      // since VBD.pages is 1-based!
         if (rc) break;                           // and is not a valid page
      }

      printf("\n\nYou probably missed it, but that was all %i pages zooming by.\n\n",VBD.pages);

      printf("How about some scrolling?  Scroll up, down, all around... up and\n");
      printf("down, anyway.  That's followed up with copying the left half of the\n");
      printf("screen over to the right half, via a ReadBlock and WriteBlock.  This\n");
      printf("isn't your father's MDA BIOS!\n");
   }

   AskForKey();

   // let's set everything back to square one by doing a mode set

   rc = MonySetVideoMode(monyID, 7);

   // how to demonstrate this... okay

   for (row=0; row < 25; row++) {
      // you've seen these calls made already, above
      rc = MonySetCursorPos(monyID,0,row,0);
      rc = MonyWriteCharAttrAtCursor(monyID,0,(row + 'A'),7,39);  // only left half-1
   }

   // so rows 0-24 from columns 0 to 38 are filled with letters...

   printf("I'm going to scroll up a block, without backfill, then scroll down\n");
   printf("another area.  A 1/10th-second delay occurs between each 1-line scroll\n");
   printf("up, and about 1/30th-second delay between each scroll down line.\n");
   AskForKey();

   r0 = 2;
   c0 = 3;
   r1 = 20;
   c1 = 16;
   for (i=0; i <= (r1-r0); i++) {
      rc = MonyScrollUp(monyID, 1,7, r0,c0, r1,c1);
      DosSleep(100);
   }

   DosSleep(500);   // digest it, then scroll another area, down this time

   r0 = 2;
   c0 = 20;
   r1 = 20;
   c1 = 33;
   for (i=0; i <= (r1-r0); i++) {
      rc = MonyScrollDown(monyID, 1,7, r0,c0, r1,c1);
      DosSleep(32);
   }

   printf("Now I'm going to copy the left side of the screen to the right.\n");
   AskForKey();

   r0 = 0;
   c0 = 0;
   rows = 25;
   columns = 39;

   bufferPtr = malloc(rows*columns*2);
   if (bufferPtr==NULL) {
      printf("No go on the malloc'o\n");
      rc = 8;
      goto DieYoung;
   }
   rc = MonyReadBlock(monyID, bufferPtr, 0, r0,c0, rows,columns);
   if (rc) {
      printf("Whoa!  MonyReadBlock didn't want to play!  Goodbye sunshine.\n");
      goto DieYoung;
   }

   // copy it to row=0, but column=40 (i.e., copy from the left half to the right)

   c0 = 40;
   rc = MonyWriteBlock(monyID, bufferPtr, 0, r0,c0, rows,columns);
   if (rc) {
      printf("Whoa!  MonyWriteBlock didn't want to play!  Hello moonshine.\n");
      goto DieYoung;
   }

   printf("That was fast!  I just copied (0,0)-(24,38) to (0,40)-(24,78).\n\n");

   printf("That's most of the stuff that Mony does, but not shown were:\n\n");

   printf("Reading page memory; Writing TTY style; sounding/setting the bell,\n");
   printf("and a few others.  Also, not all modes were demonstrated for those\n");
   printf("routines that were shown.  For example, WriteString has several modes\n");
   printf("in how it prints.  The functionality, though, is documented in any BIOS\n");
   printf("book or listing covering INT 10h, or in the included documentation.\n\n");

   printf("Mony is an emulator, true, but it also extends the standard BIOS support\n");
   printf("to include the WriteString(), not found in any MDA BIOS, and the block\n");
   printf("read and write routines, not found in any BIOS.  These, along with the\n");
   printf("multiple video pages, and the speed of an assembly-written OS/2 device\n");
   printf("driver, make for quite a package.\n\n");

   printf("Check it out.  If you like it, order a license and put it to work for you.\n");
   printf("Device driver programmers can stop using DevHelp's Beep and finally get\n");
   printf("real messages!  Application programs can use it for output without having\n");
   printf("to find open desktop space, and using yet another buried window, and boring\n");
   printf("TTY output, if even that.  By the way, did I mention... ");

   // That's the end of the show, folks!

   printf("That's all, folks!\n\n");

   // Say goodbye to Hollywood!

StayPretty:

   printf("Press a key, any key");
   getchar();

   rc = MonySetVideoMode(monyID, 7);    // slippin' into darkness...(before close)

   if (monyID) DosClose(monyID);
   if (bufferPtr) free(bufferPtr);
   return rc;

DieYoung:
   printf(", rc: %x\n",(rc & 255));
   goto StayPretty;

}

// ------------------------------------------
// do the mundane chore of asking for the key

void AskForKey(void) {

   printf("\n    Press a key (control-C to exit) ");
   getchar();
   printf("\n");
   return;
}


