/* code */

/* -------------------------------------------------------------- */
/* Revision History                                               */
/* ++++++++++++++++                                               */
/*                                                                */
/* [001]  10/28/96 by Anand Pandit                                */
/*                 Clear R attribs for deleting the files         */
/*                 (We now have icon for README with read-only    */
/*                 file attrib)                                   */
/*                                                                */
/*                                                                */
/* -------------------------------------------------------------- */



'@echo off'

/**********************************************************/
/*  If 1st parm passed is a ? or not x:                                   */
/*     Print Help                                                           */
/*  Setup deinstall directory (default c:)                                  */
/**********************************************************/

parse arg DeinstDrv

if DeinstDrv \= '' Then Do
   if  DeinstDrv = '?' | Substr(DeinstDrv,2,2) \= ': ' then do
     say
     say " syntax : hddeinst [<drive>]"
     say
     say " where drive -> deinstalation drive where utility is installed"
     say "                Default : c:"
     say
     say " example : hddeinst c:"
     exit
   end
   else DeinstDir = Substr (DeinstDrv,1,1) || ':\HD_MON'
end
else DeinstDir ='C:\HD_MON'

/* Register for OS/2 functions */

call RxfuncAdd 'SysLoadFuncs' , 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Remove the install & de-install folder from the monitor folder */
/* Then remove all the files and the directory */
/* Lastly remove the monitor folder from the desktop */

if SysDestroyObject("<HD_MON_PROG>") = 0  Then do
         Say "Can't Deinstall the install object .  Error...."
	 Say "Manually delete the icon "
end

if SysDestroyObject("<HD_MON_DE_PROG>") = 0 then do
	Say "Can't Deinstall the deinstall object.  Error ...."
	Say "Manually delete the icon "
end

List.0 = DeinstDir || '\HDMON.EXE'
List.1 = DeinstDir || '\HDMON.HLP'
List.2 = DeinstDir || '\HDMON.ICO'
List.3 = DeinstDir || '\README.TXT'
List.4 = DeinstDir || '\HDMON.TXT'
List.5 = DeinstDir || '\HDDEINST.CMD'
List.6 = DeinstDir || '\XHDMON.ICO'
List.7 = DeinstDir || '\ASPIPFA.SYS'

Do i = 0 to 7

/* [001]                      */
/*                            */
/* To reset the R attrib      */

temp1 = ' -r ' List.i
    ATTRIB temp1
    if SysfileDelete(List.i) \= 0 Then
         Say "Can't delete" List.i " ... "
    Else
         Say List.i" deleted successfully..."
End

if SysDestroyObject("<HD_MONITOR>")=0  Then Do
         Say "Can't Deinstall the folder.  Deinstallation failure..."
         Exit
End

'cd' ..
if SysRmDir(DeinstDir) \= 0 Then
         Say "Can't delete Directory ... "


/************************************************************************/
/*        Remove the driver ASPIPFA.SYS from config.sys                 */
/************************************************************************/
say
say "The following line has to be deleted from config.sys  "
say
say "DEVICE = \path\ASPIPFA.SYS  "
say
say "Do you wish me to update your config.sys?  Y (yes) or N (no)  "
say

Do FOREVER

   parse upper pull ConfAns

   if ConfAns = 'Y' | ConfAns = 'N' Then
       Leave

End

if ConfAns = 'N' then do
	say "You need to change your config.sys and reboot for this deinstall to take effect. "
	say "Deinstallation Complete"
	exit
end

say "Config.sys will be updated on drive C:  "
say
say "Press enter to proceed else type the desired drive (x:)  "
say
parse upper pull ConfDrv

if ConfDrv = '' then
    ConfDrv = 'C:'

if SubStr(ConfDrv,2,1) \= ':' then
    ConfDrv = ConfDrv || ':'


infile = ConfDrv'\CONFIG.SYS'
tempfile = SysTempFileName(ConfDrv'\CONFIG.H??')

outfile = tempfile

/*  Parse the line DEVICE = <PATH>\ASPIPFA.SYS and remove it */

do until lines(infile) = 0	
	input = linein(infile)			
	parse upper var input parm '=' rest	
	if parm = "DEVICE" then do
	    if Pos('ASPIPFA.SYS', rest) = 0 then
	        call lineout outfile, input
        end
        else
	    call lineout outfile, input
end

call lineout outfile				/* close input & output files */
call lineout infile
'copy' outfile infile '>NUL'
say "Deinstallation Complete"

call SysfileDelete outfile
exit

