/* SENFORCE.h  GRADD software simulation enforcement filter  r0.0.3  (C header file)
   Copyright 2000-2001 Takayuki 'January June' Suwa / Beliefia Productions. */

#if !defined(__SENFORCE)
#define __SENFORCE

#if defined(__cplusplus)
extern "C" {
#endif

/* SENFORCE filter counters structure */
typedef struct
{
    ULONG aulFiltered[5];
    ULONG ulUnfilteredHardware;
    ULONG ulUnfilteredSimulation;
} SENFORCE_FILTERCOUNTERS, * PSENFORCE_FILTERCOUNTERS;

/* SENFORCE VMI_CMD_EXTENSION/VHI_CMD_EXTENSION subfunctions */
#define XSF_SENFORCE_QUERYENFORCEMENTFILTERFLAGS    ('SENF' + 0)
  /* stored current flags(ULONG) to pOut-pointed location
       bit 0: screen->screen BitBlt operations filter
       bit 1: screen->memory BitBlt operations filter
       bit 2: memory->screen BitBlt operations filter
       bit 3: solid/pattern Fill operations filter
       bit 4: Line operations filter */
#define XSF_SENFORCE_SETENFORCEMENTFILTERFLAGS      ('SENF' + 1)
  /* set pointer to new flags(ULONG), to HWEXTENSION.pXP1 */
#define XSF_SENFORCE_QUERYENFORCEMENTFILTERCOUNTERS ('SENF' + 2)
  /* stored current counters(SENFORCE_FILTERCOUNTERS) to pOut-pointed location */

#if defined(BUILD_GRADD)

/* TRUE if RING0PTR locking is done  */
extern BOOL bRing0Initialized;

/* GRADD ID of SENFORCE */
extern GID gidSelf;

/* previous HWEntry in GRADD chain */
extern PFNHWENTRY PreviousChainedHWEntry;

/* software simulation enforcement filter flags */
extern ULONG ulFilterFlags;

/* GHI commands table */
extern const HWCMD axGHICommandTable[GHI_CMD_MAX];

/* SENFORCE filter counters */
extern SENFORCE_FILTERCOUNTERS xFilterCounters;

/* GHI command entry */
extern ULONG EXPENTRY HWEntry(GID gid,
                              ULONG ulFunction,
                              PVOID pIn,
                              PVOID pOut);

/* GHI command processors */
extern ULONG EXPENTRY HWQueryCaps(PVOID pIn,
                                  PVOID pOut);
extern ULONG EXPENTRY HWQueryModes(PVOID pIn,
                                   PVOID pOut);
extern ULONG EXPENTRY HWExtension(PVOID pIn,
                                  PVOID pOut);

#endif

#if defined(__cplusplus)
}
#endif

#endif

