/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import javax.naming.CompositeName;
import javax.naming.Name;

public class NamingException
extends Exception {
    protected Name resolvedName = null;
    protected Object resolvedObj = null;
    protected Name remainingName = null;
    protected Throwable rootException = null;

    public NamingException() {
    }

    public NamingException(String string) {
        super(string);
    }

    public void appendRemainingComponent(String string) {
        if (string != null) {
            try {
                if (this.remainingName == null) {
                    this.remainingName = new CompositeName();
                    this.remainingName.add(string);
                } else {
                    this.remainingName.add(string);
                }
            }
            catch (NamingException namingException) {
                throw new IllegalArgumentException(namingException.toString());
            }
        }
    }

    public void appendRemainingName(Name name) {
        if (name == null) {
            return;
        }
        if (this.remainingName != null) {
            try {
                this.remainingName.addAll(name);
            }
            catch (NamingException namingException) {
                throw new IllegalArgumentException(namingException.toString());
            }
        } else {
            this.remainingName = (Name)name.clone();
        }
    }

    public String getExplanation() {
        return this.getMessage();
    }

    public Name getRemainingName() {
        return this.remainingName;
    }

    public Name getResolvedName() {
        return this.resolvedName;
    }

    public Object getResolvedObj() {
        return this.resolvedObj;
    }

    public Throwable getRootCause() {
        return this.rootException;
    }

    public void setRemainingName(Name name) {
        this.remainingName = name != null ? (Name)name.clone() : null;
    }

    public void setResolvedName(Name name) {
        this.resolvedName = name != null ? (Name)name.clone() : null;
    }

    public void setResolvedObj(Object object) {
        this.resolvedObj = object;
    }

    public void setRootCause(Throwable throwable) {
        if (throwable != this) {
            this.rootException = throwable;
        }
    }

    public String toString() {
        String string = this.rootException == null || this.rootException == this ? "" : "[Root exception is " + this.rootException.toString() + "]";
        string = this.remainingName != null ? String.valueOf(string) + super.toString() + "; Remaining Name: '" + this.remainingName + "'" : String.valueOf(string) + super.toString();
        return string;
    }

    public String toString(boolean bl) {
        if (!bl || this.resolvedObj == null) {
            return this.toString();
        }
        return String.valueOf(this.toString()) + "; Resolved Object: " + this.resolvedObj;
    }
}

