/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.iiop;

import com.sun.rmi.ClientGIOP;
import com.sun.rmi.ClientRequest;
import com.sun.rmi.EndPoint;
import com.sun.rmi.IOR;
import com.sun.rmi.Profile;
import com.sun.rmi.RequestHandler;
import com.sun.rmi.ServerGIOP;
import com.sun.rmi.corba.ClientDelegate;
import com.sun.rmi.iiop.ClientRequestImpl;
import com.sun.rmi.iiop.Connection;
import com.sun.rmi.iiop.ConnectionTable;
import com.sun.rmi.iiop.EndPointImpl;
import com.sun.rmi.iiop.ListenerThread;
import com.sun.rmi.iiop.ORB;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class GIOPImpl
implements ClientGIOP,
ServerGIOP {
    private int requestId = 5;
    protected ConnectionTable table;
    protected ORB orb;
    private RequestHandler handler;
    protected int listenerPort;
    protected Vector endPoints = new Vector();
    protected ListenerThread listenerThread;
    private EndPoint bootstrapEndpoint;

    protected synchronized int getNextRequestId() {
        return this.requestId++;
    }

    public GIOPImpl(ORB oRB, RequestHandler requestHandler) {
        this.orb = oRB;
        this.table = new ConnectionTable(oRB, this);
        this.setRequestHandler(requestHandler);
    }

    public ConnectionTable getConnectionTable() {
        return this.table;
    }

    public ClientRequest createRequest(IOR iOR, String string, boolean bl, ClientDelegate clientDelegate) {
        Profile profile = iOR.getProfile();
        String string2 = profile.getHost();
        int n = profile.getPort();
        this.table.get(string2, n);
        return this.createRequest(iOR, string, bl, clientDelegate, this.getNextRequestId());
    }

    public ClientRequest createRequest(IOR iOR, String string, boolean bl, ClientDelegate clientDelegate, int n) {
        Profile profile = iOR.getProfile();
        String string2 = profile.getHost();
        int n2 = profile.getPort();
        byte[] byArray = profile.getObjectKey();
        Connection connection = this.table.get(string2, n2);
        return new ClientRequestImpl(byArray, string, bl, clientDelegate.getServiceContexts(connection), n, connection);
    }

    public int allocateRequestId() {
        return this.getNextRequestId();
    }

    public void setRequestHandler(RequestHandler requestHandler) {
        this.handler = requestHandler;
    }

    public RequestHandler getRequestHandler() {
        return this.handler;
    }

    public IOR locate(IOR iOR) {
        Profile profile = iOR.getProfile();
        String string = profile.getHost();
        int n = profile.getPort();
        byte[] byArray = profile.getObjectKey();
        Connection connection = this.table.get(string, n);
        IOR iOR2 = connection.locate(this.getNextRequestId(), byArray);
        if (iOR2 == null) {
            iOR2 = iOR;
        }
        return iOR2;
    }

    public boolean isLocalHost(String string) {
        return string.equals(this.orb.getORBServerHost()) || string.equals(Connection.getLocalHost());
    }

    public synchronized void initEndpoints() {
        if (this.endPoints.size() == 0) {
            this.getEndpoint(123, 0, null);
        }
    }

    public synchronized EndPoint getDefaultEndpoint() {
        if (this.endPoints.size() == 0) {
            return null;
        }
        return (EndPoint)this.endPoints.elementAt(0);
    }

    public synchronized EndPoint getEndpoint(int n, int n2, InetAddress inetAddress) {
        Object object;
        Enumeration enumeration = this.endPoints.elements();
        while (enumeration.hasMoreElements()) {
            object = (EndPoint)enumeration.nextElement();
            if (object.getType() != n || object.getPort() != n2 || object.getInetAddress() != inetAddress) continue;
            return object;
        }
        if (n2 == 0 && this.orb.getORBServerPort() != 0) {
            n2 = this.orb.getORBServerPort();
        }
        this.listenerThread = this.createListener(n2);
        object = this.listenerThread.getSocket();
        this.listenerPort = ((ServerSocket)object).getLocalPort();
        EndPointImpl endPointImpl = new EndPointImpl(n, this.listenerPort, inetAddress, this.orb.getORBServerHost());
        this.endPoints.addElement(endPointImpl);
        return endPointImpl;
    }

    public synchronized EndPoint getBootstrapEndpoint(int n) {
        if (this.bootstrapEndpoint == null) {
            this.bootstrapEndpoint = this.getEndpoint(123, n, null);
        }
        return this.bootstrapEndpoint;
    }

    private synchronized ListenerThread createListener(int n) {
        ListenerThread listenerThread;
        try {
            ServerSocket serverSocket = new ServerSocket(n);
            listenerThread = new ListenerThread(this.table, serverSocket);
            listenerThread.setDaemon(true);
            listenerThread.start();
        }
        catch (Exception exception) {
            throw new INTERNAL(8, CompletionStatus.COMPLETED_NO);
        }
        return listenerThread;
    }
}

