/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.iiop;

import com.sun.rmi.IOR;
import com.sun.rmi.RequestHandler;
import com.sun.rmi.ServerRequest;
import com.sun.rmi.iiop.Connection;
import com.sun.rmi.iiop.IIOPInputStream;
import com.sun.rmi.iiop.IIOPOutputStream;
import com.sun.rmi.iiop.LocateReplyMessage;
import com.sun.rmi.iiop.LocateRequestMessage;
import com.sun.rmi.iiop.Message;
import com.sun.rmi.iiop.ORBThread;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;

public class WorkerThread
extends ORBThread {
    private Connection conn;
    private IIOPInputStream request;
    private IIOPOutputStream response;
    private int msgType;
    private RequestHandler handler;

    public WorkerThread(RequestHandler requestHandler, Connection connection, IIOPInputStream iIOPInputStream) {
        this.conn = connection;
        this.request = iIOPInputStream;
        this.handler = requestHandler;
    }

    public void run() {
        Message message = this.request.getMessage();
        this.conn.requestBegins();
        switch (message.getType()) {
            case 0: {
                ServerRequest serverRequest = (ServerRequest)((Object)this.request);
                try {
                    this.response = (IIOPOutputStream)((Object)this.handler.process(serverRequest));
                    if (!serverRequest.isOneWay()) break;
                    this.conn.requestEnds();
                    Thread.currentThread().stop();
                    break;
                }
                catch (SystemException systemException) {
                    try {
                        this.response = (IIOPOutputStream)((Object)serverRequest.createSystemExceptionResponse(systemException, null));
                        break;
                    }
                    catch (Exception exception) {
                        this.conn.requestEnds();
                        return;
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    UNKNOWN uNKNOWN = new UNKNOWN(4, CompletionStatus.COMPLETED_MAYBE);
                    try {
                        this.response = (IIOPOutputStream)((Object)serverRequest.createSystemExceptionResponse(uNKNOWN, null));
                        break;
                    }
                    catch (Exception exception) {
                        this.conn.requestEnds();
                        return;
                    }
                }
            }
            case 3: {
                LocateReplyMessage locateReplyMessage;
                LocateRequestMessage locateRequestMessage = (LocateRequestMessage)message;
                int n = message.getRequestId();
                IOR iOR = null;
                try {
                    iOR = this.handler.locate(locateRequestMessage.getObjectKey());
                    locateReplyMessage = iOR == null ? new LocateReplyMessage(n, 1) : new LocateReplyMessage(n, 2);
                }
                catch (Exception exception) {
                    locateReplyMessage = new LocateReplyMessage(n, 0);
                }
                this.response = new IIOPOutputStream(this.request.getConnection().getORB(), this.request.getConnection());
                locateReplyMessage.write(this.response);
                this.response.setMessage(locateReplyMessage);
                if (iOR == null) break;
                iOR.write(this.response);
                break;
            }
            case 2: {
                this.conn.requestEnds();
                return;
            }
            default: {
                this.conn.requestEnds();
                return;
            }
        }
        try {
            this.conn.sendReply(this.response);
            this.conn.requestEnds();
            return;
        }
        catch (Exception exception) {
            this.conn.requestEnds();
            return;
        }
    }
}

