/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.TableView;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

class TableView
extends javax.swing.text.TableView {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;

    public TableView(Element element) {
        super(element);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
    }

    protected TableView.TableCell createTableCell(Element element) {
        return new CellView(element);
    }

    protected TableView.TableRow createTableRow(Element element) {
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.TR) {
            return new RowView(element);
        }
        return null;
    }

    public AttributeSet getAttributes() {
        return this.attr;
    }

    public float getMaximumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        super.paint(graphics, rectangle);
    }

    public void setParent(View view) {
        super.setParent(view);
        StyleSheet styleSheet = this.getStyleSheet();
        this.painter = styleSheet.getBoxPainter(this.attr);
        this.setPropertiesFromAttributes();
    }

    protected void setPropertiesFromAttributes() {
        if (this.attr != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
        }
    }

    class RowView
    extends TableView.TableRow {
        private AttributeSet attr;

        public RowView(Element element) {
            super(element);
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
        }

        public AttributeSet getAttributes() {
            return this.attr;
        }

        protected StyleSheet getStyleSheet() {
            HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
            return hTMLDocument.getStyleSheet();
        }
    }

    class CellView
    extends TableView.TableCell {
        private AttributeSet attr;
        private StyleSheet.BoxPainter painter;

        public CellView(Element element) {
            super(element);
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
        }

        protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = super.calculateMajorAxisRequirements(n, sizeRequirements);
            sizeRequirements2.maximum = Integer.MAX_VALUE;
            return sizeRequirements2;
        }

        public AttributeSet getAttributes() {
            return this.attr;
        }

        public int getColumnCount() {
            AttributeSet attributeSet = this.getElement().getAttributes();
            String string = (String)attributeSet.getAttribute(HTML.Attribute.COLSPAN);
            if (string != null) {
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return 1;
                }
            }
            return 1;
        }

        public int getRowCount() {
            AttributeSet attributeSet = this.getElement().getAttributes();
            String string = (String)attributeSet.getAttribute(HTML.Attribute.ROWSPAN);
            if (string != null) {
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return 1;
                }
            }
            return 1;
        }

        protected StyleSheet getStyleSheet() {
            HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
            return hTMLDocument.getStyleSheet();
        }

        protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            super.layoutMajorAxis(n, n2, nArray, nArray2);
            int n3 = 0;
            int n4 = nArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                n3 += nArray2[n5];
                ++n5;
            }
            int n6 = 0;
            if (n3 < n) {
                String string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.VALIGN);
                if (string == null) {
                    AttributeSet attributeSet = this.getElement().getParentElement().getAttributes();
                    string = (String)attributeSet.getAttribute(HTML.Attribute.VALIGN);
                }
                if (string == null || string.equals("middle")) {
                    n6 = (n - n3) / 2;
                } else if (string.equals("bottom")) {
                    n6 = n - n3;
                }
            }
            if (n6 != 0) {
                int n7 = 0;
                while (n7 < n4) {
                    int n8 = n7++;
                    nArray[n8] = nArray[n8] + n6;
                }
            }
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = (Rectangle)shape;
            this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
            super.paint(graphics, rectangle);
        }

        public void setParent(View view) {
            super.setParent(view);
            StyleSheet styleSheet = this.getStyleSheet();
            this.painter = styleSheet.getBoxPainter(this.attr);
            this.setPropertiesFromAttributes();
        }

        protected void setPropertiesFromAttributes() {
            if (this.attr != null) {
                this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
            }
        }
    }
}

