/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.net;

import com.ibm.security12.java.lang.SecurityManager12;
import com.ibm.security12.java.net.NetPermission;
import com.ibm.security12.java.net.PasswordAuthentication;
import java.net.InetAddress;

public abstract class Authenticator {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static Authenticator theAuthenticator;
    private InetAddress requestingSite;
    private int requestingPort;
    private String requestingProtocol;
    private String requestingPrompt;
    private String requestingScheme;

    private void reset() {
        this.requestingSite = null;
        this.requestingPort = -1;
        this.requestingProtocol = null;
        this.requestingPrompt = null;
        this.requestingScheme = null;
    }

    public static synchronized void setDefault(Authenticator authenticator) {
        NetPermission netPermission = new NetPermission("setDefaultAuthenticator");
        SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
        if (securityManager12 != null) {
            securityManager12.checkPermission(netPermission);
        }
        if (theAuthenticator != null) {
            return;
        }
        theAuthenticator = authenticator;
    }

    public static PasswordAuthentication requestPasswordAuthentication(InetAddress inetAddress, int n, String string, String string2, String string3) {
        Authenticator authenticator;
        NetPermission netPermission = new NetPermission("requestPasswordAuthentication");
        SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
        if (securityManager12 != null) {
            securityManager12.checkPermission(netPermission);
        }
        if ((authenticator = theAuthenticator) == null) {
            return null;
        }
        Authenticator authenticator2 = authenticator;
        synchronized (authenticator2) {
            authenticator.reset();
            authenticator.requestingSite = inetAddress;
            authenticator.requestingPort = n;
            authenticator.requestingProtocol = string;
            authenticator.requestingPrompt = string2;
            authenticator.requestingScheme = string3;
            PasswordAuthentication passwordAuthentication = authenticator.getPasswordAuthentication();
            Object var10_10 = null;
            return passwordAuthentication;
        }
    }

    protected final InetAddress getRequestingSite() {
        return this.requestingSite;
    }

    protected final int getRequestingPort() {
        return this.requestingPort;
    }

    protected final String getRequestingProtocol() {
        return this.requestingProtocol;
    }

    protected final String getRequestingPrompt() {
        return this.requestingPrompt;
    }

    protected final String getRequestingScheme() {
        return this.requestingScheme;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return null;
    }
}

