/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.net;

import com.ibm.security12.java.security.cert.Certificate;
import com.ibm.security12.java.util.jar.Attributes;
import com.ibm.security12.java.util.jar.JarEntry;
import com.ibm.security12.java.util.jar.JarFile;
import com.ibm.security12.java.util.jar.Manifest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public abstract class JarURLConnection
extends URLConnection {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private URL jarFileURL;
    private String entryName;
    protected URLConnection jarFileURLConnection;

    protected JarURLConnection(URL uRL) throws MalformedURLException {
        super(uRL);
        this.parseSpecs(uRL);
    }

    private void parseSpecs(URL uRL) throws MalformedURLException {
        String string = uRL.getFile();
        int n = string.indexOf(33);
        if (n == -1) {
            throw new MalformedURLException("no ! found in url spec:" + string);
        }
        this.jarFileURL = new URL(string.substring(0, n++));
        this.entryName = null;
        if (++n != string.length()) {
            this.entryName = string.substring(n, string.length());
        }
    }

    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public abstract JarFile getJarFile() throws IOException;

    public Manifest getManifest() throws IOException {
        return this.getJarFile().getManifest();
    }

    public JarEntry getJarEntry() throws IOException {
        return this.getJarFile().getJarEntry(this.entryName);
    }

    public Attributes getAttributes() throws IOException {
        JarEntry jarEntry = this.getJarEntry();
        if (jarEntry != null) {
            return jarEntry.getAttributes();
        }
        return null;
    }

    public Attributes getMainAttributes() throws IOException {
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            return manifest.getMainAttributes();
        }
        return null;
    }

    public Certificate[] getCertificates() throws IOException {
        JarEntry jarEntry = this.getJarEntry();
        if (jarEntry != null) {
            return jarEntry.getCertificates();
        }
        return null;
    }
}

