/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.net;

import com.ibm.security12.java.io.FilePermission;
import com.ibm.security12.java.lang.ClassLoader12;
import com.ibm.security12.java.lang.Package;
import com.ibm.security12.java.lang.SecurityManager12;
import com.ibm.security12.java.net.FactoryURLClassLoader;
import com.ibm.security12.java.net.SocketPermission;
import com.ibm.security12.java.security.AccessControlContext;
import com.ibm.security12.java.security.AccessController;
import com.ibm.security12.java.security.CodeSource;
import com.ibm.security12.java.security.Permission;
import com.ibm.security12.java.security.PermissionCollection;
import com.ibm.security12.java.security.PrivilegedAction;
import com.ibm.security12.java.security.PrivilegedActionException;
import com.ibm.security12.java.security.PrivilegedExceptionAction;
import com.ibm.security12.java.security.SecureClassLoader;
import com.ibm.security12.java.security.cert.Certificate;
import com.ibm.security12.java.util.jar.Attributes;
import com.ibm.security12.java.util.jar.Manifest;
import com.ibm.security12.sun.misc.Resource;
import com.ibm.security12.sun.misc.URLClassPath;
import com.ibm.security12.sun.net.www.URLConnection12;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;

public class URLClassLoader
extends SecureClassLoader {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private URLClassPath ucp;
    private AccessControlContext acc;

    public URLClassLoader(URL[] uRLArray, ClassLoader12 classLoader12) {
        super(classLoader12);
        SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
        if (securityManager12 != null) {
            securityManager12.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray);
        this.acc = AccessController.getContext();
    }

    public URLClassLoader(URL[] uRLArray) {
        SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
        if (securityManager12 != null) {
            securityManager12.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray);
        this.acc = AccessController.getContext();
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader12 classLoader12, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(classLoader12);
        SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
        if (securityManager12 != null) {
            securityManager12.checkCreateClassLoader();
        }
        this.ucp = new URLClassPath(uRLArray, uRLStreamHandlerFactory);
        this.acc = AccessController.getContext();
    }

    protected void addURL(URL uRL) {
        this.ucp.addURL(uRL);
    }

    public URL[] getURLs() {
        return this.ucp.getURLs();
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new 1(string, this), this.acc);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    private Class defineClass(String string, Resource resource) throws IOException {
        Object object;
        Certificate[] certificateArray;
        Object object2;
        int n = string.lastIndexOf(46);
        URL uRL = resource.getCodeSourceURL();
        if (n != -1) {
            object2 = string.substring(0, n);
            certificateArray = this.getPackage((String)object2);
            object = resource.getManifest();
            if (certificateArray != null) {
                boolean bl;
                if (certificateArray.isSealed()) {
                    bl = certificateArray.isSealed(uRL);
                } else {
                    boolean bl2 = bl = object == null || !this.isSealed((String)object2, (Manifest)object);
                }
                if (!bl) {
                    throw new SecurityException("sealing violation");
                }
            } else if (object != null) {
                this.definePackage((String)object2, (Manifest)object, uRL);
            }
        }
        object2 = resource.getBytes();
        certificateArray = resource.getCertificates();
        object = new CodeSource(uRL, certificateArray);
        return this.defineClass(string, (byte[])object2, 0, ((byte[])object2).length, (CodeSource)object);
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string9)) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    public URL findResource(String string) {
        Resource resource = this.ucp.getResource(string, true);
        if (resource != null) {
            return resource.getURL();
        }
        return null;
    }

    public Enumeration findResources(String string) throws IOException {
        Enumeration enumeration = this.ucp.getResources(string, true);
        return new 2(enumeration);
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Object object;
        Permission permission;
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        try {
            permission = URLConnection12.getPermission(uRL, uRL.openConnection());
        }
        catch (IOException iOException) {
            permission = null;
        }
        if (permission instanceof FilePermission) {
            object = permission.getName();
            if (((String)object).endsWith(File.separator)) {
                object = String.valueOf(object) + "-";
                permission = new FilePermission((String)object, "read");
            }
        } else if (permission == null && uRL.getProtocol().equals("file")) {
            object = uRL.getFile().replace('/', File.separatorChar);
            if (((String)object).endsWith(File.separator)) {
                object = String.valueOf(object) + "-";
            }
            permission = new FilePermission((String)object, "read");
        } else {
            object = uRL.getHost();
            if (object == null) {
                object = "localhost";
            }
            permission = new SocketPermission((String)object, "connect, accept");
        }
        if (permission != null) {
            object = (SecurityManager12)System.getSecurityManager();
            if (object != null) {
                Permission permission2 = permission;
                AccessController.doPrivileged(new 3(permission2, (SecurityManager12)object), this.acc);
            }
            permissionCollection.add(permission);
        }
        return permissionCollection;
    }

    public static URLClassLoader newInstance(URL[] uRLArray, ClassLoader12 classLoader12) {
        AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new 4(classLoader12, uRLArray));
        uRLClassLoader.acc = accessControlContext;
        return uRLClassLoader;
    }

    public static URLClassLoader newInstance(URL[] uRLArray) {
        AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new 5(uRLArray));
        uRLClassLoader.acc = accessControlContext;
        return uRLClassLoader;
    }

    private static final class 1
    implements PrivilegedExceptionAction {
        private final /* synthetic */ URLClassLoader this$0;
        private final /* synthetic */ String val$name;

        public Object run() throws ClassNotFoundException {
            String string = this.val$name.replace('.', '/').concat(".class");
            Resource resource = this.this$0.ucp.getResource(string, false);
            if (resource != null) {
                try {
                    return this.this$0.defineClass(this.val$name, resource);
                }
                catch (IOException iOException) {
                    throw new ClassNotFoundException(this.val$name);
                }
            }
            throw new ClassNotFoundException(this.val$name);
        }

        /* synthetic */ 1(String string, URLClassLoader uRLClassLoader) {
            this.val$name = string;
            this.this$0 = uRLClassLoader;
        }
    }

    private static final class 2
    implements Enumeration {
        private final /* synthetic */ Enumeration val$e;

        public Object nextElement() {
            return ((Resource)this.val$e.nextElement()).getURL();
        }

        public boolean hasMoreElements() {
            return this.val$e.hasMoreElements();
        }

        /* synthetic */ 2(Enumeration enumeration) {
            this.val$e = enumeration;
        }
    }

    private static final class 3
    implements PrivilegedAction {
        private final /* synthetic */ Permission val$fp;
        private final /* synthetic */ SecurityManager12 val$sm;

        public Object run() throws SecurityException {
            this.val$sm.checkPermission(this.val$fp);
            return null;
        }

        /* synthetic */ 3(Permission permission, SecurityManager12 securityManager12) {
            this.val$fp = permission;
            this.val$sm = securityManager12;
        }
    }

    private static final class 4
    implements PrivilegedAction {
        private final /* synthetic */ ClassLoader12 val$parent;
        private final /* synthetic */ URL[] val$urls;

        public Object run() {
            return new FactoryURLClassLoader(this.val$urls, this.val$parent);
        }

        /* synthetic */ 4(ClassLoader12 classLoader12, URL[] uRLArray) {
            this.val$parent = classLoader12;
            this.val$urls = uRLArray;
        }
    }

    private static final class 5
    implements PrivilegedAction {
        private final /* synthetic */ URL[] val$urls;

        public Object run() {
            return new FactoryURLClassLoader(this.val$urls);
        }

        /* synthetic */ 5(URL[] uRLArray) {
            this.val$urls = uRLArray;
        }
    }
}

