/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.security;

import com.ibm.security12.java.security.AccessControlContext;
import com.ibm.security12.java.security.AccessControlException;
import com.ibm.security12.java.security.Permission;
import com.ibm.security12.java.security.PrivilegedAction;
import com.ibm.security12.java.security.PrivilegedActionException;
import com.ibm.security12.java.security.PrivilegedExceptionAction;
import com.ibm.security12.java.security.ThreadProtectionContext;
import com.ibm.security12.java.security.ThreadProtectionNative;
import com.ibm.security12.sun.security.util.Debug;

public final class AccessController {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";

    private AccessController() {
    }

    public static Object doPrivileged(PrivilegedAction privilegedAction) {
        return ThreadProtectionContext.doPrivileged(privilegedAction);
    }

    public static Object doPrivileged(PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        return ThreadProtectionContext.doPrivileged(privilegedAction, accessControlContext);
    }

    public static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return ThreadProtectionContext.doPrivileged(privilegedExceptionAction);
    }

    public static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        return ThreadProtectionContext.doPrivileged(privilegedExceptionAction, accessControlContext);
    }

    private static AccessControlContext getStackAccessControlContext() {
        return ThreadProtectionContext.getStackAccessControlContext();
    }

    static AccessControlContext getInheritedAccessControlContext() {
        try {
            return ThreadProtectionNative.getInheritedAccessControlContext(Thread.currentThread());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return null;
        }
    }

    public static AccessControlContext getContext() {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            return new AccessControlContext(null, true);
        }
        return accessControlContext.optimize();
    }

    public static void checkPermission(Permission permission) throws AccessControlException {
        AccessControlContext accessControlContext = AccessController.getStackAccessControlContext();
        if (accessControlContext == null) {
            Debug debug = AccessControlContext.getDebug();
            if (debug != null) {
                if (Debug.isOn("stack")) {
                    Thread.currentThread();
                    Thread.dumpStack();
                }
                if (Debug.isOn("domain")) {
                    debug.println("domain (context is null)");
                }
                debug.println("access allowed " + permission);
            }
            return;
        }
        AccessControlContext accessControlContext2 = accessControlContext.optimize();
        accessControlContext2.checkPermission(permission);
    }
}

