/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.sun.security.util.BitArray;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import com.ibm.security12.sun.security.x509.CertAttrSet;
import com.ibm.security12.sun.security.x509.Extension;
import com.ibm.security12.sun.security.x509.KeyUsageExtension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;

public class NetscapeCertTypeExtension
extends Extension
implements CertAttrSet {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    public static final String IDENT = "x509.info.extensions.NetscapeCertType";
    public static final String NAME = "NetscapeCertType";
    public static final String SSL_CLIENT = "ssl_client";
    public static final String SSL_SERVER = "ssl_server";
    public static final String S_MIME = "s_mime";
    public static final String OBJECT_SIGNING = "object_signing";
    public static final String SSL_CA = "ssl_ca";
    public static final String S_MIME_CA = "s_mime_ca";
    public static final String OBJECT_SIGNING_CA = "object_signing_ca";
    private static final int[] CertType_data = new int[]{2, 16, 840, 1, 113730, 1, 1};
    public static final ObjectIdentifier NetscapeCertType_Id = new ObjectIdentifier(CertType_data);
    private boolean[] bitString;
    private static MapEntry[] mMapData = new MapEntry[]{new MapEntry("ssl_client", 0), new MapEntry("ssl_server", 1), new MapEntry("s_mime", 2), new MapEntry("object_signing", 3), new MapEntry("ssl_ca", 5), new MapEntry("s_mime_ca", 6), new MapEntry("object_signing_ca", 7)};
    private static final Vector mAttributeNames = new Vector();

    private static int getPosition(String string) throws IOException {
        int n = 0;
        while (n < mMapData.length) {
            if (string.equalsIgnoreCase(NetscapeCertTypeExtension.mMapData[n].mName)) {
                return NetscapeCertTypeExtension.mMapData[n].mPosition;
            }
            ++n;
        }
        throw new IOException("Attribute name [" + string + "] not recognized by CertAttrSet:NetscapeCertType.");
    }

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putUnalignedBitString(new BitArray(this.bitString));
        this.extensionValue = derOutputStream.toByteArray();
    }

    private boolean isSet(int n) {
        return this.bitString[n];
    }

    private void set(int n, boolean bl) {
        if (n >= this.bitString.length) {
            boolean[] blArray = new boolean[n + 1];
            System.arraycopy(this.bitString, 0, blArray, 0, this.bitString.length);
            this.bitString = blArray;
        }
        this.bitString[n] = bl;
    }

    public NetscapeCertTypeExtension(byte[] byArray) throws IOException {
        this.bitString = new BitArray(byArray.length * 8, byArray).toBooleanArray();
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.encodeThis();
    }

    public NetscapeCertTypeExtension(boolean[] blArray) throws IOException {
        this.bitString = blArray;
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.encodeThis();
    }

    public NetscapeCertTypeExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = NetscapeCertType_Id;
        this.critical = bl;
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = Array.getByte(object, n2);
            ++n2;
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        this.bitString = derValue.getUnalignedBitString().toBooleanArray();
    }

    public NetscapeCertTypeExtension() {
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.bitString = new boolean[0];
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Boolean)) {
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean bl = (Boolean)object;
        this.set(NetscapeCertTypeExtension.getPosition(string), bl);
        this.encodeThis();
    }

    public Object get(String string) throws IOException {
        return new Boolean(this.isSet(NetscapeCertTypeExtension.getPosition(string)));
    }

    public void delete(String string) throws IOException {
        this.set(NetscapeCertTypeExtension.getPosition(string), false);
        this.encodeThis();
    }

    public String toString() {
        String string = String.valueOf(super.toString()) + "NetscapeCertType [\n";
        try {
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CLIENT))) {
                string = String.valueOf(string) + "   SSL client\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_SERVER))) {
                string = String.valueOf(string) + "   SSL server\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME))) {
                string = String.valueOf(string) + "   S/MIME\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING))) {
                string = String.valueOf(string) + "   Object Signing\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CA))) {
                string = String.valueOf(string) + "   SSL CA\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME_CA))) {
                string = String.valueOf(string) + "   S/MIME CA\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING_CA))) {
                string = String.valueOf(string) + "   Object Signing CA";
            }
        }
        catch (Exception exception) {}
        string = String.valueOf(string) + "]\n";
        return string;
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = NetscapeCertType_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public Enumeration getElements() {
        return mAttributeNames.elements();
    }

    public String getName() {
        return NAME;
    }

    public boolean[] getKeyUsageMappedBits() {
        KeyUsageExtension keyUsageExtension = new KeyUsageExtension();
        Boolean bl = new Boolean(true);
        try {
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CLIENT)) || this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME)) || this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING))) {
                keyUsageExtension.set("digital_signature", bl);
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_SERVER))) {
                keyUsageExtension.set("key_encipherment", bl);
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CA)) || this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME_CA)) || this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING_CA))) {
                keyUsageExtension.set("key_certsign", bl);
            }
        }
        catch (IOException iOException) {}
        return keyUsageExtension.getBits();
    }

    static {
        int n = 0;
        while (n < mMapData.length) {
            mAttributeNames.addElement(NetscapeCertTypeExtension.mMapData[n].mName);
            ++n;
        }
    }

    private static class MapEntry {
        String mName;
        int mPosition;

        MapEntry(String string, int n) {
            this.mName = string;
            this.mPosition = n;
        }
    }
}

