/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import com.ibm.security12.sun.security.x509.AttributeNameEnumeration;
import com.ibm.security12.sun.security.x509.CertAttrSet;
import com.ibm.security12.sun.security.x509.Extension;
import com.ibm.security12.sun.security.x509.GeneralNames;
import com.ibm.security12.sun.security.x509.GeneralNamesException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

public class SubjectAlternativeNameExtension
extends Extension
implements CertAttrSet {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static final int[] SubjectAlternativeName_data = new int[]{2, 5, 29, 17};
    public static final String IDENT = "x509.info.extensions.SubjectAlternativeName";
    public static final String NAME = "SubjectAlternativeName";
    public static final String SUBJECT_NAME = "subject_name";
    GeneralNames names;

    private void encodeThis() throws IOException {
        if (this.names == null || this.names.isEmpty()) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            this.names.encode(derOutputStream);
        }
        catch (GeneralNamesException generalNamesException) {
            throw new IOException("SubjectAlternativeName: " + generalNamesException);
        }
        this.extensionValue = derOutputStream.toByteArray();
    }

    public SubjectAlternativeNameExtension(GeneralNames generalNames) throws IOException {
        this.names = generalNames;
        this.extensionId = new ObjectIdentifier(SubjectAlternativeName_data);
        this.critical = false;
        this.encodeThis();
    }

    public SubjectAlternativeNameExtension() {
        this.extensionId = new ObjectIdentifier(SubjectAlternativeName_data);
        this.critical = false;
        this.names = new GeneralNames();
    }

    public SubjectAlternativeNameExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = new ObjectIdentifier(SubjectAlternativeName_data);
        this.critical = bl;
        if (!(object instanceof byte[])) {
            throw new IOException("SubjectAlternativeName: Illegal argument type");
        }
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        try {
            this.names = new GeneralNames(derValue);
            return;
        }
        catch (GeneralNamesException generalNamesException) {
            throw new IOException("SubjectAlternativeName: " + generalNamesException);
        }
    }

    public String toString() {
        if (this.names == null) {
            return "";
        }
        String string = String.valueOf(super.toString()) + "SubjectAlternativeName [\n" + this.names.toString() + "]\n";
        return string;
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = new ObjectIdentifier(SubjectAlternativeName_data);
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(SUBJECT_NAME)) {
            if (!(object instanceof GeneralNames)) {
                throw new IOException("Attribute value should be of type GeneralNames.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:SubjectAlternativeName.");
        }
        this.names = (GeneralNames)object;
        this.encodeThis();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(SUBJECT_NAME)) {
            return this.names;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:SubjectAlternativeName.");
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(SUBJECT_NAME)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:SubjectAlternativeName.");
        }
        this.names = null;
        this.encodeThis();
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(SUBJECT_NAME);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }
}

