/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DriverManager {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static Vector drivers = new Vector();
    private static int loginTimeout;
    private static PrintStream logStream;
    private static boolean initialized;

    public static synchronized Connection getConnection(String string, Properties properties) throws SQLException {
        if (string == null) {
            throw new SQLException("The url cannot be null", "08001");
        }
        DriverManager.println("DriverManager.getConnection(\"" + string + "\")");
        if (!initialized) {
            DriverManager.initialize();
        }
        Object object = DriverManager.getSecurityContext();
        SQLException sQLException = null;
        int n = 0;
        while (n < drivers.size()) {
            block9: {
                DriverInfo driverInfo = (DriverInfo)drivers.elementAt(n);
                if (driverInfo.securityContext != null && !driverInfo.securityContext.equals(object)) {
                    DriverManager.println("    skipping: " + driverInfo);
                } else {
                    try {
                        DriverManager.println("    trying " + driverInfo);
                        Connection connection = driverInfo.driver.connect(string, properties);
                        if (connection != null) {
                            DriverManager.println("getConnection returning " + driverInfo);
                            return connection;
                        }
                    }
                    catch (SQLException sQLException2) {
                        if (sQLException != null) break block9;
                        sQLException = sQLException2;
                    }
                }
            }
            ++n;
        }
        if (sQLException != null) {
            DriverManager.println("getConnection failed: " + sQLException);
            throw sQLException;
        }
        DriverManager.println("getConnection: no suitable driver");
        throw new SQLException("No suitable driver", "08001");
    }

    public static synchronized Connection getConnection(String string, String string2, String string3) throws SQLException {
        Properties properties = new Properties();
        if (string2 != null) {
            ((Hashtable)properties).put("user", string2);
        }
        if (string3 != null) {
            ((Hashtable)properties).put("password", string3);
        }
        return DriverManager.getConnection(string, properties);
    }

    public static synchronized Connection getConnection(String string) throws SQLException {
        Properties properties = new Properties();
        return DriverManager.getConnection(string, properties);
    }

    public static Driver getDriver(String string) throws SQLException {
        DriverManager.println("DriverManager.getDriver(\"" + string + "\")");
        if (!initialized) {
            DriverManager.initialize();
        }
        Object object = DriverManager.getSecurityContext();
        int n = 0;
        while (n < drivers.size()) {
            DriverInfo driverInfo = (DriverInfo)drivers.elementAt(n);
            if (driverInfo.securityContext != null && driverInfo.securityContext != object) {
                DriverManager.println("    skipping: " + driverInfo);
            } else {
                try {
                    DriverManager.println("    trying " + driverInfo);
                    if (driverInfo.driver.acceptsURL(string)) {
                        DriverManager.println("getDriver returning " + driverInfo);
                        return driverInfo.driver;
                    }
                }
                catch (SQLException sQLException) {}
            }
            ++n;
        }
        DriverManager.println("getDriver: no suitable driver");
        throw new SQLException("No suitable driver", "08001");
    }

    public static synchronized void registerDriver(Driver driver) throws SQLException {
        if (!initialized) {
            DriverManager.initialize();
        }
        DriverInfo driverInfo = new DriverInfo();
        driverInfo.driver = driver;
        driverInfo.className = driver.getClass().getName();
        driverInfo.securityContext = DriverManager.getSecurityContext();
        drivers.addElement(driverInfo);
        DriverManager.println("registerDriver: " + driverInfo);
    }

    public static void deregisterDriver(Driver driver) throws SQLException {
        Object object = DriverManager.getSecurityContext();
        DriverManager.println("DriverManager.deregisterDriver: " + driver);
        DriverInfo driverInfo = null;
        int n = 0;
        while (n < drivers.size()) {
            driverInfo = (DriverInfo)drivers.elementAt(n);
            if (driverInfo.driver == driver) break;
            ++n;
        }
        if (n >= drivers.size()) {
            DriverManager.println("    couldn't find driver to unload");
            return;
        }
        if (object != null && driverInfo.securityContext != object) {
            throw new SecurityException();
        }
        drivers.removeElementAt(n);
    }

    public static Enumeration getDrivers() {
        Vector<Driver> vector = new Vector<Driver>();
        if (!initialized) {
            DriverManager.initialize();
        }
        Object object = DriverManager.getSecurityContext();
        int n = 0;
        while (n < drivers.size()) {
            DriverInfo driverInfo = (DriverInfo)drivers.elementAt(n);
            if (driverInfo.securityContext != null && driverInfo.securityContext != object) {
                DriverManager.println("    skipping: " + driverInfo);
            } else {
                vector.addElement(driverInfo.driver);
            }
            ++n;
        }
        return vector.elements();
    }

    public static void setLoginTimeout(int n) {
        loginTimeout = n;
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    public static void setLogStream(PrintStream printStream) {
        logStream = printStream;
    }

    public static PrintStream getLogStream() {
        return logStream;
    }

    public static void println(String string) {
        if (logStream != null) {
            logStream.println(string);
        }
    }

    private static Object getSecurityContext() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return null;
        }
        return securityManager.getSecurityContext();
    }

    /*
     * Unable to fully structure code
     */
    private static void loadInitialDrivers() {
        try {
            var0 = System.getProperty("jdbc.drivers");
        }
        catch (Exception v0) {
            var0 = null;
        }
        DriverManager.println("DriverManager.initialize: jdbc.drivers = " + var0);
        if (var0 != null) ** GOTO lbl24
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = var0.indexOf(58);
            if (var1_1 < 0) {
                var2_2 = var0;
                var0 = "";
            } else {
                var2_2 = var0.substring(0, var1_1);
                var0 = var0.substring(var1_1 + 1);
            }
            if (var2_2.length() == 0) continue;
            try {
                DriverManager.println("DriverManager.Initialize: loading " + var2_2);
                Class.forName(var2_2);
                continue;
            }
            catch (Exception var3_3) {
                DriverManager.println("DriverManager.Initialize: load failed: " + var3_3);
            }
lbl24:
            // 4 sources

            ** while (var0.length() != 0)
        }
lbl25:
        // 1 sources

    }

    static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        DriverManager.loadInitialDrivers();
        DriverManager.println("JDBC DriverManager initialized");
    }

    private DriverManager() {
    }

    static {
        logStream = null;
    }
}

