/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.security;

import com.ibm.security12.java.lang.ClassLoader12;
import com.ibm.security12.java.lang.SecurityManager12;
import com.ibm.security12.java.security.Security;
import com.ibm.security12.java.util.Collection;
import com.ibm.security12.java.util.Collections;
import com.ibm.security12.java.util.Iterator;
import com.ibm.security12.java.util.Map;
import com.ibm.security12.java.util.Set;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public abstract class Provider
extends Properties
implements Map {
    private String name;
    private String info;
    private double version;
    static final long serialVersionUID = -4298000515446427739L;

    protected Provider(String string, double d, String string2) {
        this.name = string;
        this.version = d;
        this.info = string2;
    }

    Provider(String string) {
        this(string, 1.0, "no information available");
    }

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public String getInfo() {
        return this.info;
    }

    static Provider loadProvider(String string) {
        try {
            ClassLoader12 classLoader12 = ClassLoader12.getSystemClassLoader();
            Class clazz = classLoader12 != null ? classLoader12.loadClass(string) : Class.forName(string);
            Object t = clazz.newInstance();
            if (t instanceof Provider) {
                return (Provider)t;
            }
            Provider.debug(String.valueOf(string) + " not a provider");
        }
        catch (Exception exception) {
            Provider.debug("error loading provider " + string, exception);
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.name) + " version " + this.version;
    }

    public synchronized void clear() {
        Provider.check("clearProviderProperties." + this.name);
        super.clear();
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        Provider.check("loadProviderProperties." + this.name);
        super.load(inputStream);
    }

    public synchronized void putAll(Map map) {
        Provider.check("putAllProviderProperties." + this.name);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set entrySet() {
        return Collections.unmodifiableMap(this).entrySet();
    }

    public Set keySet() {
        return Collections.unmodifiableMap(this).keySet();
    }

    public Collection values() {
        return Collections.unmodifiableMap(this).values();
    }

    public synchronized Object put(Object object, Object object2) {
        Provider.check("putProviderProperty." + this.name);
        return super.put(object, object2);
    }

    public synchronized Object remove(Object object) {
        Provider.check("removeProviderProperty." + this.name);
        return super.remove(object);
    }

    private static void check(String string) {
        SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
        if (securityManager12 != null) {
            securityManager12.checkSecurityAccess(string);
        }
    }

    private static void debug(String string) {
        Security.debug(string);
    }

    private static void debug(String string, Throwable throwable) {
        Security.debug(string, throwable);
    }

    public abstract boolean containsValue(Object var1);
}

