  ________________________________________________________________________

  Fichier README d'installation du produit IBM OS/2 Warp Developer Kit,
  Edition Java* Technology, version 1.1.8
  ________________________________________________________________________

  IBM OS/2 Warp Developer Kit, Edition Java* Technology, version 1.1.8,
  (Kit de dveloppement) repose sur le niveau de maintenance Java 1.1.8
  de Sun Microsystems.

  Le Kit de dveloppement fournit l'environnement Java de Sun Microsystems
  pour les systmes d'exploitation suivants :

    OS/2 Warp 4 avec FixPak 5 ou version suivante, ou module DBCS
    quivalent
    OS/2 Warp Server avec FixPak 32 ou version suivante, ou
    module DBCS quivalent
    OS/2 Warp Server Advanced avec FixPak 32 ou version
    suivante, ou module DBCS quivalent
    OS/2 Warp Server Advanced avec fonction SMP avec FixPak 32
    ou version suivante, ou module DBCS quivalent
    OS/2 Warp Server for e-business
    Systmes client et serveur WorkSpace On-Demand
    OS/2 Warp 3 avec FixPak 32 ou version suivante, ou module DBCS
    quivalent
    OS/2 Warp Connect avec FixPak 32 ou version suivante, ou
    module DBCS quivalent

    Remarque : Pour plus d'informations sur les modules FixPak DBCS
    quivalents, reportez-vous  la section "Modules FixPak".

  Remarques sur les noms de produit cits dans ce fichier README :
    o  OS/2 Warp 4 dsigne le systme d'exploitation client OS/2 Warp 4
       et le client WorkSpace On-Demand.
    o  OS/2 Warp Server dsigne l'ensemble des systmes d'exploitation
       OS/2 Warp Server et le serveur WorkSpace On-Demand.
    o  OS/2 Warp 3 dsigne OS/2 Warp version 3 et OS/2 Warp Connect.
    o  Java 1.1.x dsigne Java 1.1.1 pour OS/2, Java 1.1.4 pour OS/2
       Warp, IBM OS/2 Warp Developer Kit, Edition Java(*), 1.1.6, IBM
       OS/2 Warp Developer Kit, Edition Java(*), 1.1.7.

  Ce fichier README vous guide pour l'installation du Kit de dveloppement,
  et fournit des informations sur les limites du produit et les moyens de
  les contourner. Les objets Java 1.1.8 dsignent les objets spcifiques
  de ce produit.

  En fonction du fichier excutable utilis, vous pouvez afficher le
  numro de version et de compilation IBM en tapant les commandes
  suivantes sur une ligne de commande :

    o  java -fullversion
       (si vous utilisez le fichier excutable java.exe)
    o  jre -d
       (si vous utilisez le fichier excutable jre.exe)

  ________________________________________________________________________

  SOMMAIRE

     1.0  CONDITIONS PREALABLES
     1.1  Remarques sur les partitions HPFS, JFS et FAT
     1.1.1  Utilisation d'une partition FAT unique
     1.2  Copie du fichier CONFIG.SYS en cours
     1.3  Espace disque
     1.4  Configuration matrielle requise
     1.5  Modules FixPak
     1.6  Installation de modules FixPak aprs le Kit de dveloppement
     1.7  Remplacement des prcdentes versions de Java 1.1.x
     1.8  Cration de copies de sauvegarde des fichiers de base OS/2
     1.9  Mise  jour de Netscape 2.02 et Java 1.1.x
     1.10 Excution de Netscape 4.04 lors de l'installation du Kit de
          dveloppement
     1.11 Netscape Communicator 4.04 et le Compilateur JIT
     1.12 Fichier JIL (Java Integration Layer) pour Netscape
          Communicator 4.04

     2.0  INSTALLATION DU KIT DE DEVELOPPEMENT
     2.1  Installation via l'interface graphique utilisateur (GUI)
     2.1.1  Installation via le Bureau
     2.1.2  Installation via la ligne de commande OS/2
     2.1.3  Slections en gris lors de l'installation
     2.1.4  Reprise aprs l'chec de l'installation
     2.1.4.1  Suppression impossible de l'objet d'installation
     2.2  Installation via la procdure automatique (CID)
     2.2.1   Modification du fichier rponses CID
     2.2.1.1  Composants de configuration
     2.2.1.2  Units d'installation des composants
     2.2.2   Dmarrage de l'installation automatique
     2.3  Installation CID sur architecture TME
     2.4  Installation du Kit de dveloppement sur WorkSpace On-Demand
     2.4.1  Installation du Kit de dveloppement sur un serveur WorkSpace
            On-Demand
     2.4.2  Installation du Kit de dveloppement sur un client WorkSpace
            On-Demand
     2.4.2.1  Configuration requise pour l'installation sur un client
              WorkSpace On-Demand
     2.4.2.2  Modification des fichiers CID.CMD et WSOD.RSP
     2.4.2.3  Plusieurs ditions de Workspace On-Demand sur le mme serveur
     2.4.2.4  Installation de composants supplmentaires du Kit de
               dveloppement sur le client Workspace On-Demand
     2.4.2.5   Le Compilateur JIT et WorkSpace On-Demand
     2.5  Remarques sur l'installation  l'aide de NetView DM/2 (NVDM/2)
     2.5.1  Entre d'une commande statique dans le profil NVDM/2
     2.6  Installation IPL  distance
     2.6.1  Cration des fichiers rponses
     2.6.2  Modification du fichier JAVA118.RSP
     2.6.3  Mise  jour des fichiers pour Feature Install
     2.6.4  Lancement de l'installation IPL  distance
     2.6.5  Lancement du composant Exemples Java  partir d'un client IPL
             distance
     2.6.5.1  Entre d'un mot de passe dans WorkSpace On-Demand
     2.6.6  Passage de Java 1.1.x au Kit de dveloppement dans
            l'environnement IPL  distance

     3.0  APRES L'INSTALLATION
     3.1  Sources d'informations supplmentaires
     3.2  Installation de composants supplmentaires
     3.3  Pont JDBC-ODBC non fourni
     3.4  Remarques sur AWT TextField et TextArea
     3.5  Modification des proprits de la police non prise en charge
     3.6  Problmes relatifs  l'heure dans les appliquettes Java
     3.7  Incidence des modifications de LIBPATH sur le systme
     3.8  Exception de vrification
     3.9  Utilisation de la fonction HMS (High Memory Support) d'OS/2
           pour augmenter la taille de la mmoire dynamique Java
     3.9.1  Activation de la fonction HMS d'OS/2
     3.9.2  Activation de la mmoire dynamique Java pour utiliser HMS d'OS/2
     3.9.3  Limitations lors de l'utilisation de la fonction HMS d'OS/2
     3.10  Classe BigDecimal volue

     4.0  REMARQUES SUR LES JEUX DE CARACTERES SUR DEUX OCTETS
     4.1  Texte des panneaux d'installation manquant ou trop long
          (langues DBCS)
     4.2  Utilisation de PTF pour les polices mises  jour sur les systmes
          corens
     4.3  Installation imprative de polices TrueType sur les systmes chinois
     4.4  Contrle de l'affichage de caractres numriques arabes
     4.5  Installation de FixPak 2 (FX00002) sur la version japonaise d'OS/2
          Warp 4 (sans VoiceType) et sur le Kit de dveloppement
     4.6  Paramtres d'environnement pour la version japonaise d'OS/2 Warp 4
     4.7  Polices requises pour la version japonaise d'OS/2 Warp
     4.8  Modification du fichier CONFIG.SYS pour les langues DBCS
          sous OS/2 Warp 3 Connect

     5.0  LISTE DES MODULES DE BASE OS/2 MIS A JOUR OU AJOUTES PAR LE
          KIT DE DEVELOPPEMENT

     6.0  DESINSTALLATION DU KIT DE DEVELOPPEMENT
     6.1  Dsinstallation via le Bureau
     6.2  Dsinstallation via la ligne de commande OS/2
     6.3  Dsinstallation  partir d'un systme WorkSpace On-Demand
     6.4  Dsinstallation automatique
     6.5  Restauration des fichiers de base OS/2

     7.0  REMARQUES

     8.0  MARQUES




  1.0.  CONDITIONS PREALABLES
  ______________________________________________________________

  Vous pouvez tlcharger les modules d'extension suivants avec le Kit
  de dveloppement :

    o  Composant d'excution Swing, Supported by IBM (Swing Runtime)
    o  Composant de dveloppement Swing, Supported by IBM (Swing Toolkit)
    o  Module de dveloppement RMI-IIOP, Supported by IBM (RMI-IIOP Toolkit)

  Le composant d'excution RMI-IIOP, Supported by IBM (RMI-IIOP Runtime)
  est intgr aux modules d'excution du Kit de dveloppement.

  Pour utiliser tout composant  l'exception de la documentation
  du Toolkit, il est ncessaire d'installer un composant d'excution.
  Vous ne pouvez pas installer le module de dveloppement (Toolkit), les
  Exemples, les composant d'excution et de dveloppement Swing,
  le module de dveloppement RMI-IIOP ou le Dbogueur interactif (ICAT)
  si vous n'installez pas le composant d'excution ou si vous ne l'avez
  pas dj install avant de relancer le systme.

  1.1  Remarques sur les partitions HPFS, JFS et FAT
  ______________________________________________________________________

    Le composant d'excution, le module d'excution Swing et le Dbogueur
    interactif peuvent tre installs sur une partition FAT (File
    Allocation Table ou Table d'allocation des fichiers). Toutefois, il
    est recommand de les installer sur une partition HPFS (High
    Performance File System ou Systme de fichiers haute performance) ou
    JFS (Journaled File System ou Systme de fichiers journalis), qui
    prennent en charge des noms de fichier plus longs et s'avrent plus
    performantes. Le composant de dveloppement (Toolkit), la documentation
    du Toolkit, le composant Exemples, les composants de dveloppement
    Swing et RMI-IIOP doivent tre installs sur une partition HPFS ou
    JFS. Le support d'internationalisation du composant d'excution et la
    police Unicode Times New Roman MT 30 sont installs sur la partition
    d'amorage.

    Si vous utilisez la mthode d'installation simplifie, vous devez
    installer tous les composants sur la mme partition. Si vous souhaitez
    slectionner des units et des rpertoires spcifiques pour les
    diffrents composants, utilisez de prfrence la mthode d'installation
    personnalise.


   1.1.1 Utilisation d'une partition FAT unique
   _____________________________________________________________________

     Si votre disque dur ne possde qu'une partition FAT,
     vous disposez des solutions suivantes :

        o  Ne changez rien  votre systme. Installez uniquement le
           composant d'excution et, accessoirement, le Dbogueur
           interactif et le module d'excution Swing.

        o  Formatez la partition FAT en HPFS ou JFS et rinstallez
           l'ensemble du logiciel.

        o  Procurez-vous un programme de partitionnement de disque, tel que
           PartitionMagic. Si l'espace disque est suffisant, ce type de
           programme rduit la taille de la partition existante (unit C) et
           en cre une autre (unit logique D), qui peut tre formate HPFS.

  Remarque : Dans ce document, le terme "partition" dsigne toute unit
             physique ou logique.


    1.2.  Copie du fichier CONFIG.SYS en cours
    _________________________________________________________________

    Avant d'installer le Kit de dveloppement, faites une copie du
    fichier CONFIG.SYS en cours. Ainsi, vous serez sr de pouvoir
    retrouver votre environnement d'origine en cas de problme pendant
    l'installation.

    1.3.  Espace disque
    __________________________________________________________________

    IBM OS/2 Warp Developer Kit, Edition Java(*), inclut les composants
    suivants :

      Composant d'excution, comprenant le support
      d'internationalisation                               15,0 Mo
      Police Unicode Times New Roman MT 30                 13,0 Mo
      Composant de dveloppement (Toolkit)                  4,0 Mo
      Composant de documentation du Toolkit                 8,0 Mo
      Composant Exemples                                    3,0 Mo
      Dbogueur interactif pour OS/2                       13,0 Mo
      Composant d'excution Swing                           5,0 Mo
      Composant de dveloppement Swing                     35,0 Mo
      Module de dveloppement RMI-IIOP                      2,0 Mo
      ________________________________________________     _______
                                   Espace total requis     98,0 Mo

    Avant de procder  l'installation, vous devez vrifier que l'espace
    disque disponible est suffisant.


    1.4. Configuration matrielle requise
    __________________________________________________________________

    o  Lors de l'excution des applications ou des appliquettes du Kit
       de dveloppement, il est gnralement recommand d'utiliser un
       systme dot de 32 Mo de mmoire vive (RAM).

    o  Il est fortement recommand d'utiliser un processeur Intel(*)
       Pentium(*) (ou quivalent) ou un processeur plus rapide pour tous
       les systmes OS/2.

    o  Le Kit de dveloppement requiert un affichage en mode 256 couleurs
       (ou suprieur). Il ne prend pas en charge les applications et
       appliquettes Java utilisant AWT (Abstract Window Toolkit) en mode
       16 couleurs.

    1.5. Modules FixPak
    _________________________________________________________________

    Les conditions suivantes s'appliquent :

    Pour les langues DBCS (japonais, chinois traditionnel, chinois
    simplifi ou coren), le module FixPak  utiliser est :
     o OS/2 Warp 3      WX03006
       OS/2 Warp 4      FX00505

    Support de la police Unicode sous OS/2 Warp Server et OS/2 Warp 3 :
    o Langues SBCS             FixPak 30 ou version suivante
    o Langues DBCS             FixPak WX03006

    Support du symbole eurodevise (l'euro) dans les applications et
    appliquettes Java :
      o  OS/2 Warp                              FixPak 6 ou version suivante
      o  OS/2 Warp Server ou OS/2 Warp 3        FixPak 35 ou version suivante

  Remarque : L'affichage et la conversion du code de l'euro sont pris en
             charge dans les pages de codes contenant l'euro.

             Vous devez disposer de la version SBCS d'OS/2 pour utiliser
             l'euro. Le clavier U.S. international, UX103, prend en
             charge l'euro, contrairement au clavier anglais standard.
             Dans tous les cas, si vous ne disposez pas d'un clavier
             acceptant le symbole de l'euro, vous pouvez l'afficher
             mais vous ne pouvez pas le saisir.

    Pour plus d'informations sur le tlchargement d'un module FixPak en
    particulier, accdez au site Web IBM FixPak  l'adresse suivante :

      http://ps.software.ibm.com/pbin-usa-ps/getobj.pl?/pdocs-usa
           /otherservices.html

    1.6. Installation de modules FixPak aprs le Kit de dveloppement
    __________________________________________________________________

      o  Installation  partir de disquettes dans d'autres langues :
         Le Kit de dveloppement remplace les modules de base du systme
         d'exploitation lors de l'installation. Lorsque vous installez un
         module FixPak sur OS/2 aprs avoir install le Kit de dveloppement
         et que vous tentez de remplacer un module plus rcent que celui
         du FixPak, le systme vous envoie un message.

         En revanche, si vous installez le module FixPak en amorant le
         systme sur les disquettes FixPak (lorsque cela est possible),
         le systme n'met pas d'avertissement. Un ou plusieurs modules
         peuvent alors tre antrieurs  ceux du FixPak.
         Par consquent, n'installez pas le module FixPak en amorant le
         systme sur les disquettes FixPak ou sauvegardez les modules de
         base d'OS/2 avant d'installer le module FixPak, puis remplacez-les
         ensuite.

      o  Sur OS/2 Warp 4 :
         Si vous souhaitez installer un module FixPak antrieur au module
         FixPak 6, veillez  ce que les fichiers suivants ne soient
         pas modifis avant de procder  l'installation :

           -  CLIFI.EXE
           -  INSTALL.DLL
           -  LIBUNI.DLL
           -  UCONV.DLL

         Pour cela, utilisez SERVICE.EXE pour installer le module
         FixPak, puis choisissez de ne pas mettre  jour les fichiers
         lors de l'installation du module FixPak.

         Si vous utilisez une autre mthode, vous avez le choix entre :

           -  Sauvegarder les fichiers, puis les remplacer aprs
              l'installation du module FixPak.

           -  Rinstaller Feature Install et le Kit de dveloppement aprs
              l'installation du module FixPak.

      o  Sur OS/2 Warp Server ou OS/2 Warp 3 :
         Si vous installez FixPak 30 ou une version suivante (ou
         WX03006 pour les langues DBCS) et que vous dsirez utiliser le
         support de polices Unicode, vous devez rinstaller le composant
         d'excution et la police Unicode Times New Roman MT 30.


    1.7.  Remplacement des prcdentes versions de Java 1.1.x
    _______________________________________________________________

    Le Kit de dveloppement remplace toutes les prcdentes versions de
    Java 1.1.x pour OS/2 Warp. Cependant, il peut coexister avec
    d'anciennes versions si vous installez le programme sur une unit
    diffrente.

    Si vous ne dsinstallez pas la version prcdente, le programme
    d'installation la remplace par le Kit de dveloppement. Si une version
    antrieure d'un composant Java est installe et que vous avez choisi de
    ne pas la rinstaller, le programme d'installation affiche une fentre
    d'avertissement vous signalant que le niveau de cette version
    est antrieur, puis il vous permet de choisir d'installer la version
    la plus rcente.

    1.8.  Cration de copies de sauvegarde des fichiers de base OS/2
    ________________________________________________________________

    Le Kit de dveloppement met  jour les modules de base du systme
    d'exploitation lors de l'installation du composant d'excution. Les
    versions originales de ces fichiers ne sont pas restaures lors de
    la dsinstallation du Kit de dveloppement.

    En rgle gnrale, il n'est pas ncessaire de restaurer les versions
    prcdentes de ces fichiers. Si vous voulez restaurer les fichiers,
    vous devez effectuer des copies de ces fichiers avant de procder 
    l'installation.

    La liste exhaustive des modules nouveaux ou mis  jour figure dans la
    section "Liste des modules de base OS/2 mis  jour ou ajouts par
    le Kit de dveloppement" de ce fichier README.

    1.9.  Mise  jour de Netscape Navigator 2.02 et Java 1.1.x
    ______________________________________________________________

    Si vous disposez de la dernire version de Netscape Navigator 2.02,
    que cette dernire utilise Java 1.1.x et que vous dsinstallez
    Java 1.1.x, Netscape Navigator vous empche d'installer le Kit de
    dveloppement car il recherche la version Java 1.1.x antrieure.

    Vous devez donc supprimer toute rfrence  Java 1.1.x dans le fichier
    CONFIG.SYS, puis relancer le systme.

    1.10.  Excution de Netscape Communicator 4.04 lors de
    l'installation du Kit de dveloppement
    __________________________________________________________________

    Il n'est pas possible d'installer le Kit de dveloppement si Netscape
    Communicator 4.04 est lanc lorsque vous excutez la commande
    INSTALL. Vous devez arrter Netscape Communicator 4.04, puis lancer la
    commande INSTALL.

    1.11   Netscape Communicator 4.04 et le Compilateur JIT
    ______________________________________________________________________

    Pour lancer des appliquettes  l'aide de Netscape Communicator 4.04,
    le compilateur JIT (Just-In-Time) doit tre activ. Si vous voulez
    lancer des appliquettes  l'aide de Netscape Communicator 4.04 sans
    que le compilateur JIT soit activ, vous aurez besoin du niveau le
    plus rcent de Netscape Communicator 4.04. Pour plus d'informations
    sur ce dernier niveau, visitez le site Web suivant :

      http://ps.software.ibm.com

    1.12. Fichier JIL (Java Integration Layer) pour Netscape
    Communicator 4.04
    _________________________________________________________________

    Si vous avez install Netscape Communicator 4.04 aprs le
    Kit de dveloppement, vous devez copier le fichier JIL
    (Java Integration Layer), situ dans le rpertoire \java11 du
    Kit de dveloppement), dans le rpertoire Netscape Communicator 4.04.

      1.  Crez le sous-rpertoire 118 dans le chemin d'accs
          x:\Netscape\program\java\classes.

          x correspondant  l'unit d'installation de Netscape.

     2.  Placez-vous dans le rpertoire d'installation du Kit de
         dveloppement. Copiez le fichier 118.zip, situ dans le
         sous-rpertoire x:\JAVA11\NS, dans le sous-rpertoire
         x:\Netscape\Program\Java\classes.

     3.  Relancez Netscape 4.04.



  2.0  INSTALLATION DU KIT DE DEVELOPPEMENT
  ______________________________________________________________________

  Les sections suivantes contiennent des informations sur l'installation
  du Kit de dveloppement.

    2.1.  Installation via l'interface graphique utilisateur (GUI)
    ______________________________________________________________

    Vous pouvez installer le Kit de dveloppement via le bureau ou la ligne
    de commande OS/2.

      2.1.1.  Installation via le bureau
      __________________________________

      Pour lancer l'installation  l'aide du programme INSTALL.EXE,
      procdez comme suit :

       1. Ouvrez le dossier OS/2.
       2. Ouvrez l'objet Units.
       3. Ouvrez l'unit dans laquelle ont t extraits les fichiers Java.
       4. Ouvrez le dossier dans lequel ont t extraits les fichiers Java.
       5. Cliquez deux fois sur l'objet INSTALL.EXE pour lancer le programme
          d'installation.

      La commande INSTALL.EXE fait apparatre une interface graphique
      comportant onze boutons pour chacune des langues disponibles
      lors de l'installation. Cliquez sur la langue de votre choix ;
      le programme vous guide pour la procdure d'installation.

      Un dossier Kit de dveloppement pour OS/2 est cr dans le
      dossier Programmes sous OS/2 Warp 4 et sur le bureau dans OS/2
      Warp Server et OS/2 Warp 3.

      Si, une fois l'installation effectue, vous souhaitez nettoyer le
      rpertoire dans lequel ont t extraits les fichiers Java, slectionnez
      l'objet DELINST.CMD dans le dossier Kit de dveloppement pour
      supprimer les fichiers et sous-rpertoires Java. Les fichiers et
      sous-rpertoires qui n'ont pas t extraits du Kit de dveloppement ne
      sont pas effacs.

      2.1.2.  Installation via la ligne de commande OS/2
      __________________________________________________

      Pour lancer l'installation, vrifiez que vous vous trouvez dans le
      rpertoire o ont t extraits les fichiers du Kit de dveloppement.
      A l'invite d'une session OS/2, tapez la commande :

        INSTALL

      La commande INSTALL fait apparatre une interface graphique
      comportant onze boutons (un par langue disponible). Cliquez sur
      la langue de votre choix ; le programme vous guide pour la
      procdure d'installation.

      Un dossier Kit de dveloppement pour OS/2 est cr dans le dossier
      Programmes sous OS/2 Warp 4 et sur le bureau dans OS/2 Warp Server
      et OS/2 Warp 3.

      Pour supprimer les fichiers et sous-rpertoires Java
      de leur rpertoire d'extraction  l'issue de l'installation,
      slectionnez l'objet DELINST.CMD dans le dossier Kit de
      dveloppement. Les fichiers et sous-rpertoires qui n'ont pas t
      extraits du Kit de dveloppement ne sont pas effacs.

      2.1.3.  Slections en gris lors de l'installation
      ______________________________________________________________

      Si vous utilisez l'interface graphique pour installer le Kit de
      dveloppement et que des composants apparaissent en gris, il
      est possible que vous n'ayez pas tlcharg et extrait le
      fichier ZIP appropri. Vous devez retourner  la page du
      catalogue Software Choice et tlcharger la version approprie du
      fichier ZIP auto-extractible.

      Vous pouvez consulter le site Web du catalogue Software Choice
       l'adresse :

        http://service.boulder.ibm.com/asd-bin/doc/index.htm


      2.1.4.  Reprise aprs chec de l'installation
_________________________________________________________

      Si l'installation du Kit de dveloppement choue, vous devez vrifier
      qu'il ne reste aucun objet d'installation et, le cas chant, les
      supprimer. Si vous ne les supprimez pas, les prochaines tentatives
      d'installation risquent d'chouer, un message vous signalant qu'un
      ou plusieurs composants n'ont pu tre installs parce que l'objet
      est en criture seule ou en cours d'utilisation par un autre processus.

      L'icne de l'objet d'installation reprsente une bote bleue
      entoure d'un ruban rouge et se trouve sur le Bureau, pour une
      installation CID. Pour une installation manuelle, l'objet se trouve
      dans le dossier x:\os2\install (x reprsentant l'unit d'amorage).
      Pour le supprimer, cliquez sur l'objet avec le bouton droit de la
      souris et slectionnez Suppression dans le menu contextuel.

      Une autre mthode consiste  accder au rpertoire contenant l'objet
      et  supprimer toute l'arborescence. Ce rpertoire se nomme soit
      "Install objet", soit "Java 1.1 for OS!2", selon le stade o
      l'installation a chou.

      Une fois l'objet d'installation supprim, arrtez, puis relancez le
      systme.

      2.1.4.1.  Suppression impossible de l'objet d'installation
      __________________________________________________________________

      Si vous n'avez pas russi  supprimer l'objet d'installation  l'aide
      des instructions de la section "Reprise aprs chec de l'installation",
      effectuez les oprations suivantes :

        1.  Ouvrez une session de ligne de commande 0S/2.
        2.  Placez-vous sur l'unit d'amorage, puis dans le rpertoire
            os2\install.
        3.  Supprimez le rpertoire Java 1.1. for OS!2 et ses
            sous-rpertoires.
        4.  Relancez le systme.


    2.2.  Installation via la procdure automatique (CID)
    _________________________________________________________________

    Remarque : Les installations CID requirent la version 1.2 (ou
               suivante) de Feature Install.

    L'installation automatique ou CID du Kit de dveloppement est prise en
    charge par l'interface CLIFI (interface de lignes de commande de
    Feature Install) et peut durer 15  20 minutes, voire davantage.
    Lorsque la procdure est termine, redmarrez le systme pour
    valider l'installation.

    L'interface CLIFI fait appel  deux fichiers rponses. Le fichier
    JAVA118.RSP est associ au Kit de dveloppement et le fichier
    CID.RSP est un fichier rponses personnalis dans lequel les utilisateurs
    peuvent modifier les slections par dfaut. C'est le seul fichier qui
    doit obligatoirement tre modifi pour des installations automatiques.

      2.2.1. Modification du fichier rponses CID
      _____________________________________________________

      Le fichier rponses CID.RSP contient des variables qui
      vous permettent de slectionner les composants  installer,
      ainsi que l'unit et le rpertoire cible correspondants.

        Les composants sont les suivants :

      Runtime          - Composant d'excution Java
      Unicode          - Support d'internationalisation compris dans
                         l'environnement d'excution
      Unifont          - Police Unicode Times New Roman MT 30
      NSFiles          - Pont Netscape pour excuter les appliquettes du Kit
                         de dveloppement
      TTengine         - Moteur TrueType mis  jour, ncessaire  la
                         police Unicode
      Toolkit          - Composant de dveloppement
      TlktDoc          - Composant de documentation du Toolkit
      Samples          - Composant Exemples
      Debugger         - Dbogueur interactif pour OS/2
      Swing Runtime    - Composant d'excution Swing
      Swing Toolkit    - Composant de dveloppement Swing
      RMI-IIOP Toolkit - Module de dveloppement RMI-IIOP

      Pour installer la documentation du Kit de dveloppement japonais,
      ajoutez le paramtre java11.NLVDest=jp au fichier CID.RSP.

      2.2.1.1 Modules de configuration
      ________________________________________________________________

      Chaque composant disponible est associ  un module de
      configuration. Le fichier rponses CID.RSP permet d'installer
      tous les composants. Modifiez-le pour installer les composants
      dont vous avez besoin, et vrifiez que vous avez tlcharg et
      extrait tous les fichiers correspondants. Dans le fichier CID.RSP,
      dfinissez le paramtre "selection=1" pour chaque composant
       installer, et le paramtre "selection=0" pour chaque
      composant  ne pas installer.

      La variable de slection de la configuration doit correspondre 
      la valeur choisie pour la variable de slection du composant. Par
      exemple, si vous choisissez la variable toolkit.selection=0, vous
      devez galement dfinir la variable toolkitconfig.selection=0.

      2.2.1.2 Units d'installation des composants
      ______________________________________________________________

      Le composant d'excution est toujours install dans le
      rpertoire \JAVA11 de l'unit cible ; c'est un lment
      indispensable au bon fonctionnement du composant de
      dveloppement, du composant Exemples, des modules d'excution
      et de dveloppement Swing, du module de dveloppement RMI-IIOP
      et du Dbogueur.

      Le module de dveloppement RMI-IIOP est install sur l'unit
      slectionne, dans le sous-rpertoire \JAVA11\rmi-iiop.
      Les modules d'excution et de dveloppement Swing sont installs
      sur l'unit choisie, dans le rpertoire \Swing.

      Le support d'internationalisation du composant d'excution,
      ainsi que la police Unicode Times New Roman MT 30 sont
      toujours installs sur l'unit d'amorage. Si la police
      Unicode Times New Roman MT 30 est installe, le composant
      TrueType est indispensable.

      L'unit et le rpertoire cible des autres composants peuvent
      tre indiqus en attribuant les valeurs dsires aux variables
      d'unit et de chemin d'accs. Par exemple, pour installer le
      Dbogueur dans le rpertoire F:\JAVADEBUG, dfinissez les
      variables comme suit :

        debugger.selection=1
        debuggerconfig.selection=1
        debuggerurls.selection=1
        debugger.dbgdrv=F:
        debugger.dbgpath=\javadebug

      S'il existe une ancienne version de Java dans le rpertoire
      mentionn de l'unit cible, le programme d'installation substitue
      la nouvelle  l'ancienne. Si la version prcdente d'un composant
      Java est dj installe et que vous n'avez pas choisi de rinstaller
      le nouveau module, un message s'affiche pour vous signaler que le
      composant correspond  une version antrieure et que vous pouvez le
      mettre  niveau.

      Pour supprimer cette fentre, ou toute autre apparue au cours
      de l'installation, dfinissez la variable comme suit :

        java11.continue=UNATTENDED

      2.2.2. Dmarrage de l'installation automatique
      ______________________________________________

      Le fichier CID.CMD contient un exemple de commande CLIFI pour
      effectuer une installation CID. Le processus d'installation a t
      modifi pour permettre une installation en plusieurs langues ;
      vous devez donc spcifier la variable de langue dans les fichiers
      CID.RSP. Les variables de langue acceptes sont les suivantes :

        br = Portugais (Brsil)
        fr = Franais
        de = Allemand
        it = Italien
        jp = Japonais
        ko = Coren
        cn = Chinois simplifi
        tw = Chinois traditionnel
        es = Espagnol
        sv = Sudois
        en = Anglais

      Cette commande peut galement tre entre en une seule ligne, 
      l'invite d'une session OS/2, comme indiqu ci-dessous :

        clifi /a:c /r2:cid.rsp /r:\xx\java118.rsp /b:c: /s:d:\tmp\xx
        /l1:ciderr.log /l2:cidhist.log

           xx           Indiquant la langue choisie
           /r           Indiquant le chemin d'accs complet au fichier
                        rponses Feature Install
           /b           Indiquant l'unit d'amorage
           /s           Indiquant le chemin d'accs complet aux fichiers
                        du Kit de dveloppement qui ont t extraits
           /l1 et /l2   Indiquant les chemins d'accs complets aux fichiers
                        journaux, le cas chant. En cas de problmes lors de
                        l'installation, reportez-vous  ces fichiers, ainsi
                        qu'au fichier journal de l'unit d'amorage, dont
                        le chemin d'accs est le suivant:
                        \os2\install\wpinstal.log.

    2.3.  Installation CID sur architecture TME
    ____________________________________________________________

    Vous disposez d'un fichier JAVA118.ADF que vous pouvez utiliser avec
    les produits d'installation CID sur architecture TME (Tivoli
    Management Environment), tels que NetFinity Server et l'Agent de
    distribution de logiciels Tivoli TME-10. Pour plus d'informations sur
    l'utilisation des fichiers .ADF, consultez la documentation relative
    au produit d'installation utilis.

    Lors de l'installation CID sur architecture TME, ajoutez la ligne
    suivante au fichier de rponses CID.RSP :

      java11.CID=TME

    La modification du fichier de rponses CID est prsente  la section
    "Modification du fichier rponses CID" de ce fichier README.

    Vous devez galement modifier le fichier JAVADF.CMD pour spcifier la
    variable de langue:

      'clifi /a:c /r:'src'\xx\java118.rsp /r2:'src'\cid.rsp /b:c:
      /s:'src'\xx /l1:'log1' /l2:'log2

      xx correspondant  la variable de langue choisie.

    2.4.  Installation du Kit de dveloppement sur WorkSpace On-Demand
    __________________________________________________________________

    WorkSpace On-Demand comprend Java 1.1.1 pour OS/2 Warp. Vous pouvez
    installer le Kit de dveloppement sur les serveurs et les clients
    WorkSpace On-Demand dj dots de Java 1.1.1 pour OS/2 Warp.

      2.4.1.  Installation du Kit de dveloppement sur un serveur
              WorkSpace On-Demand
      ___________________________________________________________

      Pour installer le Kit de dveloppement sur un serveur WorkSpace
      On-Demand, utilisez l'interface graphique utilisateur. Pour
      connatre les modalits d'utilisation de l'interface graphique,
      reportez-vous  la section "Installation via l'interface graphique
      utilisateur (GUI)".

      2.4.2.  Installation du Kit de dveloppement sur un client WorkSpace
              On-Demand
      ____________________________________________________________________

      Cette opration repose sur une installation automatique (CID). Vous
      pouvez vous reporter aux instructions de la section "Installation via
      la procdure automatique (CID)" de ce fichier README et utiliser les
      fichiers CID.CMD et WSOD.RSP proposs dans le module d'installation du
      Kit de dveloppement. Pour connatre les conditions requises pour
      l'installation, reportez-vous  la section ci-dessous.

        2.4.2.1.  Conditions requises pour l'installation sur un client
                  WorkSpace On-Demand
        _______________________________________________________________

        Pour permettre l'installation du Kit de dveloppement, le client
        WorkSpace On-Demand doit tre dot de Java 1.1.1. Si vous dcidez
        d'installer la police Times New Roman MT 30 (police Unicode),
        celle-ci doit dj figurer sur le systme WorkSpace On-Demand.
        Si ce module n'a pas dj t install, l'installation se droule
        normalement mais les fichiers ne sont pas transfrs. Le fichier
        wpinstal.log indique que l'installation s'est correctement droule
        mais le transfert de fichiers n'a pas t effectu.

        2.4.2.2.  Modification des fichiers CID.CMD et WSOD.RSP
        _____________________________________________________________

        Avant de lancer l'installation, modifiez les fichiers CID.CMD et
        WSOD.RSP comme suit :

          1. Dans le fichier CID.CMD, remplacez /r2:cid.rsp par /r2:wsod.rsp.

          2. Conformment aux instructions de la section "Dmarrage de
             l'installation automatique" de ce fichier README :

             o  Remplacez /s:d:\tmp\xx du fichier CID.CMD par l'unit et le
                rpertoire d'extraction du programme d'installation.

                xx correspondant  la variable de langue choisie.

             o  Assurez-vous que le paramtre /b:c du fichier CID.CMD est
                associ  l'unit d'amorage.

          3. Vrifiez que les slections du fichier WSOD.RSP correspondent
             aux composants  installer. Par dfaut, l'environnement du
             composant d'excution et la police Unicode sont slectionns.
             Tous les autres modules sont dsactivs. Veillez  tlcharger
             et extraire tous les fichiers dont vous avez besoin.

          2.4.2.3.  Plusieurs ditions de Workspace On-Demand sur le
                    mme serveur
          __________________________________________________________

          S'il existe plusieurs ditions de Workspace On-Demand sur un mme
          serveur, vous devez mettre la ligne java11.cid=WSOD en commentaire
          en insrant un caractre # (voir exemple ci-aprs) et ajouter la
          ligne java11.TARGET spcifiant l'image du client WorkSpace
          On-Demand  mettre  niveau.

            #java11.cid=WSOD
            java11.TARGET=x:ibmlan\rp\bb10.en

            x correspondant au chemin d'accs du rpertoire choisi

          2.4.2.4.  Installation de composants supplmentaires du Kit de
                    dveloppement sur le client Workspace On-Demand
          ______________________________________________________________

          Pour installer des composants autres que l'environnement d'excution
          et la police Unicode, vous pouvez slectionner les modules dans le
          fichier WSOD.RSP. Si vous installez le Dbogueur interactif,
          l'administrateur WorkSpace On-Demand doit ajouter les lignes
          suivantes dans le fichier CONFIG.SYS des systmes client :

            - ajoutez Z:\java11\icatjava\dll;  l'instruction LIBPATH
            - ajoutez Z:\java11\icatjava\bin;  l'instruction SET PATH
            - ajoutez Z:\java11\icatjava\help;  l'instruction SET DPATH et
              SET HELP
            - ajoutez Z:\java11\icatjava\daemon\javaprob.zip;  l'instruction
              SET CLASSPATH
            - ajoutez Z:\RUN=Z:\mptn\bin\ifconfig.exe lo 127.0.0.1 up

          Remplacez Z:\java11 par l'unit et le rpertoire
          d'installation cible du Dbogueur.

          2.4.2.5  Le Compilateur JIT et Workspace On-Demand
          __________________________________________________________________

          Sur un systme Workspace On-Demand, la commande suivante
          est ajoute au fichier CONFIG.SYS :

            set java_compiler=xxx

          Cette commande permet de dsactiver le compilateur JIT
          (Just-In-Time). Pour activer le compilateur, supprimez la
          commande du fichier CONFIG.SYS. Pour identifier et modifier le
          fichier CONFIG.SYS, il existe deux options :

          Si vous souhaitez modifier le fichier CONFIG.SYS  partir
          du serveur pour un utilisateur donn, le fichier CONFIG.SYS
          se trouve sur l'unit et dans le rpertoire :

            [unitrpl]:\ibmlan\rpl\machines\[classe_systme]\config.sys

          Si vous souhaitez modifier le fichier CONFIG.SYS par
          dfaut pour chaque systme cr via la classe associe,
          le fichier CONFIG.SYS est disponible sur l'unit et dans le
          rpertoire :

            [unitrpl]:\ibmlan\rpl\machines\BBX0.xx\[nom_systme]\config.sys


            o  [unitrpl] reprsentant la liste des paramtres de requtes
            o  BBXO reprsentant la version de Workspace on-Demand
                 -   BB10 pour Workspace On-Demand, version 1
                 -   BB20 pour Workspace On-Demand, version 2
            o  xx reprsentant le code du pays


    2.5.  Remarques sur l'installation  l'aide de NetView DM/2 (NVDM/2)
    ____________________________________________________________________

    Pour procder  l'installation CID  l'aide de NVDM/2, il est ncessaire
    de crer un profil, puis de crer et de rpertorier un fichier de
    modifications. Le profil NVDM/2 ne vous permet de spcifier qu'un
    fichier rponses, alors que deux sont ncessaires pour l'installation
    automatique du Kit de dveloppement.
    Par ailleurs, dans NVDM/2, le traitement des variables et des arguments est
    diffrent de celui utilis dans Feature Install pour l'installation du
    Kit de dveloppement.

    Pour installer le Kit de dveloppement  l'aide de NVDM/2, utilisez
    l'une des mthodes ci-aprs.

      2.5.1.  Entre d'une commande statique dans le profil NVDM/2
      ____________________________________________________________

      Dans le profil NVDM/2, indiquez toutes les options CLIFI dans la
      variable PARMS. Ces paramtres doivent tenir sur une ligne et tre
      placs entre guillemets :

        Program=c:\os2\install\clifi.exe
        Parms="/a:c /r2:cid.rsp /r:\xx\java118.rsp /b:c: /s:d:\tmp\xx
        /l1:ciderr.log /l2:cidhist.log"

        xx correspondant  la variable de langue choisie.

      Cette mthode requiert la redfinition du profil, quelle que soit la
      date de modification des noms du rpertoire source ou des fichiers
      journaux. Ces valeurs peuvent galement tre remplaces par des valeurs
      de variables dfinissant un poste de travail spcifique, comme indiqu
      ci-dessous :

        Program=c:\os2\install\clifi.exe
        Parms="/a:c /r2:$(ResponseFile) /r:$(SourceDir)\xx\java118.rsp
          /b:c: /s:$(SourceDir\xx) /l1:$(LogFile1) /l2:$(LogFile2)"
        ResponseFile=$(WorkstatName).rsp
          SourceDir=d:\tmp
          LogFile1=$(WorkstatName).log
          LogFile2=$(WorkstatName).lg2

      Pour cette deuxime mthode, il est ncessaire de crer un fichier
      rponses spcifique pour chaque poste de travail, et de dfinir
      correctement la variable WorkstatName.

    2.6.  Installation IPL  distance
    ______________________________________________________________

    L'installation IPL  distance requiert la cration de deux fichiers
    rponses, ainsi que la dfinition des rpertoires et fichiers associs
    sur le serveur.

    Pour chaque client  installer, procdez comme suit :

      1. Placez les fichiers d'installation du Kit de dveloppement extraits
         sur le serveur IPL  distance.
      2. Lancez la commande GENFIRPL. (Pour plus de dtails,
         reportez-vous  la section "Cration des fichiers rponses".)
      3. Excutez la commande CLIFI pour un client IPL  distance.
         (Pour plus de dtails, reportez-vous  la section "Lancement de
         l'installation IPL  distance".)
      4. Modifiez le fichier FIT client (reportez-vous aux sections "Mise 
         jour des fichiers pour Feature Install" et "Lancement du composant
         Exemples Java  partir d'un client IPL  distance").

    Remarque : Vous ne pouvez pas dsinstaller le Kit de dveloppement dans
               l'environnement IPL  distance.

      2.6.1. Cration des fichiers rponses
      _________________________________________________________________

      Aprs avoir plac les fichiers d'installation du Kit de dveloppement sur
      le serveur IPL  distance, utilisez la commande GENFIRPL pour gnrer les
      fichiers rponses : FILES.RSP pour le serveur et JAVA118.RSP pour
      le client. Un exemple est prsent ci-dessous ; la commande
      doit tre entre sur une seule ligne.

        genfirpl /m:c:\javacode\xx  /r:c:\ibmlan\rpl
          /u:c:\ibmlan\rpluser  /f:c:\javacode\xx\java118.rsp
          /c:client_name  /b:x:

           xx   Indiquant la variable de langue choisie
           /m   Indiquant le rpertoire contenant les fichiers d'installation
                du Kit de dveloppement sur le serveur IPL  distance
           /r   Indiquant le rpertoire RPL
           /u   Indiquant le rpertoire RPLUSER
           /f   Indiquant le nom complet du fichier rponse du client IPL 
                distance
           /c   Indiquant le nom du client IPL  distance
           /b   Indiquant l'unit d'amorage du client IPL  distance
           /nf  Supprimant le transfert des fichiers java. Utilisez cet
                indicateur lors de l'installation d'autres clients IPL
                 distance  la suite du premier pour viter d'installer
                les fichiers du Kit de dveloppement pour chaque
                nouveau client

      Le client IPL  distance doit tre arrt lorsque vous lancez la
      commande GENFIRPL. Vous devez entrer cette commande pour chaque client,
      en indiquant le nom et l'unit d'amorage correspondants.

      2.6.2. Modification du fichier JAVA118.RSP
      __________________________________________

      Le fichier JAVA118.RSP est utilis par dfaut pour installer
      tous les composants du Kit de dveloppement. Vous pouvez le
      modifier pour indiquer explicitement les composants que vous
      souhaitez installer. Veillez  tlcharger et extraire tous les
      fichiers dont vous avez besoin avant de commencer l'installation.

      Pour viter d'afficher des lignes tronques, utilisez un diteur de
      texte capable de traiter les lignes de plus de 255 octets, comme
      TEDIT. Compte tenu de la taille du fichier, les modifications peuvent
      prendre beaucoup de temps et gnrer des erreurs. Il est donc
      recommand d'effectuer une copie de sauvegarde de JAVA118.RSP avant
      de modifier le fichier.

      Les composants suivants peuvent tre slectionns :

      Runtime          - Composant d'excution
      Unicode          - Support d'internationalisation intgr 
                         l'environnement d'excution
                         du composant d'excution Java
      Unifont          - Police Unicode Times New Roman MT 30
      NSFiles          - Pont Netscape pour l'excution des appliquettes
                         du Kit de dveloppement
      TTengine         - Moteur TrueType mis  jour, ncessaire pour la
                         police Unicode
      Toolkit          - Composant de dveloppement
      TlktDoc          - Composant de documentation du Toolkit
      Samples          - Composant Exemples
      Debugger         - Dbogueur interactif Java pour OS/2
      Swing Runtime    - Composant d'excution Swing
      Swing Toolkit    - Composant de dveloppement Swing
      RMI-IIOP Toolkit - Module de dveloppement RMI-IIOP

      Utilisez les variables de slection pour choisir les composants 
      installer. Les variables des composants Unifont et TTengine doivent
      tre identiques. Par exemple, pour installer le composant d'excution
      et la police Unicode, dfinissez les variables suivantes dans le
      fichier JAVA118.RSP :

        runtime.selection=1
        runtimeconfig.selection=1
        runtimeurls.selection=1
        Unicode.selection=1
        Unicodeconfig.selection=1
        NSfiles.selection=1
        Jil118.selection=1
        toolkit.selection=0
        toolkitconfig.selection=0
        toolkiturls.selection=0
        tlktdoc.selection=0
        tlktdocconfig.selection=0
        tlktdocurls.selection=0
        samples.selection=0
        samplesconfig.selection=0
        samplesurls.selection=0
        unifont.selection=1
        unifontconfig.selection=1
        TTengine.selection=1
        TTengineconfig.selection=1
        SwingRuntime.selection=0
        SwingRuntimeconfig.selection=0
        SwingToolkit.selection=0
        SwingToolkitconfig.selection=0
        RMIIIOPToolkit.selection=0
        RMIIIOPToolkitconfig.selection=0

      Remarque : Un composant de configuration est associ  chaque
                 module  installer. La variable de slection de la
                 configuration doit correspondre  la valeur choisie
                 pour la variable de slection du composant. Par exemple,
                 si vous choisissez la variable toolkit.selection=0,
                 vous devez galement indiquer la variable
                 toolkitconfig.selection=0.

      2.6.3. Mise  jour des fichiers pour Feature Install
      _______________________________________________________________

      Vous devez modifier le fichier nom_client.FIT de chaque client IPL 
      distance et ajouter, sur une seule ligne, la commande suivante :

        x:\os2\install\install.inv \\nom_serveur\WRKFILES\nom_client
        \os2\install\install.inv

      o les variables nom_serveur et nom_client correspondent au
      nom du serveur et au nom du client IPL  distance.

      2.6.4.  Lancement de l'installation IPL  distance
      ________________________________________________________________

      Les installations IPL  distance sont traites par l'interface
      CLIFI de Feature Install ; la procdure peut prendre 15  20 minutes,
      voire davantage. Une fois connect au serveur IPL  distance en tant
      qu'administrateur, lancez la commande CLIFI  l'aide du fichier
      rponses (FILES.RSP) cr pour le serveur :

        clifi /a:i  /r:c:\javacode\files.rsp

      /r dfinissant le nom complet du fichier rponses pour le serveur
      IPL  distance.

      Il est ncessaire de rinitialiser le serveur IPL  distance aprs
      l'excution de la commande clifi si le transfert de fichiers n'a pas
      t supprim.

      Lancez la commande CLIFI sur chaque client IPL loign aprs
      avoir excut la commande GENFIRPL.

        clifi /a:i  /r:z:\xx\java118.rsp

             xx correspondant  la variable de langue choisie.

             /r correspondant au nom complet du fichier rponses du client
                IPL  distance, comme indiqu dans la commande GENFICMD.

      2.6.5.  Lancement du composant Exemples Java  partir d'un client IPL
               distance
      _____________________________________________________________________

      L'administrateur du serveur IPL  distance doit ajouter les lignes
      suivantes au fichier RPL\FITS\nom_client.FIT pour permettre au client
      d'excuter les lments du composant Exemples.

         x:\JAVA11\WEBLOGS \\nom_serveur\WRKFILES\nom_client\JAVA11\WEBLOGS
         x:\JAVA11\HOTJAVA \\nom_serveur\WRKFILES\nom_client\JAVA11\HOTJAVA

      o les variables nom_serveur et nom_client correspondent au nom du
      serveur et au nom du client IPL  distance.

      Le client IPL  distance peut compiler le code des exemples si ces
      derniers se trouvent dans un rpertoire dans lequel le client peut
      crire.

        2.6.5.1  Entre d'un mot de passe dans WorkSpace On-Demand
        __________________________________________________________

        Si vous entrez un mot de passe pour vous connecter  un serveur Web,
        le fichier IDENTITYDB.OBJ doit tre crit/lu. Pour cela, ajoutez les
        lignes ci-aprs au fichier FIT :

        x:\JAVA11\WEBLOGS \\nom_serveur\WRKFILES\nom_client\JAVA11\WEBLOGS
        x:\JAVA11\HOTJAVA \\nom_serveur\WRKFILES\nom_client\JAVA11\HOTJAVA
        Z:\JAVA11\IDENTITYDB.OBJ  \\serveur\WRKF\client\JAVA11\IDENTITYDB.OBJ

        Ces lignes peuvent galement tre dfinies dans le fichier FIT
        par dfaut pendant l'installation de Java 1.1.x pour WorkSpace
        On-Demand, lors de l'excution de la commande WSOD.CMD.

      2.6.6. Passage de Java 1.1.x au Kit de dveloppement
             dans l'environnement IPL  distance
      ____________________________________________________

      Pour installer le Kit de dveloppement sur Java 1.1.x dans
      l'environnement IPL  distance, procdez comme suit :

        1. Placez les fichiers d'installation du Kit de dveloppement sur le
           serveur IPL  distance.
        2. Lancez la commande GENFIRPL. (Pour plus de dtails, reportez-vous
            la section "Cration des fichiers rponses" de ce fichier README.)
        3. Excutez la commande CLIFI pour un client IPL  distance. (Pour
           plus de dtails, reportez-vous  la section "Lancement de
           l'installation IPL  distance" de ce fichier README.)

      Ce processus met  jour les fichiers Java sur le serveur IPL  distance.
      Dans la mesure o tous les clients IPL ont accs aux mmes fichiers sur
      le serveur, la mise  niveau est effectue pour tous les clients. Les
      informations de configuration du client sont disponibles  partir de
      l'installation de Java 1.1.x.


  3.0.  APRES L'INSTALLATION
  _______________________________________________________________

  Les sections ci-dessous fournissent des informations supplmentaires
  pouvant vous tre utiles aprs l'installation du Kit de dveloppement.

    3.1.  Sources d'informations supplmentaires
    ____________________________________________________________________

    Les objets suivants ne s'affichent dans le dossier OS/2 Kit de
    dveloppement que si vous utilisez OS/2 Warp 4. Si votre systme est OS/2
    Warp Server ou OS/2 Warp 3, vous pouvez accder aux documents associs
    en utilisant les adresses et les chemins suivants :

      o  Centre IBM de technologie Java :
         http://ncc.hursley.ibm.com/javainfo/hurindex.html

      o  Excution de Java :
         x:\JAVA11\runtime.htm

      o  Configuration du Visualiseur d'appliquette :
         x:\JAVA11\cnfgappl.htm

      o  Documentation Java :
         http://www.javasoft.com/doc.html

      o  Composant de dveloppement Java pour OS/2 :
         x:\JAVA11\index.html

      o  Composant de dveloppement Java (Toolkit) :
         x:\JAVA11\toolkit.html

      o  API Java :
         x:\JAVA11\docs\xx\api\API_users_guide.html

      o  Dbogueur interactif pour Java OS/2 :
         x:\JAVA11\ICATJAVA\help\icatjvo.htm

      x reprsentant la partition sur laquelle vous avez install le Kit
      de dveloppement.
      xx reprsente la langue choisie.

    Si vous avez install le composant de dveloppement, la documentation
    du Toolkit ou le Dbogueur interactif Java pour OS/2 dans des rpertoires
    diffrents de celui o se trouve le composant d'excution, prcisez le
    rpertoire de ces quatre objets. Les liens vers la documentation du
    composant d'excution, le Dbogueur interactif Java pour OS/2 et le
    fichier README de la documentation du Toolkit ne fonctionnent pas si
    les composants se trouvent dans des emplacements diffrents.

    3.2.  Installation de composants supplmentaires
    __________________________________________________________________

    Aprs avoir install une premire fois le Kit de dveloppement, vous
    pouvez installer des composants supplmentaires en r-excutant la
    procdure d'installation. Vous devez pour cela conserver tous les
    fichiers extraits sur votre systme, ou conserver les fichiers ZIP
    d'origine, puis en extraire  nouveau les fichiers, si ncessaire.

    3.3.  Pont JDBC (Java Database Connectivity) - ODBC (Open Database
          Connectivity) non fourni
    __________________________________________________________________

    Le Kit de dveloppement fournit JDBC, une interface permettant l'accs
     une large gamme de bases de donnes relationnelles. Toutefois, toutes
    les bases de donnes relationnelles ne sont pas dotes de pilote JDBC.
    Aussi, pour accder aux bases de donnes qui prennent en charge la norme
    ODBC, il faut tablir un pont JDBC-ODBC. Ce pont permet de faire appel
     des pilotes ODBC comme des pilotes JDBC, en utilisant le code natif
    comme interface avec ODBC. Le pont JDBC-ODBC n'est pas fourni avec le
    Kit de dveloppement.

    3.4.  Remarques sur AWT TextField et TextArea
    __________________________________________________________________

    Les commandes AWT TextField et TextArea ne prennent pas en charge les
    caractres qui ne font pas partie de la page de codes en cours. Les
    utilisateurs de systmes en anglais amricain peuvent basculer vers la
    page de codes 850 (page de codes multilingue prenant en charge les langues
    d'Europe occidentale), afin d'intgrer des caractres supplmentaires 
    ces commandes.

    3.5.  Modification des proprits de la police non prise en charge
    __________________________________________________________________

    Il n'est pas possible de modifier les fichiers de proprits de la police
    fournis avec le Kit de dveloppement.

    3.6.  Problmes relatifs  l'heure dans les appliquettes Java
    _____________________________________________________________

    Si l'heure vous pose problme dans les appliquettes Java, il se peut
    que vous deviez dfinir ou modifier la variable de fuseau horaire (TZ).
    Pour dfinir cette variable, procdez comme suit :

      o  Accdez  la page Gnral du bloc-notes de configuration TCP/IP.
         Dfinissez la zone de fuseau horaire en suivant l'aide en ligne
         disponible.

      o  Editez le fichier CONFIG.SYS et ajoutez ou modifiez
         l'instruction SET TZ=.

    3.7.  Incidence des modifications de LIBPATH sur le systme
    ________________________________________________________________

    Lorsque le programme d'installation dtermine que les modules DLL de
    base OS/2  remplacer existent dans un rpertoire autre que x:\OS2\DLL,
    la position de x:\OS2\DLL est modifie dans l'instruction LIBPATH, pour
    garantir que la bonne version des modules est charge.

    Le Kit de dveloppement d'IBM pour OS/2 Warp place des modules DLL
    de base OS/2 dans un rpertoire diffrent. Ce changement n'a pas
    d'incidence sur le composant de dveloppement (Toolkit), mais (en
    fonction du premier module DLL indiqu dans l'instruction LIBPATH),
    il pourrait affecter d'autres produits comprenant des modules DLL de
    base OS/2.

    3.8.  Exception de vrification
    __________________________________________________________________

    Si vous excutez une application et que le message suivant s'affiche :

      java.lang.verifyerror exception

    vous avez le choix entre deux possibilits :

      o  Vous adresser au fournisseur de l'application qui pourra
         peut-tre vous procurer une version mise  jour, fonctionnant
         avec le  Kit de dveloppement (version 1.1.8).
      o  Lancer le Kit de dveloppement avec l'option -noverify soit 
         partir d'une invite de ligne de commande OS/2, soit  partir du
         navigateur.

    3.9 Utilisation de la fonction HMS d'OS/2 pour augmenter la taille
        de la mmoire dynamique Java
     __________________________________________________________________

    Dans un environnement OS/2 standard, l'espace maximal d'adresse
    virtuelle fourni  une application s'lve  512 Mo ; la
    quantit de mmoire dynamique disponible pour Java est limite 
    256 Mo environ. Cette limitation peuvent tre redfinie  l'aide du
    support HMS d'OS/2 (High Memory Support). A l'aide de cette
    fonction, l'espace maximal d'adresse virtuelle fourni  une
    application peut atteindre 3 Go.

    Les plateformes suivantes prennent en charge la fonction HMS d'OS/2 :

      o  OS/2 Warp Server Advanced avec fonction SMP (avec FixPak 32 ou
         version suivante)
      o  Serveurs WorkSpace On-Demand
      o  OS/2 Warp Server for e-business

    Les plateformes suivantes ne prennent pas en charge la fonction HMS
    d'OS/2 :

      o  OS/2 Warp Server
      o  OS/2 Warp Server Advanced
      o  Clients WorkSpace On-Demand
      o  OS/2 Warp 4
      o  OS/2 Warp 3
      o  OS/2 Warp Connect

      3.9.1  Activation de la fonction HMS d'OS/2
      __________________________________________________________________

      La mmoire de la fonction HMS est contrle par le paramtre
      VIRTUALADDRESSLIMIT du fichier CONFIG.SYS. La valeur est dfinie
      en Mo. Par exemple :

        VIRTUALADDRESSLIMIT=2048

     La valeur la plus faible autorise est 512 Mo. Elle permet d'assurer
     la compatibilit avec les anciennes versions d'OS/2 qui donnaient
     accs  512 Mo. Les valeurs suprieures  512 Mo rduisent le
     nombre de processus qui peuvent tre excuts simultanment sur le
     systme.

      3.9.2  Activation de la mmoire dynamique Java pour utiliser la
             fonction HMS d'OS/2
      __________________________________________________________________

      Pour indiquer que la machine virtuelle Java (JVM - Java Virtual
      Machine) doit placer sa mmoire dynamique dans la mmoire HMS
      d'OS/2, dfinissez la variable d'environnement suivante :

        SET JAVA_HIGH_MEMORY=1

      Si la fonction HMS d'OS/2 n'est pas disponible, cette option est
      ignore et la mmoire dynamique est alloue  partir de l'espace
      adresse standard.

      3.9.3  Limitations lors de l'utilisation de la fonction HMS d'OS/2
      __________________________________________________________________

      Si la mmoire dynamique Java est place dans HMS d'OS/2, le
      code 16 bits ne pourra pas accder aux objets allous  partir de
      cette mmoire. Ce problme apparat uniquement si une application
      Java possde des DLL de mthodes natives traites via un
      compilateur 16 bits ou qu'elle appelle d'autres DLL contenant du
      code 16 bits.

      Cette limitation apparat avec les premires versions de TCP/IP
      pour OS/2 (antrieures  la version 4.1). Si vous utilisez la
      mmoire dynamique avec HMS d'OS/2, vous devez installer TCP/IP
      pour OS/2, version 4.1 ou suivante.

    3.10  Classe BigDecimal volue
    ____________________________________________________________________

    Cette version propose une classe BigDecimal volue
    (com.ibm.math.BigDecimal) pour la programmation Java. Cette classe
    (avec la classe MathContext associe) est disponible pour remplacer
    la classe java.math.BigDecimal.

    La nouvelle classe se trouve dans le fichier .jar situ dans le
    rpertoire x:\JAVA11\lib\math.jar (x correspondant  l'unit
    d'installation du Kit de dveloppement). Elle est automatiquement
    ajoute  l'instruction CLASSPATH.

    Si vous utilisez la classe java.math.BigDecimal dans un
    programme Java et que vous souhaitez accder  la nouvelle classe,
    modifiez l'instruction import dans le code source :

      Remplacez   import java.math.*;
      par         import com.ibm.math.*;

    Il est inutile de modifier d'autres parties du code.

    Une documentation sur les interfaces API est disponible dans le
    rpertoire x:\JAVA11\docs\api.bigdecimal. Un petit programme
    d'exemples (decdemo.java) et un fichier README (README.dec) sont
    stocks dans le sous-rpertoire x:\JAVA11\examples\bigdecimal
    (x correspondant  l'unit d'installation du Kit de dveloppement).


  4.0.  REMARQUES SUR LES JEUX DE CARACTERES SUR DEUX OCTETS
  _________________________________________________________________

   Les sections ci-aprs dcrivent les problmes rencontrs avec les
   jeux de caractres sur deux octets (DBCS).

    4.1.  Texte des panneaux d'installation manquant ou trop long
          (langues DBCS)
    _____________________________________________________________

    Lors de l'installation du Kit de dveloppement sur des versions DBCS
    d'OS/2, il est possible que certains caractres DBCS n'apparaissent pas
    dans les panneaux d'installation, ou que certaines lignes soient
    tronques, mme lorsque la fentre est agrandie.

    Pour remdier  ces problmes, quittez le programme d'installation,
    lancez Netscape Navigator ou Netscape Communicator pour OS/2, et
    slectionnez le menu Options. Ouvrez le bloc-notes Prfrences gnrales
    et choisissez l'onglet Polices. Slectionnez le code correspondant 
    votre pays et associez les polices vectorielles et  chasse fixe 
    la valeur MINCHO. Cliquez sur OK pour sauvegarder les modifications.
    Lors de la prochaine installation du Kit de dveloppement, le texte
    s'affichera correctement.

    4.2.  Utilisation de PTF pour les polices mises  jour sur les
          systmes corens
    ______________________________________________________________

    Pour installer le Kit de dveloppement sur un systme OS/2 prenant en
    charge le coren, vous devez au pralable appliquer la PTF PK0817.
    Pour obtenir cette PTF, adressez-vous  votre partenaire OS/2 IBM.

    Sans ce module, les caractres corens risquent de ne pas s'afficher
    correctement sur le systme OS/2 aprs l'installation du Kit de
    dveloppement.

    4.3.  Installation imprative de polices TrueType sur les systmes chinois
    __________________________________________________________________________

    Sur les systmes de chinois simplifi ou de chinois traditionnel,
    assurez-vous que toutes les polices TrueType OS/2 ont t installes.
    Pour les installer, procdez comme suit :

      1. A l'invite de commande OS/2, si C: correspond  l'unit d'amorage,
         lancez le programme d'installation slective en entrant la commande :

           C:\OS2\INSTALL\INSTALL

         Une fentre de configuration du systme apparat  l'cran.

      2. Cliquez sur les boutons Suivant (Warp 4) ou OK (OS/2 Warp
         Server 4.0 ou OS/2 Warp 3) pour accder  la fentre d'installation
         et de configuration d'OS/2.

      3. Dans cette fentre, cochez la case correspondant aux polices TrueType.

      4. Cliquez sur le bouton situ  droite de la case  cocher.

      5. Vrifiez que toutes les cases des polices ont t coches. Cliquez
         sur OK.

      6. Introduisez le CD du systme d'exploitation (OS/2 Warp Server 4.0,
         OS/2 Warp 4.0 ou OS/2 Warp 3) dans l'unit de CD-ROM.

      7. Cliquez sur OK dans la fentre du rpertoire source.

      Les polices slectionnes doivent tre installes. Redmarrez le
      systme  l'issue de la procdure d'installation.

    4.4.  Contrle de l'affichage de caractres numriques arabes
    _____________________________________________________________

    Dans certains pays, il peut arriver que les utilisateurs voient
    s'afficher des caractres numriques arabes. Certaines versions locales
    d'OS/2 font correspondre les caractres x'00B0'  x'00B9' aux
    chiffres arabes 0  9. Pour visualiser les caractres dsirs, modifiez les
    attributs bidirectionnels dans le fichier CONFIG.SYS ou utilisez la
    page Langue du bloc-notes Proprits (bloc-notes Paramtres dans
    OS/2 Warp Server ou OS/2 Warp 3) de l'objet.

    4.5. Installation de FixPak 2 (FX00002) sur la version japonaise
         d'OS/2 Warp 4 (sans VoiceType) et sur le Kit de dveloppement
    __________________________________________________________________

    Si vous avez l'intention d'installer FixPak 2 (FX00002) sur la
    version japonaise d'OS/2 Warp 4 (sans VoiceType), vous devez le
    faire avant d'installer le Kit de dveloppement. Dans le cas
    contraire, OS/2 risque de ne pas redmarrer. Cependant, si vous
    devez installer le module FixPak 2 sur la version japonaise d'OS/2
    Warp 4 (sans VoiceType), effectuez les oprations suivantes 
    l'issue de l'installation du Kit de dveloppement.

    Avant d'appliquer le module FixPaK 2, effectuez une copie de
    sauvegarde des fichiers ci-dessus et placez-les dans un autre
    rpertoire.

           \os2\dll\INSTALL.DLL
           \os2\dll\UCONV.DLL
           \os2\dll\TRUETYPE.DLL

    Une fois le FixPak appliqu, restaurez-les. Pour ce faire, procdez
    comme suit :

      1. Relancez le systme.
      2. Lorsque le pav blanc jouxtant "OS/2" apparat dans l'angle
         suprieur gauche de l'cran, appuyez sur Alt+F1.
      3. Dans la slection des menus, appuyez sur F2.
      4. Avant d'installer le Kit de dveloppement, remplacez les
         fichiers par ceux qui ont t sauvegards (liste ci-dessus).
         A l'invite d'une session OS/2, copiez  nouveau ces fichiers
         dans le rpertoire \os2\dll.
      5. A l'invite d'une ligne de commande OS/, tapez

           EXIT

        et appuyez sur Entre. Le systme redmarre.

     Remarque : La version japonaise d'OS/2 Warp 4 (avec VoiceType) comprend
                le module FixPak 2 (FX00002).

    4.6. Paramtres d'environnement pour la version japonaise d'OS/2 Warp 4
    _______________________________________________________________________

    Utilisez les paramtres d'environnement ci-aprs pour la version
    japonaise d'OS/2 Warp 4.

      o  Page de codes : 932
      o  Code ShiftJIS : New JIS

    4.7. Polices requises pour la version japonaise d'OS/2 Warp
    _____________________________________________________________

    Pour lancer le Kit de dveloppement, le systme doit tre quip
    des polices suivantes :

      Nom           Style
      -----------------------------------------
      GOTHIC        Normal
      GOTHIC        HeiseiKakuGothic-W5-H-90-TT
      MINCHO        HeiseiMincho-W3-H-90-TT

    Vous pouvez les slectionner dans la section Polices du dossier
    Configuration du systme dans le dossier OS/2.

    La police GOTHIC Normal est incluse dans la police systme japonaise
    GOTHIC.

    La police HeiseiKakuGothic-W5-H-90-TT correspond  la police
    HeiseiKakuGothic TrueType d'IBM avec l'ordre NEW JIS.

    La police MINCHO HeiseiMincho-W3-H-90-TT correspond  la police
    HeiseMincho TrueType d'IBM avec l'ordre New JIS.

    Ces polices peuvent tre installes  l'aide du programme Installation
    slective, disponible dans :

      o  le dossier Installation/Retrait du dossier Configuration du
         systme sur les postes OS/2 Warp 4,

      o  le dossier Configuration du systme sur les systmes OS/2 Warp
         Server et OS/2 Warp 3.

    4.8. Modification du fichier CONFIG.SYS pour les langues DBCS sous
         OS/2 Warp 3 Connect
    _________________________________________________________________

    Vrifiez que la variable de langue est dfinie comme indiqu
    ci-dessous. Dans le cas contraire, modifiez-la.

      Chinois :      SET LANG=zh_CN
      Japonais :     SET LANG=ja_JP
      Coren :       SET LANG=ko_KR
      Tawanais :    SET LANG=zh_TW

    Si cette variable n'est pas dfinie correctement, le Kit de
    dveloppement ne parviendra pas  trouver la variable locale
    approprie.


  5.0 LISTE DES MODULES DE BASE OS/2 MIS A JOUR OU AJOUTES PAR LE KIT DE
      DEVELOPPEMENT
  ______________________________________________________________________

  Lorsque vous installez le Kit de dveloppement sur votre systme, les
  fichiers de base OS/2 numrs ci-dessous sont mis  jour ou ajouts,
  s'ils n'existent pas encore :

        \os2\dll\libaux.dll
        \os2\dll\libcm.dll
        \os2\dll\libcn.dll
        \os2\dll\libcs.dll
        \os2\dll\libtk.dll
        \os2\dll\libuni.dll
        \os2\dll\locale.dll
        \os2\dll\uconv.dll
        \language\codepage\ibm437
        \language\codepage\ibm813
        \language\codepage\ibm819
        \language\codepage\ibm850
        \language\codepage\ibm852
        \language\codepage\ibm855
        \language\codepage\ibm857
        \language\codepage\ibm860
        \language\codepage\ibm861
        \language\codepage\ibm862
        \language\codepage\ibm863
        \language\codepage\ibm864
        \language\codepage\ibm865
        \language\codepage\ibm866
        \language\codepage\ibm869
        \language\codepage\ibm874
        \language\codepage\ibm878
        \language\codepage\ibm912
        \language\codepage\ibm913
        \language\codepage\ibm914
        \language\codepage\ibm915
        \language\codepage\ibm916
        \language\codepage\ibm920
        \language\codepage\ibm921
        \language\codepage\ibm922
        \language\codepage\ibm942
        \language\codepage\ibm943
        \language\codepage\ibm949
        \language\codepage\ibm950
        \language\codepage\ibm1004
        \language\codepage\ibm1089
        \language\codepage\ibm1200
        \language\codepage\ibm1207
        \language\codepage\ibm1208
        \language\codepage\ibm1250
        \language\codepage\ibm1251
        \language\codepage\ibm1252
        \language\codepage\ibm1253
        \language\codepage\ibm1254
        \language\codepage\ibm1255
        \language\codepage\ibm1256
        \language\codepage\ibm1257
        \language\codepage\ibm1275
        \language\codepage\ibm1280
        \language\codepage\ibm1281
        \language\codepage\ibm1282
        \language\codepage\ibm1283
        \language\codepage\ibm1381
        \language\codepage\ibm1386
        \language\codepage\os2ugl
        \language\codepage\ucstbl.lst

  Le fichier suivant est remplac sous OS/2 Warp 4, OS/2 Warp Server ou
  OS/2 Warp 3 au niveau FixPak 30 ou version suivante pour les
  langues SBCS, et au niveau FixPak WX03006 ou  un niveau suprieur
  pour les langues DBCS :

        \os2\dll\truetype.dll

  Le fichier suivant contient la police Unicode Times New Roman MT 30
  TrueType de Monotype Corporation. Si vous avez dj install une police
  avec le mme nom de fichier, celui-ci le remplace :

        \os2\dll\tnrmt30.ttf


  6.0. DESINSTALLATION DU KIT DE DEVELOPPEMENT
  ______________________________________________________________________

  Vous pouvez dsinstaller le Kit de dveloppement  l'aide des mthodes
  suivantes :

    6.1.  Dsinstallation via le Bureau
    ___________________________________

    Pour effectuer une dsinstallation  l'aide de l'objet Suppression
    du Kit de dveloppement, procdez comme suit :

      1. Ouvrez le dossier OS/2.
      2. Ouvrez le dossier Configuration du systme.
      3. Ouvrez le dossier Installation/Retrait (pour OS/2 Warp 4 uniquement).
      4. Ouvrez le dossier Retrait des fonctions.
      5. Slectionnez l'objet Suppression du Kit de dveloppement pour OS/2
         pour lancer le programme de dsinstallation.

    Pour restaurer les fichiers de base OS/2 sauvegards avant l'installation
    du Kit de dveloppement, suivez les instructions de la section
    "Restauration des fichiers de base OS/2" de ce fichier README.

    6.2.  Dsinstallation via la ligne de commande OS/2
    ___________________________________________________

    Pour lancer la dsinstallation, vrifiez que vous vous trouvez soit
    dans le rpertoire o ont t extraits les fichiers du Kit de
    dveloppement, soit dans le rpertoire \JAVA11\UNINSTAL. A l'invite
    d'une session OS/2, entrez :

      UNINSTAL

    Le programme vous indique la procdure  suivre pour la dsinstallation.
    Seuls les fichiers et rpertoires crs pendant le processus
    d'installation sont supprims. Par exemple, le rpertoire HOTJAVA cr
    pendant l'excution du Visualiseur d'appliquette n'est pas retir lors
    de la dsinstallation.

    Pour restaurer les fichiers de base OS/2 qui ont t sauvegards avant
    l'installation du Kit de dveloppement, reportez-vous  la section
    "Restauration des fichiers de base OS/2" de ce fichier README.

    6.3. Dsinstallation  partir d'un systme WorkSpace On-Demand
    ______________________________________________________________

    Le support de dsinstallation du Kit de dveloppement requiert l'accs
     un objet d'inventaire (Java 1.1.8) dans le rpertoire Installed
    Features (os2\install\installed features). Si vous installez le Kit de
    dveloppement  la fois sur le client et le serveur WorkSpace
    On-Demand, l'objet d'inventaire Java 1.1.8 est altr ou remplac.

    Pour supprimer le Kit de dveloppement Kit du systme client, rinstallez
    la version WorkSpace On-Demand de Java 1.1.x. Cette version remplacera
    le Kit de dveloppement.

    Pour dsinstaller le Kit de dveloppement sur le serveur, supprimez la
    structure de rpertoires \Java11. Vous pouvez la supprimer  partir
    du dossier Units dans le dossier systme OS/2. En outre, si
    vous avez install la police Unicode, vous devez supprimer le
    fichier \OS2\dll\tnrmt30.TTF sur l'unit d'amorage.

    6.4. Dsinstallation automatique
    ________________________________

    Pour dsinstaller le Kit de dveloppement, entrez la commande suivante
    sur une ligne,  l'invite d'une session OS/2 :

      clifi /a:u /f:"<WP_INSTALLED>" /o:INV_JAVA11 /set:Selection=ALL

    6.5.  Restauration des fichiers de base OS/2
    ______________________________________________________________________

    Dans la plupart des cas, les fichiers de base OS/2 remplacs lors de
    l'installation du Kit de dveloppement peuvent encore tre utiliss
    aprs la dsinstallation de ce Kit. Si vous avez effectu des copies
    des fichiers originaux, comme indiqu dans la section "Coexistence avec
    les prcdentes versions de Java" de ce fichier README, vous pouvez
    dcider de les restaurer (facultatif).

    Au cours du fonctionnement normal du systme, certains des fichiers
    ayant une copie de sauvegarde sont verrouills et ne peuvent tre
    crass par la copie de sauvegarde. Pour les remplacer, procdez comme
    suit :

      1. Redmarrez l'ordinateur.
      2. Lorsque le pav blanc et le nom OS/2 apparaissent dans l'angle
         suprieur gauche de l'cran, appuyez sur Alt-F1.
      3. Slectionnez l'option de lancement d'une ligne de commande OS/2.
      4. Restaurez les fichiers en utilisant ceux qui ont t sauvegards
         avant l'installation du Kit de dveloppement. A l'invite d'une
         session OS/2, copiez  nouveau les fichiers dans le
         sous-rpertoire \OS2\dll
      5. A l'invite d'une session OS/2, tapez :

           EXIT

           et appuyez sur Entre. Le systme redmarre.

    Remarque : Si vous aviez install le Kit de dveloppement sur Java
               1.1.x et que vous dsinstallez par la suite le Kit de
               dveloppement, le fichier CONFIG.SYS revient au niveau
               de Java 1.1.x.

           Si vous installez le composant Toolkit du Kit de dveloppement
           et que vous le dsinstallez par la suite, il se peut que les
           instructions SET LIB= et SET INCLUDE= du fichier CONFIG.SYS
           utilisent encore le rpertoire dans lequel le Toolkit avait
           t install.

7.0  REMARQUES
___________________________________________________________________

Le prsent document peut contenir des informations ou des rfrences
concernant certains produits, logiciels ou services IBM non annoncs
dans ce pays. Cela ne signifie pas qu'IBM ait l'intention de les y
annoncer. Pour plus de dtails, rfrez-vous aux documents d'annonce
disponibles dans votre pays, ou adressez-vous  votre partenaire
commercial IBM.

Toute rfrence  un produit, logiciel ou service IBM n'implique pas
que seul ce produit, logiciel ou service, puisse tre utilis. Tout
autre lment fonctionnellement quivalent peut tre utilis, s'il
n'enfreint aucun droit d'IBM.

Il est de la responsabilit de l'utilisateur d'valuer et de vrifier
lui-mme les installations et applications ralises avec des produits,
logiciels ou services, non expressment rfrencs par IBM.

Le prsent document peut contenir des exemples de donnes et de rapports
utiliss couramment dans l'environnement professionnel. Ces exemples
mentionnent des noms fictifs de personnes, de socits, de marques ou de
produits  des fins illustratives ou explicatives uniquement. Toute
ressemblance avec des noms de personnes, de socits ou des donnes
relles serait purement fortuite.

Le prsent document peut galement contenir des programmes rduits
fournis par IBM  titre de simple exemple et d'illustration. Ces
programmes n'ont pas t rigoureusement tests dans toutes les
conditions. Par consquent, IBM ne peut garantir expressment ou
implicitement la fiabilit, la maintenabilit ou le fonctionnement
de ces programmes. LES GARANTIES IMPLICITES DE QUALITE MARCHANDE OU
D'ADAPTATION A VOS BESOINS SONT EXPRESSEMENT EXCLUES.

IBM peut dtenir des brevets ou des demandes de brevets couvrant les
produits mentionns dans le prsent document.

La remise de ce document ne vous donne aucun droit de licence sur ces
brevets ou demandes de brevets. Si vous dsirez recevoir des
informations concernant l'acquisition de licences, veuillez en faire la
demande par crit  l'adresse suivante :

          IBM EMEA Director of Licensing
          IBM Europe Middle-East Africa
          Tour Descartes
          La Dfense 5
          2, avenue Gambetta
          92066 - Paris-La Dfense CEDEX
          France

Les licencis souhaitant obtenir des informations permettant :
(i) l'change des donnes entre des logiciels crs de faon
indpendante et d'autres logiciels (dont celui-ci), et (ii)
l'utilisation mutuelle des donnes ainsi changes, doivent adresser
leur demande  :

    JTCMAIL@uk.ibm.com
    [Centre de Technologie Java (JTC)  Hursley]

Ces informations peuvent tre soumises  des conditions particulires,
prvoyant notamment le paiement d'une redevance.

Pour le Canada, veuillez adresser votre courrier  :

          IBM Director of Commercial Relations
          IBM Canada Ltd.
          3600 Steeles Avenue East
          Markham, Ontario
          L3R 9Z7
          Canada



  8.0 MARQUES
  ___________

  Les termes qui suivent sont des marques d'International Business
  Machines Corporation dans certains pays :

      IBM
      OS/2

  Java est une marque de Sun Microsystems Inc. dans
  certains pays. La technologie Java est la proprit de Sun
  Microsystems Inc., qui seule peut en concder la licence.

  Netscape et Netscape Navigator sont des marques de Netscape
  Communications Corporation.

  Intel et Pentium sont des marques d'Intel Corporation dans certains pays.

  Tivoli est une marque de Tivoli Systems Inc. dans certains pays.

  D'autres socits sont propritaires des autres marques, noms de
  produits ou logos qui pourraient apparatre dans ce document.

  (c) Copyright IBM Corporation 1999, All rights reserved.
  (C) Copyright IBM France 1999. Tous droits rservs.

  ________________________________________________________________________

  FIN-DE-FICHIER-README
  ________________________________________________________________________
