/* rexx */

/* Load external FI API
*/

call RxFuncAdd 'RexxInstSetVariable', 'WPINSTAL', 'RexxInstSetVariable'
call RxFuncAdd 'RexxInstResolveVariables', 'WPINSTAL', 'RexxInstResolveVariables'
call RxFuncAdd 'RexxInstDeselect', 'WPINSTAL', 'RexxInstDeselect'
call RxFuncAdd 'RexxInstSelect', 'WPINSTAL', 'RexxInstSelect'

/* Get the objectid (feature handle), and the current package from the arguments
*/
parse arg objectid userexitpath

package=userexitpath"\.."

/* Variables for Java Version
*/
ver=11
modify=8
bootdrive = RexxInstResolveVariables(objectid,"{BootDrive}",0)
ReadSysLevel(bootdrive"\os2\install\syslevel.os2")
if st.bSysVersion < 4 then warp=3
else warp=4
call RexxInstSetVariable objectid,"Java11","Warp",warp

/* Determine if we will check the runtime checkbox and feature
*/
RTChecked = 0

/* Check for a syslevel file and the correct version
*/

if ReadSysLevel(package"\syslevel.jav")  then do
   if st.bSysVersion = ver & st.bSysModify = modify then do
      call RexxInstSetVariable objectid,"Runtime" ,"CheckableRT","1"
      call RexxInstSelect objectid,"Runtime"
      call RexxInstSelect objectid,"RuntimeConfig"
      call RexxInstSelect objectid,"Unicode"
      call RexxInstSelect objectid,"UnicodeConfig"
      call RexxInstSelect objectid,"NSFiles"
        call RexxInstSelect objectid,"JIL118"

      call RexxInstSetVariable objectid,"Runtime.Visible" ,"CheckableRT","1"
      call RexxInstSelect objectid,"Runtime.Visible"
      RTChecked = 1
      if warp=4 then do
        call RexxInstSelect objectid,"RuntimeUrls"
      end
      else do
        call RexxInstDeSelect objectid,"RuntimeUrls"
      end

   end
   else do
      call RexxInstSetVariable objectid,"Runtime" ,"CheckableRT","0"
      call RexxInstDeSelect objectid,"Runtime"
      call RexxInstDeSelect objectid,"RuntimeConfig"
      call RexxInstDeSelect objectid,"Unicode"
      call RexxInstDeSelect objectid,"UnicodeConfig"
      call RexxInstDeSelect objectid,"NSFiles"
        call RexxInstDeSelect objectid,"JIL118"

      call RexxInstSetVariable objectid,"Runtime.Visible" ,"CheckableRT","0"
      call RexxInstDeSelect objectid,"Runtime.Visible"
      call RexxInstDeSelect objectid,"RuntimeUrls"
   end
end
else do
   call RexxInstSetVariable objectid,"Runtime" ,"CheckableRT","0"
   call RexxInstDeSelect    objectid,"Runtime"
   call RexxInstDeSelect    objectid,"RuntimeConfig"
   call RexxInstDeSelect    objectid,"Unicode"
   call RexxInstDeSelect    objectid,"UnicodeConfig"
   call RexxInstDeSelect    objectid,"NSFiles"
   call RexxInstDeSelect    objectid,"JIL118"

   call RexxInstSetVariable objectid,"Runtime.Visible" ,"CheckableRT","0"
   call RexxInstDeSelect    objectid,"Runtime.Visible"
   call RexxInstDeSelect objectid,"RuntimeUrls"
end

/* See if the user already has the correct Runtime installed
*/
RTInstalled = 0
InstalledVersion = RexxInstResolveVariables(objectid, "{INV_Runtime:VersionNumber}", 0)
CurrentVersion   = RexxInstResolveVariables(objectid, "{Runtime:VersionNumber}", 0)
if InstalledVersion = CurrentVersion then do
   RTInstalled = 1
end

/* Set variable for response file dependency checking
*/
call RexxInstSetVariable objectid,"Java11" ,"RTInstalled", RTInstalled

/* Determine if we will check the toolkit, samples and debugger checkboxs and features
*/
/* Check for a syslevel file and the correct version
*/
if ReadSysLevel(package"\syslevel.jtk")  then do
   if (st.bSysVersion = ver) & (st.bSysModify = modify) & (RTChecked | RTInstalled) then do
      call RexxInstSetVariable objectid,"Toolkit" ,"CheckableTK","1"
      call RexxInstSelect      objectid,"Toolkit"
      call RexxInstSelect      objectid,"ToolkitConfig"

      call RexxInstSetVariable objectid,"Samples" ,"CheckableSM","1"
      call RexxInstSelect      objectid,"Samples"
      call RexxInstSelect      objectid,"SamplesConfig"

      call RexxInstSetVariable objectid,"Debugger","CheckableIC","1"
      call RexxInstSelect      objectid,"Debugger"
      call RexxInstSelect      objectid,"DebuggerConfig"

      if warp=4 then do
          call RexxInstSelect objectid,"ToolkitUrls"
          call RexxInstSelect objectid,"SamplesUrls"
          call RexxInstSelect objectid,"DebuggerUrls"
     end
      else do
           call RexxInstDeselect objectid,"ToolkitUrls"
           call RexxInstDeselect objectid,"SamplesUrls"
           call RexxInstDeselect objectid,"DebuggerUrls"
       end
   end
   else do
      call RexxInstSetVariable objectid,"Toolkit" ,"CheckableTK","0"
      call RexxInstDeselect    objectid,"Toolkit"
      call RexxInstDeselect    objectid,"ToolkitConfig"
      call RexxInstDeselect    objectid,"ToolkitUrls"

      call RexxInstSetVariable objectid,"Samples" ,"CheckableSM","0"
      call RexxInstDeselect    objectid,"Samples"
      call RexxInstDeselect    objectid,"SamplesConfig"
     call RexxInstDeselect    objectid,"SamplesUrls"

      call RexxInstSetVariable objectid,"Debugger","CheckableIC","0"
      call RexxInstDeselect    objectid,"Debugger"
      call RexxInstDeselect    objectid,"DebuggerConfig"
      call RexxInstDeselect    objectid,"DebuggerUrls"
   end
end
else do
   call RexxInstSetVariable objectid,"Toolkit" ,"CheckableTK","0"
   call RexxInstDeselect    objectid,"Toolkit"
   call RexxInstDeselect    objectid,"ToolkitConfig"
   call RexxInstDeselect    objectid,"ToolkitUrls"

   call RexxInstSetVariable objectid,"Samples" ,"CheckableSM","0"
   call RexxInstDeselect    objectid,"Samples"
   call RexxInstDeselect    objectid,"SamplesConfig"
   call RexxInstDeselect    objectid,"SamplesUrls"

   call RexxInstSetVariable objectid,"Debugger","CheckableIC","0"
   call RexxInstDeselect    objectid,"Debugger"
   call RexxInstDeselect    objectid,"DebuggerConfig"
   call RexxInstDeselect    objectid,"DebuggerUrls"
end

/* Determine if we will check the toolkit documentation checkbox and feature
*/
/* Check for a syslevel file and the correct version
*/
if ReadSysLevel(package"\syslevel.jtk")  then do
   if st.bSysVersion = ver & st.bSysModify = modify then do
      call RexxInstSetVariable objectid,"TlktDoc" ,"CheckableTD","1"
      call RexxInstSelect      objectid,"TlktDoc"
      call RexxInstSelect      objectid,"TlktDocConfig"
      if warp = 4 then do
         call RexxInstSelect     objectid,"TlktDocUrls"
      end
      else do
         call RexxInstDeselect      objectid,"TlktDocUrls"
      end
   end
   else do
      call RexxInstSetVariable objectid,"TlktDoc" ,"CheckableTD","0"
      call RexxInstDeselect    objectid,"TlktDoc"
      call RexxInstDeselect    objectid,"TlktDocConfig"
        call RexxInstDeselect   objectid,"TlktDocUrls"
   end
end
else do
   call RexxInstSetVariable objectid,"TlktDoc" ,"CheckableTD","0"
   call RexxInstDeselect    objectid,"TlktDoc"
   call RexxInstDeselect    objectid,"TlktDocConfig"
   call RexxInstDeselect     objectid,"TlktDocUrls"
end

/* Determine if we will check the Unicode Font checkbox and feature
*/
/* Check for a syslevel file and the correct version
*/
if ReadSysLevel(package"\syslevel.juf")  then do
   if (st.bSysVersion = 10) & (st.bSysModify = 0) then do
      call RexxInstSetVariable objectid,"UniFont" ,"CheckableUF","1"
      call RexxInstSelect      objectid,"UniFont"
      call RexxInstSelect      objectid,"UniFontConfig"
      call RexxInstSelect      objectid,"TTEngine"
      call RexxInstSelect      objectid,"TTEngineConfig"
   end
   else do
      call RexxInstSetVariable objectid,"UniFont" ,"CheckableUF","0"
      call RexxInstDeselect    objectid,"UniFont"
      call RexxInstDeselect    objectid,"UniFontConfig"
      call RexxInstDeselect    objectid,"TTEngine"
      call RexxInstDeselect    objectid,"TTEngineConfig"
   end
end
else do
   call RexxInstSetVariable objectid,"UniFont" ,"CheckableUF","0"
   call RexxInstDeselect    objectid,"UniFont"
   call RexxInstDeselect    objectid,"UniFontConfig"
   call RexxInstDeselect    objectid,"TTEngine"
   call RexxInstDeselect    objectid,"TTEngineConfig"
end


if ReadSysLevel(package"\syslevel.swr")  then do
   if (st.bSysVersion = 11) & (st.bSysModify = 0) & (RTChecked | RTInstalled) then do
        call RexxInstSetVariable objectid,"SwingRuntime","CheckableSRT","1"
        call RexxInstSelect  objectid, "SwingRuntime"
        call RexxInstSelect  objectid, "SwingRuntimeConfig"
   end
   else do
        call RexxInstSetVariable objectid,"SwingRuntime","CheckableSRT","0"
        call RexxInstDeselect objectid,"SwingRuntime"
        call RexxInstDeselect objectid,"SwingRuntimeConfig"
   end /* do */
end

else do
      call RexxInstSetVariable objectid,"SwingRuntime","CheckableSRT","0"
      call RexxInstDeselect objectid,"SwingRuntime"
      call RexxInstDeselect objectid,"SwingRuntimeConfig"
end /* do */

if ReadSysLevel(package"\syslevel.swt")  then do
   if (st.bSysVersion = 11) & (st.bSysModify = 0) & (RTChecked | RTInstalled) then do
        call RexxInstSetVariable objectid,"SwingToolkit","CheckableSTK","1"
        call RexxInstSelect  objectid, "SwingToolkit"
        call RexxInstSelect  objectid, "SwingToolkitConfig"
   end
   else do
        call RexxInstSetVariable objectid,"SwingToolkit","CheckableSTK","0"
        call RexxInstDeselect objectid,"SwingToolkit"
        call RexxInstDeselect objectid,"SwingToolkitConfig"
   end /* do */
end
else do
      call RexxInstSetVariable objectid,"SwingToolkit","CheckableSTK","0"
      call RexxInstDeselect objectid,"SwingToolkit"
      call RexxInstDeselect objectid,"SwingToolkitConfig"
end /* do */

if ReadSysLevel(package"\syslevel.rmi")  then do
   if (st.bSysVersion = 10) & (st.bSysModify = 0) & (RTChecked | RTInstalled) then do
        call RexxInstSetVariable objectid,"RMIIIOPToolkit","CheckableRTK","1"
        call RexxInstSelect  objectid, "RMIIIOPToolkit"
        call RexxInstSelect  objectid, "RMIIIOPToolkitConfig"
   end
   else do
        call RexxInstSetVariable objectid,"RMIIIOPToolkit","CheckableRTK","0"
        call RexxInstDeselect objectid,"RMIIIOPToolkit"
        call RexxInstDeselect objectid,"RMIIIOPToolkitConfig"
   end /* do */
end
else do
        call RexxInstSetVariable objectid,"RMIIIOPToolkit","CheckableRTK","0"
        call RexxInstDeselect objectid,"RMIIIOPToolkit"
        call RexxInstDeselect objectid,"RMIIIOPToolkitConfig"
end /* do */

return 0

/* Subroutine: ReadSysLevel
*     Input: fs - filespec of a syslevel file
*    Output: 0 = File not readable
*            1 = File readable
*
* Side Effects: Structures st and slfh created:
*               st = Syslevel Table      ( see comments below )
*             slfh = Sysleve File Header ( see comments below )
*
*
*
*
*/


ReadSysLevel: procedure expose slfh. st.
call Trace OFF
parse arg fs

   res = 0
   if stream(fs,"C","Query Exists") <> "" then do
      data = charin(fs,1,chars(fs))
      slfh.usSignature   = c2x(reverse(substr(data,1,2)))     /* special # for id of syslevel file */
      slfh.achSignature  = substr(data,3,8)                   /* string to id slf file, must be 'SYSLEVEL' */
      slfh.achJulian     = substr(data,11,5)                  /* date of version */
      slfh.usSlfVersion  = c2x(reverse(substr(data,16,2)))    /* version of syslevel file, must be 1 */
      slfh.ausReserved   = c2x(substr(data,18,16))            /* reserved */
      slfh.ulTableOffset = c2d(reverse(substr(data,34,4)))    /* offset of SYSTABLE */

      /* Calculate table start
      */
      tblst = slfh.ulTableOffset+1

      st.usSysId       = c2x(reverse(substr(data, tblst+0,2))) /* identifies system /subsytem */
      st.bSysEdition   = c2x(substr(data, tblst+2,1))          /* edition of system, eg SE=00, EE=01 */
      st.bSysVersion   = c2x(substr(data, tblst+3,1))          /* version, eg 1.00=10, 1.10=11 */
      st.bSysModify    = c2x(substr(data, tblst+4,1))          /* modify, eg 1.00=00, 1.01=01 */
      st.usSysDate     = c2x(reverse(substr(data, tblst+5,2))) /* date of system */
      st.achCsdLevel   = substr(data, tblst+7,8)               /* subsytem CSD level, eg, XR?0000_ */
      st.achCsdPrev    = substr(data, tblst+15,8)              /* as above, except for prev system */
      st.achSysName    = substr(data, tblst+23,80)             /* Title of system / subsytem (ASCIIZ) */
      st.achCompId     = substr(data, tblst+103,9)             /* component ID of subsytem */
      st.bRefreshLevel = c2x(substr(data, tblst+112,1))
      st.achType       = substr(data, tblst+113,9)             /* Null terminated type (8 chars +'\0') */
      st.usReserved    = substr(data, tblst+122,12)            /* reserved, must be 0 */
      res = 1
      call stream fs,"C","Close"
   end
return res
