/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGImageWriter;
import java.awt.image.SampleModel;
import java.security.AccessController;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPEGImageWriterSpi
extends ImageWriterSpi {
    private static String[] readerSpiNames = new String[]{"com.sun.imageio.plugins.jpeg.JPEGImageReaderSpi"};
    private boolean registered = false;

    public JPEGImageWriterSpi() {
        super("Sun Microsystems, Inc.", "0.5", JPEG.names, JPEG.suffixes, JPEG.MIMETypes, "com.sun.imageio.plugins.jpeg.JPEGImageWriter", new Class[]{ImageOutputStream.class}, readerSpiNames, true, "javax_imageio_jpeg_stream_1.0", "com.sun.imageio.plugins.jpeg.JPEGStreamMetadataFormat", null, null, true, "javax_imageio_jpeg_image_1.0", "com.sun.imageio.plugins.jpeg.JPEGImageMetadataFormat", null, null);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Standard JPEG Image Writer";
    }

    @Override
    public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
        if (this.registered) {
            return;
        }
        try {
            boolean bl = AccessController.doPrivileged(new GetPropertyAction("os.name")).startsWith("OS/2");
            AccessController.doPrivileged(new LoadLibraryAction(bl ? "jjpeg" : "jpeg"));
        }
        catch (Throwable throwable) {
            serviceRegistry.deregisterServiceProvider(this);
            return;
        }
        this.registered = true;
    }

    @Override
    public boolean isFormatLossless() {
        return false;
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        int[] nArray = sampleModel.getSampleSize();
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n >= 1 && n <= 8;
    }

    @Override
    public ImageWriter createWriterInstance(Object object) throws IIOException {
        return new JPEGImageWriter(this);
    }
}

